#include "stdafx.h"
#include "dkutilShell.h"
#include "dkutilDefined.h"

#ifdef USE_DKINGYO_SHELL_AND_COMMON_CONTROL




namespace dkutil{


/*
		fXNgbvtH_pX擾

		fXNgbvtH_̃pX擾܂B

	input
		char *pPath			: fXNgbvtH_󂯎镶|C^

	output
		bool	:  true / s false
*/

bool GetDesktopFolder( char *pPath )
{
	pPath[0] = '\0';

	ITEMIDLIST *pidl = NULL;
	IMalloc *pMalloc = NULL;
	char temp[MAX_PATH] = "";

	if FAILED( ::SHGetMalloc( &pMalloc ) ) return false;

	::SHGetSpecialFolderLocation( ::GetDesktopWindow(), CSIDL_DESKTOP, &pidl );
	::SHGetPathFromIDList( pidl, temp );

	pMalloc->Free( pidl );
	pMalloc->Release();

	strncpy( pPath, temp,MAX_PATH );

	return true;
}
/*

		V[gJbg

		V[gJbg𐶐܂B

	input
		char *pShortcutFile		: 쐬[*.lnk]̃tpX
		char *pDescription		: fBXNvV
		char *pTargetFile		: Ñt@C̃tpX

	output
		bool	:  true / s false

*/
bool CreateLinkFile( char *pShortcutFile, char *pDescription, char *pTargetFile )
{
	HRESULT hr;
	WCHAR wShortcutFile[MAX_PATH];
	IShellLink *pShellLink = NULL; 
	IPersistFile *pPersistFile = NULL;
	
	bool result = false;
	
	//==============================================
	// IShellLink C^[tF[X̎擾
	//==============================================
	hr = ::CoCreateInstance(
				CLSID_ShellLink,
				NULL,
				CLSCTX_ALL,
				IID_IShellLink,
				(void **)&pShellLink );
	if FAILED( hr ) goto END;
	
//	==============================================
	 //IPersistFileC^[tF[X̎擾
	//==============================================
	hr = pShellLink->QueryInterface( IID_IPersistFile, (void **)&pPersistFile );
	if FAILED( hr ) goto END;
	
	//==============================================
	// Ñt@C̃pXZbg
	//==============================================
	hr = pShellLink->SetPath( pTargetFile );
	if FAILED( hr ) goto END;

	//==============================================
	// V[gJbgt@C̃fBXNvVZbg
	//==============================================
	hr = pShellLink->SetDescription( pDescription );
	if FAILED( hr ) goto END;

	::MultiByteToWideChar( CP_ACP, 0, pShortcutFile, -1, wShortcutFile, MAX_PATH );
	hr = pPersistFile->Save( wShortcutFile, true );
	if FAILED( hr ) goto END;

	result = true;

END:
	if ( pShellLink != NULL ) pShellLink->Release();
	if ( pPersistFile != NULL ) pPersistFile->Release();

	return result;
}



}//end of dkutil namespace


#endif //end of USE_DKINGYO_SHELL_AND_COMMON_CONTROL