#ifndef __dkutil_Registry_h__
#define __dkutil_Registry_h__

#include "dkutilFileSystem.h"

namespace dkutil{


inline bool DirectoryPlusRegistryKeyName(std::string &get,const char *key)
{
	return DirectoryPlusFileName(get,key);
}


class scoped_create_registry{
	HKEY mKey;
	bool mCreated;
	LONG mResult;
	void __init_(){
		mResult = -1;//ԈႢƂӖť
		mCreated = false;
		memset(&mKey,0,sizeof(mKey));
	}
public:
	bool reset(
		HKEY hKey, // handle of an open key
		LPCTSTR lpSubKey, // address of subkey name
		DWORD Reserved, // reserved
		LPTSTR lpClass, // address of class string
		DWORD dwOptions, // special options flag
		REGSAM samDesired, // desired security access
		LPSECURITY_ATTRIBUTES lpSecurityAttributes,// address of key security structure
		//PHKEY phkResult, // address of buffer for opened handle
		LPDWORD lpdwDisposition // address of disposition value buffer
	){

		close();
		


		LONG r= RegCreateKeyEx(
			hKey, // handle of an open key
			lpSubKey, // address of subkey name
			Reserved, // reserved
			lpClass, // address of class string
			dwOptions, // special options flag
			samDesired, // desired security access
			lpSecurityAttributes,// address of key security structure
			(PHKEY)&mKey,
			//phkResult, // address of buffer for opened handle
			lpdwDisposition // address of disposition value buffer
		);
		//ʂB
		mResult = r;
		if(r == ERROR_SUCCESS){
			return false;
		}
		mCreated = true;
		return true;
	}



	scoped_create_registry(
		HKEY hKey, // handle of an open key
		LPCTSTR lpSubKey, // address of subkey name
		DWORD Reserved, // reserved
		LPTSTR lpClass, // address of class string
		DWORD dwOptions, // special options flag
		REGSAM samDesired, // desired security access
		LPSECURITY_ATTRIBUTES lpSecurityAttributes,// address of key security structure
		//PHKEY phkResult, // address of buffer for opened handle
		LPDWORD lpdwDisposition // address of disposition value buffer
		){
		try{
			__init_();
			reset(
				hKey,
				lpSubKey, // address of subkey name
				Reserved, // reserved
				lpClass, // address of class string
				dwOptions, // special options flag
				samDesired, // desired security access
				lpSecurityAttributes,// address of key security structure
				//phkResult, // address of buffer for opened handle
				lpdwDisposition // address of disposition value buffer
			);
		}catch(...){
			close();
			throw;
		}
	}
	scoped_create_registry(){
		__init_();
	}
	virtual ~scoped_create_registry(){
		close();
	}
	bool empty()const{return !mCreated;}
	const HKEY &handle()const{return mKey;}
	HKEY handle(){return mKey;}
	const LONG state()const{return mResult;}
	void close(){
		if(mCreated){
			RegCloseKey(mKey);
			mCreated=false;
			mResult = -1;
		}
	}

};

class scoped_open_registry{
	HKEY mKey;
	bool mCreated;
	LONG mResult;
	void __init_(){
		mResult = 1;//ԈႢƂӖť
		mCreated = false;
		memset(&mKey,0,sizeof(mKey));
	}
public:
	bool reset(
		HKEY hKey,// handle of an open key
		LPCTSTR lpSubKey, // address of name of subkey to open
		DWORD ulOptions, // reserved
		REGSAM samDesired // security access mask
		//PHKEY phkResult // address of handle of open key

	){

		close();

		LONG r= RegOpenKeyEx(
			mKey,// handle of an open key
			lpSubKey, // address of name of subkey to open
			ulOptions, // reserved
			samDesired, // security access mask
			&mKey
			//phkResult // address of handle of open key

		);
		//ʂB
		mResult = r;
		if(r == ERROR_SUCCESS){
			return false;
		}
		mCreated = true;
		return true;
	}



	scoped_open_registry(
			HKEY hKey,// handle of an open key
		  LPCTSTR lpSubKey, // address of name of subkey to open
			DWORD ulOptions, // reserved
			REGSAM samDesired // security access mask
			//PHKEY phkResult // address of handle of open key

		){
		try{
			__init_();
			reset(
				hKey,
				lpSubKey, // address of name of subkey to open
				ulOptions, // reserved
				samDesired // security access mask
				//phkResult // address of handle of open key
			);
		}catch(...){
			close();
			throw;
		}
	}
	scoped_open_registry(){
		__init_();
	}
	virtual ~scoped_open_registry(){
		close();
	}
	bool empty()const{return !mCreated;}
	const HKEY &handle()const{return mKey;}
	HKEY handle(){return mKey;}
	const LONG state()const{return mResult;}
	void close(){
		if(mCreated){
			RegCloseKey(mKey);
			mCreated=false;
			mResult = -1;
		}
	}

};

//***********************************
//݌郌WXgn
//gotoƂgp΂ƃLCȃvOɃinYB
//Atry catchȁH
//ȂA֐ނ̃eXg͍sĂ܂B(I
//ꂩeXgĂꂢOOG(2002/12/7)


//WXgn
extern bool SaveRegData(LPCTSTR lpSubKey,LPCTSTR lpValueName,
				 DWORD dwType,CONST BYTE *lpData,	DWORD cbData);
extern bool GetRegData(LPCTSTR lpSubKey,LPTSTR lpValueName,LPDWORD lpType,
				LPBYTE lpData,LPDWORD lpcbData);
extern bool DeleteValueRegData(LPCTSTR lpSubKey,LPTSTR lpValueName);
extern bool DeleteRegData(LPCTSTR lpSubKey);





class RegistryManager{
	std::string mPath;
	HKEY mRootKey;
	HKEY mKey;
	bool mInited;
public:
	///[hʁB
	struct ResultRegistryData{
		///
		bool result;
		DWORD ResultType;
		///f[^̃^Cv
		DWORD DataType;
		///[hTCY
		union{
			DWORD uniLoadedSize;
			DWORD uniNeedSize;
		};
	};
	RegistryManager(const char *path,HKEY key=HKEY_CURRENT_USER){
		DKUTIL_STRUCTURE_INIT(mRootKey);
		DKUTIL_STRUCTURE_INIT(mKey);
		mInited = false;
		//ZeroMemory(&mRootKey,sizeof(mRootKey));
		//ZeroMemory(&mKey,sizeof(mKey));

	}
	virtual ~RegistryManager(){
		close();
	}
	///JgpXύXBĊTO̓I[vĊB
	bool reset(const char *path,HKEY key){
		//NeBJZNVŃbN
		scoped_criticalsection lock();
		close();
		mPath = path;
		mRootKey=key;
		mInited = true;//tO𗧂Ă
	}
	/*!
	@param Section[in] ZNV
	@param Key[in] L[̖O
	*/
	///tH_쐬
	bool CreateFolder(const char *Section){
		if(empty()) return false;
		if(!Section) return false;
		std::string strTemp = mPath;
		DirectoryPlusRegistryKeyName(strTemp,Section);

		DWORD dwDisposition;
		scoped_create_registry reg(
						mRootKey,	strTemp.c_str(),
						0, "", REG_OPTION_NON_VOLATILE,
						KEY_ALL_ACCESS, NULL, &dwDisposition
		);
		if(reg.empty()) return false;
		return true;
	}
	/*!
	@param Section[in] ZNV
	@param Key[in] L[̖O
	*/
	///tH_폜B
	bool DeleteFolder(const char *Section){
		if(empty()) return false;
		if(!Section) return false; 
		scoped_open_registry reg(
			mRootKey,mPath.c_str(),
			0, KEY_ALL_ACCESS);
		//G[`FbNB
		if(reg.empty()) return false;
		
		if (::RegDeleteKey (reg.handle(), Section) != ERROR_SUCCESS)
		{
			return false;
		}
		return true;
	}
	/*!
	@param Section[in] ZNV
	@param Key[in] L[̖O
	*/
	///L[폜B
	bool DeleteKey (const char *Section,const char *Key)
	{
		if(empty()) return false;
		if(!(Section || Key)) return false;
		std::string strTemp = mPath;
		DirectoryPlusRegistryKeyName(strTemp,Section);
		
		scoped_open_registry reg(
			mRootKey,strTemp.c_str(),0,KEY_WRITE);
		if(reg.empty()) return false;
		

		if (::RegDeleteValue (reg.handle(), Key) != ERROR_SUCCESS)
		{
			return false;
		}
		return true;
	}
	/*!
	@param Section[in] ZNV
	@param Key[in] L[̖O
	@param buff[in][out] obt@ւ̃|C^Băobt@ɏ܂B
	@param buffsize[in] obt@̃TCY
	*/
	///@return ResultRegistryDataAB(QƂŕԂق悢̂ȂH悭Ȃ̂ť
	ResultRegistryData GetData(const char *Section,const char *Key,void *buff,size_t buffsize)
	{
		if(empty()) goto fail;
		if(buff==NULL || buffsize==0 || !Section || !Key) goto fail;
		ResultRegistryData lResult;
		DKUTIL_STRUCTURE_INIT(lResult);
		{

			std::string strTemp = mPath;
			DirectoryPlusRegistryKeyName(strTemp,Section);

			scoped_open_registry reg;
			reg.reset(mRootKey,strTemp.c_str() , 0, KEY_READ);
			if(reg.empty()){
				goto fail;
			}
			
			BYTE *ptr;
			ptr = (BYTE *)buff;
			DWORD dwSize;
			dwSize = buffsize;
			DWORD dwType;
			LONG lR;
			lR = ::RegQueryValueEx (reg.handle(), Key, NULL, &dwType, ptr, &dwSize);
			if (lR != ERROR_SUCCESS)
			{
				goto fail;
			}


			//ʂ
			lResult.result = true;
			lResult.ResultType = lR;
			lResult.DataType = dwType;
			lResult.uniLoadedSize = dwSize;
			return lResult;
		}
	fail:
		//ʂ͎s
		lResult.result = false;
		return lResult;
	}
	/*!
	@param Section[in] ZNV
	@param Key[in] L[̖O
	@param buff[in][out] obt@ւ̃|C^Băobt@ɏ܂B
	@param buffsize[in] obt@̃TCY
	@param dwType[in] MSDNRegSetValueEx֐dwTypẻɏĂ̂ĂB
	*/
	///f[^i[B
	bool SetData (const char *Section,const char *Key, 
		const void *data,size_t datasize,DWORD dwType)
	{	
		if(empty()) return false;
		if(data==NULL || datasize==0 || !Section || !Key) return false;
		std::string strTemp = mPath;
		DirectoryPlusRegistryKeyName(strTemp,Section);

		HKEY refHandle;
		scoped_open_registry oreg(mRootKey,strTemp.c_str(),0,KEY_WRITE);
		scoped_create_registry creg;

		if(oreg.empty()){
			DWORD dwDisposition;
			creg.reset(mRootKey,strTemp.c_str(),
				0,"" , REG_OPTION_NON_VOLATILE,
					KEY_ALL_ACCESS, NULL,  &dwDisposition) ;
			if (creg.empty())
			{
				 return false;
			}
			refHandle = creg.handle();
		}else{
			refHandle = oreg.handle();
		}

		if (::RegSetValueEx (refHandle, Key, NULL, dwType,
				(const BYTE*)data, datasize)
				!=	ERROR_SUCCESS)
		{
			return false;
		}
		return true;
	}
	///CloseB
	void close(){
		//NeBJZNVŃbN
		scoped_criticalsection lock;

		DKUTIL_STRUCTURE_INIT(mRootKey);
		DKUTIL_STRUCTURE_INIT(mKey);
		mPath.clear();
		mInited = false;
	}
	///@return ĂȂtrue
	bool empty()const{return !(mInited);}


};






}//end of dkutil namespace





#endif