#include "stdafx.h"
#include "dkutilDefinedC.h"
#include "dkutilOS.h"

namespace dkutil{


int GetOSVersion(){
	
	OSVERSIONINFO os;
	os.dwOSVersionInfoSize=sizeof(os);

	 
	if(GetVersionEx(&os)==0)
		return -1;

	if(os.dwMajorVersion<=3){
		//ƂWindows3.1gnȂc܂A
		//ւԈĂcQlɂ͂Ȃ悤
		if(os.dwMinorVersion==51){
			return enuWindowsNT3_51;
		}
		if(os.dwPlatformId==VER_PLATFORM_WIN32s)
			return enuWindows3_1;
	}

	switch(os.dwPlatformId){
		case VER_PLATFORM_WIN32s:
			return enuWindows3_1;
			
		case VER_PLATFORM_WIN32_WINDOWS:
			if(os.dwMajorVersion >=4){
				if(os.dwMinorVersion<10)
					return enuWindows95;
				if(os.dwMinorVersion<90)
					return enuWindows98;
				if(os.dwMinorVersion>=90)
					return enuWindowsMe;
				else
					return -2;
			}
			if(os.dwMajorVersion==5){//Ô
				if(os.dwMinorVersion==0)
					return enuWindows2000;
				if(os.dwMinorVersion>0)
					return enuWindowsXP;
				else
					return -2;
			}
				
		
		case VER_PLATFORM_WIN32_NT:
			if(os.dwMajorVersion==4)
				return enuWindowsNT4_0;
			
			if(os.dwMajorVersion==5){
				if(os.dwMinorVersion==0)
					return enuWindows2000;
				if(os.dwMinorVersion>0)
					return enuWindowsXP;
				else
					return -2;
			}
			return -2;
		default:
			return -2;
	}
	return -1;
}

#if !(_MSC_VER <= 1200) 
// OS ̖O擾
int GetOSVersionEx(int *Extension)
{
	int result=-1;
	int ext=0;
	OSVERSIONINFOEX osvi={0};
	BOOL SucceededFlag=FALSE;

	
	osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);

	SucceededFlag = GetVersionEx((OSVERSIONINFO *)&osvi);
	if (!SucceededFlag) {
		osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
		if(!GetVersionEx((OSVERSIONINFO *)&osvi)){
			return -1;
		}
	}

	switch (osvi.dwPlatformId)
	{
	case VER_PLATFORM_WIN32_NT:
		if (osvi.dwMajorVersion <= 4) {
			result = enuWindowsNT4_0;
		}

		if (osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 0) {
			result = enuWindows2000;
		}
		if (osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 1){
			result = enuWindowsXP;
		}
		if (SucceededFlag) {		// GetVersionEx ֐̏g
			if (osvi.wProductType == VER_NT_WORKSTATION) {

				if (osvi.wSuiteMask & VER_SUITE_PERSONAL) {
					ext = edkOSE_HomeEdition;
				}else {
					ext = edkOSE_Professional;
				}
			}else if (osvi.wProductType == VER_NT_SERVER) {
				if (osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 1) {
					result = enuWindows_NET;
				}

				if (osvi.wSuiteMask & VER_SUITE_DATACENTER) {
					ext = edkOSE_DataCenter_Server;
				}else if (osvi.wSuiteMask & VER_SUITE_ENTERPRISE) {
					if( osvi.dwMajorVersion == 4 ) {
						ext = edkOSE_Advanced_Server;
					}
					else {
						ext = edkOSE_Enterprise_Server;
					}
				}
				else if (osvi.wSuiteMask == VER_SUITE_BLADE) {
					ext = edkOSE_Web_Server;
				}
				else {
					ext = edkOSE_Server;
				}
			}
		}
		else {		//  Windows NT ł́AWXgg
			HKEY hKey;
			char szProductType[80];
			DWORD dwBufLen;

			RegOpenKeyEx(HKEY_LOCAL_MACHINE, 
						 "SYSTEM\\CurrentControlSet\\Control\\ProductOptions", 
						 0, KEY_QUERY_VALUE, &hKey );
			RegQueryValueEx(hKey, "ProductType", NULL, NULL, 
							(LPBYTE)szProductType, &dwBufLen);
			RegCloseKey(hKey);

			if (lstrcmpi("WINNT", szProductType) == 0) {
				ext= edkOSE_Professional;
			}
			if (lstrcmpi("LANMANNT", szProductType) == 0) {
				ext = edkOSE_Server;
			}
			if (lstrcmpi( "SERVERNT", szProductType) == 0) {
				ext = edkOSE_Advanced_Server;
			}
		}

		break;

	case VER_PLATFORM_WIN32_WINDOWS:
		if (osvi.dwMajorVersion == 4 && osvi.dwMinorVersion == 0) {
			result = enuWindows95;
			if (osvi.szCSDVersion[1] == 'C' || osvi.szCSDVersion[1] == 'B') {
				ext = edkOSE_OSR2;
			}
		}

		if (osvi.dwMajorVersion == 4 && osvi.dwMinorVersion == 10) {
			result = enuWindows98;
			if (osvi.szCSDVersion[1] == 'A') {
				ext = enuOSE_SE;
			}
		}

		if (osvi.dwMajorVersion == 4 && osvi.dwMinorVersion == 90) {
		 	result = enuWindowsME;
		}

		break;
	default:
		return -1;
	}//end of switch

	if(Extension){
		*Extension = ext;
	}

	return result;
}

#endif


}//end of dkutil namespace

