
/*!
@since 2003/10/17
@auther d
@note
Licence is BSD Licence

*/


#ifndef _dkutilFSWin32Common__h_
#define _dkutilFSWin32Common__h_

#ifdef USE_DKINGYO_INCLUDE_SETTING_LIKE_BOOST
#	include <dkutil/dkutilDefined.h>
#	include <dkutil/dkutilString.h>
#else
#	include "dkutilString.h"
#	include "dkutilDefined.h"
#endif

namespace dkutil{
		

/// pXAgq̊Jnʒu擾
/// t@C̖t@C̍Ō '.' ܂łAgqƔf
///@return NULLƊgq͔ʕs\B܂A^ꂽ̍ŏ̃AhXԂꂽꍇʕs\
///
inline char *GetFileExtension( const char *PathName )
{

	char *p;
	char *get_tail;

	get_tail = strtail( PathName );
	for( p = get_tail; p >= PathName; p-- ) // ̍Ōォŏ܂
	{
		if ( ('\\'==*p) && !isJMS(PathName,p-PathName) )
			return get_tail; // t@C͂܂

		if ( '.' == *p )
			return p+1; // '.' 𔭌
	}
	return get_tail; // gqȂ
}//GetFileExtension



///t@CTCY𓾂B
/*!
@param str[in] t@C̖O(pXj
@param high[out] t@C̃TCY̏ʃ_u[h(MAXDWORDlow𑫂ƃt@CTCYɂȂB
@param low[out] t@CTCỶʃ_u[h
*/
///t@CTCY𓾂BbNꂽt@Cł邱Ƃôŕ֗OOG
inline bool GetFileSizeHighLow(const char *str,DWORD *high,DWORD *low){
	WIN32_FIND_DATA findData={0};
	HANDLE hFind=NULL;
	// t@CTCY擾
	if((hFind = FindFirstFile(str,&findData)) == INVALID_HANDLE_VALUE){
		return false;
	}

	//t@C̃TCY
	*high = findData.nFileSizeHigh;
	*low = findData.nFileSizeLow;
	FindClose(hFind);
	return true;
}
/*!
@param str[in] t@C̖O(pXj
@param  *GetSize[out] t@C̃TCYULONGLONG^̕ϐւ̃|C^
*/
///t@CTCY𓾂BdGetFileSizeHighLow̃bp[
inline bool GetFileSize(const char *str,ULONGLONG *GetSize){
	DWORD High=0,Low=0;
	bool result=false;
	result=GetFileSizeHighLow(str,&High,&Low);
	*GetSize = ( High * MAXDWORD ) + Low;
	return result;
}

/*!
ӁFSGBȉ̃t@CTCY𓾂邱ƂoBULONG_MAX bytełˁH<br>
@return t@CTCYԂB0dGetFileSize֐s,܂͖4GBȏi ULONG_MAX byteȏ)̃t@ĈƂ\B
*/
///t@CTCY𓾂idGetFileSizẽbp[)@ULONG_MAX byteȉ̃t@Cp
inline DWORD GetFileSizeMini(const char *str){
	ULONGLONG Get;
	if(false==GetFileSize(str,&Get)) return 0;
	if(ULONG_MAX < Get) return 0;
	return static_cast< DWORD >(Get);
}

/*!

@param data[in] t@C̃f[^ւ̃|C^(void *)ɃLXgĂԂłB
@param size[in] t@C̃f[^̃TCY@(ރTCY)
@param fname[in] t@C̖O
@param mode[in] ftHg="wb" I[v[h ڂMSDNfopen֐I
@return true= false=s

*/
///fopeñt@C֐găoCiZ[usB
inline bool SaveBinary(void *data,int size,char *fname,char *mode="wb"){//="wb"
	FILE *fp;
	fp = fopen( fname , mode ) ;//wb
	if(fp==NULL) return false;
	fwrite( data , size  , 1 , fp ) ;
	//fwrite( data , sizeof(size)  , 1 , fp ) ;
	fclose( fp ) ;
	return true;
}

/*!
@param data[out] t@C̃f[^̃obt@ (void *)ɃLXgĂԂłB
@param size[in] t@C̃f[^̃obt@TCY@(ǂݍރTCY)
@param fname[in] t@C̖O
@param mode[in] ftHg="rb" I[v[h ڂMSDNfopen֐I
@return true= false=s
*/
///oCif[^ɓǂݍށBSaveBinary()Ƒ
inline bool LoadBinary(void *data,int size,char *fname,char *mode ){//="rb"
	FILE *fp ;
	fp = fopen( fname , mode ) ;//rb
	if(fp==NULL)return false;
	fread( data ,  size , 1 , fp ) ;
	//fread( data , sizeof(size)  , 1 , fp ) ;
	fclose( fp ) ;
	return true;
}
	
/*!
Win32APĨt@Cn֐găZ[uA[hsB
@param filename[in] t@Cl[ F"sample.txt" 
@param filedata[in] t@C̃f[^
@param size[in] t@C̃f[^̃TCY(oCgP)
@return edk_SUCCEEDEDȊOG[
@note
GetLastError()ŃG[擾ł܂B

*/ 
extern int SaveFile(const char *filename,const void *filedata,size_t size);

/*!
@param filename[in] t@Cl[ F"sample.txt" 
@param filedata[in] t@C̃f[^
@param size[in] t@C̃f[^̃TCY(oCgP)
@param GetReadSize[in] ۂɓǂݍ񂾃TCY
@return edk_SUCCEEDEDȊOG[
@note
GetLastError()ŃG[擾ł܂B<br>
ӁFG[̏ꍇA̖߂l܂MpȂŁAVISUAL_LASTERROR()̃}NgĂ݂ĂB<br>

*/
extern int LoadFile(const char *filename,void *Buff,size_t BuffSize,DWORD *GetReadSize);
	
/*!
f[^Z[u:<br>
f[^ƈÍăZ[u܂B<br>
Ȃ̂ŁAoCiGfB^ŊJĂꌩ܂B<br>
@param	*pFile[in]			: f[^
@param	*pData[out]			: f[^ւ̃|C^
@param	Size[in]	: f[^TCY
@return	  true / s false
*/
extern bool SaveData( char *pFile, void *pData, unsigned long Size );
/*!
f[^[h:dkutil::SaveData()ŕۑf[^[h܂B
@param *pFile[in]			: f[^
@param *pData[out]			: f[^ւ̃|C^
@param Size[in]	: f[^TCY
@return :  true / s false

*/
extern bool LoadData( char *pFile, void *pData, unsigned long Size );



///t@Ĉ݌̂͂II
inline bool FileExist(const char *s){
	return (::GetFileAttributes(s) != 0xFFFFFFFF);
}
/*!
t@C݃`FbNt@C̑݃`FbN܂B
@param	 *pFile[in]		: `FbNt@C
@return ݂遁true / ݂Ȃ = false
@note
tH_ꂿႤIH
*/
inline bool FileAndFolderExist( const char *pFile )
{
	WIN32_FIND_DATA wfd;
	//  t@Cnh擾
	HANDLE hFile = ::FindFirstFile( pFile, &wfd );
	// ł`FbN
	bool bRet = (hFile != INVALID_HANDLE_VALUE);
	// nhN[Y
	::FindClose( hFile );
	return bRet;
}
/*!
tH_tH_̐܂B
@param	 *pPath[in]		: tH_pX
@return	:  true / s false
*/
extern bool CreateDirectory( const char *pPath );



/*!
	CD̃{[x:<br>
	Cӂ̃{[xbc܂B<br>
@param		*pLabel[in]	: {[x
@param		*pPath[in]		: Ώۂ̃{[xhCůi[

@return				:  true / s false
*/
extern bool CheckCDVolumeLabel( char *pLabel, char *pPath ,size_t pPathSize);

/*!
t@CRs[:<br>
	t@CRs[s܂B<br>
	t@CʏɂȂ܂̂ŁA
	CDRs[ꂽꍇ͓ǎp
	܂B<br>
@param	*pSrc[in]	: Rs[
@param	*pDst[in]	: Rs[
@param bRewrite[in] trueƁA㏑܂B
@return :  true / s false
*/
inline bool CopyFileFromCD( LPCTSTR pSrc, LPCTSTR pDst ,bool bRewrite=false){
	//	 Rs[
  if ( ::CopyFile( pSrc, pDst, !(bRewrite) ) )
	{
	// t@Cʏɂ
      return (::SetFileAttributes( pDst, FILE_ATTRIBUTE_NORMAL ) != false);
  }
  return false;
}

inline bool CheckDrive(BYTE c){
	DWORD drive = ::GetLogicalDrives();
	if(!isAlpha(c)) throw std::invalid_argument("萔c[́I");
	c =(BYTE) tolower((int)c);
	c -= 'a';
	DWORD mask =(DWORD)pow(2,c);
	if(drive & mask){
		return true;
	}
	return false;
}

}//end of dkutil namespace








#endif //end of include once 
