
/*!
@since 2003/10/17
@auther d
@note
Licence is BSD Licence
*/



#include "stdafx.h"
#include "dkutilFSWin32Common.h"

namespace dkutil{



//ėpHWin32APIpۑ֐B
int SaveFile(const char *filename,const void *filedata,size_t size){
	HANDLE hFile;
	hFile = CreateFile(filename, GENERIC_WRITE, 0, 0, 
					OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if(hFile==INVALID_HANDLE_VALUE){
		//MB("CreateFile FAILED");
		//VISUAL_LASTERROR();//G[\}N
		return edk_FAILED;
	}
	SetFilePointer(
		hFile,    // t@Cnh 
		0,    // t@C|C^ړ鋗
		0,    // USrbg̏ʂRQrbg 
		FILE_BEGIN     // ړ̎d 
	   );
	DWORD dwAccBytes;
	WriteFile(hFile, filedata, size , &dwAccBytes, NULL);
	SetFilePointer(hFile,size,0,FILE_BEGIN);
	SetEndOfFile(hFile);
	FlushFileBuffers(hFile);
	//wsprintf(szTitle, szTitle_org, szFile);
	//SetWindowText(hEdit, szTitle);
	if(CloseHandle(hFile) == 0){
		//MB("CloseHandle FAILED");
		 //VISUAL_LASTERROR();
		 return edk_FAILED;
	}
	return edk_SUCCEEDED;
}

//ėpHHȂH
int LoadFile(const char *filename,void *Buff,size_t BuffSize,DWORD *GetReadSize)
{
	HANDLE hFile;
	DWORD dwSize;//t@CTCY
    DWORD dwAccBytes;//ۂɓǂݍ񂾃oCgTCYH

	hFile = CreateFile(filename, GENERIC_READ, 0, 0, //OPEN_ALWAYS,
		OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL, NULL);
  if(INVALID_HANDLE_VALUE==hFile){
		//VISUAL_LASTERROR();
		return edk_FileNotFound;
	}
	dwSize = ::GetFileSize(hFile, NULL);
    
  SetFilePointer(hFile, 0, 0, FILE_BEGIN);

  ReadFile(hFile, Buff, dwSize, &dwAccBytes, NULL);
	*GetReadSize = dwAccBytes;
    if(CloseHandle(hFile) == 0){
		 //ODS("CloseHandle FAILED");
		 //VISUAL_LASTERROR();
		return edk_FAILED;
	}
	return edk_SUCCEEDED;
}
	

bool SaveData( char *pFile, void *pData, unsigned long Size )
{
	bool result = false;
	unsigned char *p = (unsigned char *)pData;
	char *guid = "LSD";
	char key = (char)(Size&0xFF);
	FILE *fp = NULL;

	// t@CI[v
	fp = fopen( pFile, "wb" );
	if ( fp == NULL ) goto END;

	// ʎq
	fwrite( guid, sizeof(char), 4, fp );

	// f[^TCY
	fwrite( &Size, sizeof(unsigned long), 1, fp );

	// f[^o
	while ( Size-- )
	{
		// ȒPȈÍ
		char data = *p++;
		data ^= key++;
		char temp = 0;
		temp |= (char)((data&0x0F)<<4);
		temp |= (char)((data&0xF0)>>4);

		fputc( temp, fp );
	}

	result = true;

END:
	if ( fp != NULL ) fclose( fp );

	return result;
}


bool LoadData( char *pFile, void *pData, unsigned long Size )
{
	bool result = false;
	unsigned char *p = (unsigned char *)pData;
	char guid[4] = "";
	unsigned long SizeTemp = 0;
	char key = 0;
	FILE *fp = NULL;

	//ʂɂȂ^^;
	//Luna::ResetCurrentDirectory();

	 //t@CI[v
	fp = fopen( pFile, "rb" );
	if ( fp == NULL ) goto END;

	// ʎq
	fread( guid, sizeof(char), 4, fp );
	if ( strcmp( guid, "LSD" ) ) goto END;

	// f[^TCY
	fread( &SizeTemp, sizeof(unsigned long), 1, fp );
	if ( SizeTemp != Size ) goto END;

	// t@CTCYL[
	key = (char)(Size&0xFF);
	unsigned long i;
	// f[^ǂݏo
	for ( i = 0; i < Size; i++ )
	{
		// ȒPȈÍ
		char temp = (char)fgetc( fp );
		char data = 0;
		data |= (char)((temp&0x0F)<<4);
		data |= (char)((temp&0xF0)>>4);
		data ^= key++;

		p[i] = data;
	}

	result = true;

END:
	if ( fp != NULL ) fclose( fp );

	return result;
}

bool CreateDirectory( const char *pPath )
{
	SECURITY_ATTRIBUTES attr={0};
	char work[MAX_PATH] = "";
	unsigned long n = 0;
	unsigned long len = strlen(pPath);
	
	while ( n < len )
	{
		 //tH_擾
		while ( n < len )
		{
			if ( (pPath[n] == '\\') && (n != '\0') )
			{
				if ( work[n-1] != ':' )
				{
					break;
				}
			}
			work[n] = pPath[n];
			n++;
		}
		work[n] = '\0';

		 //tH_쐬
		attr.nLength = sizeof(SECURITY_ATTRIBUTES);
		attr.lpSecurityDescriptor = NULL;
		attr.bInheritHandle = false;

		::CreateDirectory( work, &attr );

		work[n++] = '\\';
	}
	
	return true;
}
	
bool CheckCDVolumeLabel( char *pLabel, char *pPath ,size_t pPathSize)
{
	// ShCu
	for ( char i = 'A'; i <= 'Z'; i++ )
	{
		char Drive[8];
		_snprintf( Drive,8, "%c:\\", i );

		// CD-ROM
		if ( ::GetDriveType( Drive ) == DRIVE_CDROM )
		{
			unsigned long SerialNo;
			unsigned long MaximumComponentLength;
			unsigned long FileSystemFlag;
			char FileSystemName[256];
			char szVolumeLabel[256] = "NO CDROM";

			 //{[x擾
			::GetVolumeInformation(
					Drive,
					szVolumeLabel,
					512,
					&SerialNo,
					&MaximumComponentLength,
					&FileSystemFlag,
					FileSystemName,
					512 );
			if ( !strcmp( pLabel, szVolumeLabel ) )
			{
				strncpy( pPath, Drive ,pPathSize);
				return true;
			}
		}
	}

	return false;
}



}//end of dkutil namespace



