#ifndef _dkutil_Dialog__h_
#define _dkutil_Dialog__h_

namespace dkutil{
	
///J[I_CAOJ[I_CAOJF̎擾܂B
extern bool OpenColorDialog(COLORREF *GetAndSetColor,HWND WindowHandle=NULL);

/*!
@param	 *pR[out]	: ԐFi[AhX
@param	 *pG[out]	: ΐFi[AhX
@param	 *pB[out]	: Fi[AhX
@param WindowHandle[in] Window̃nhBiꍇNULLOK
@param  true / s false
*/
///COLORREF\̔łWrapper
inline  bool OpenColorDialog( long *pR, long *pG, long *pB ,HWND WindowHandle=NULL)
{
	COLORREF color=RGB(*pR,*pG,*pB);
	bool r = OpenColorDialog(&color,WindowHandle);
	*pR = (color>>16) & 0xFF;
	*pG = (color>> 8) & 0xFF;
	*pB = (color>> 0) & 0xFF;
	return r;
}




///RGUTRIPLEOpenColorDialog
inline bool OpenColorDialog(RGBTRIPLE *color_tag,HWND WindowHandle=NULL){
	long r,g,b;
	bool result = OpenColorDialog(
		(long *)&r,
		(long *)&g,
		(long *)&b,
		WindowHandle);
	color_tag->rgbtRed = (BYTE)r;
	color_tag->rgbtGreen = (BYTE)g;
	color_tag->rgbtBlue = (BYTE)b;
	return result;
}
///RGUQUADOpenColorDialogہAAlphal邩͒NmȂ
inline bool OpenColorDialog(RGBQUAD *QuadColor,HWND WindowHandle=NULL){
	COLORREF *ptr = (COLORREF *)&QuadColor;
	COLORREF color = *ptr;
	bool r = OpenColorDialog(&color,WindowHandle);
	*ptr = color;
	return r;
}

/*!
t@CI[v_CAO:t@CI[v_CAO܂B
@param	*pPath[out]		: t@Ci[pX
@param size[in] pPath̃TCYB(MAX_PATHȏłȂƁAfalseԂB
@param	*pTitle[in]: _CAÕ^Cg
@param	*pFilter[in]	: gq̎w F"text(*.txt)\0*.txt\0All files(*.*)\0*.*\0\0"
@param	*pExt[in]		: gq F"text = eLXg"
@param WindowHandle[in] eEChEnhB(ʂNULLłOK
@return		:  true / s false ( t@CIȂ܂ )
@note
̊֐̓JgfBNgɑΉĂ܂B<br>
<b>JgfBNgB</b><br>
t@CJñ_CAO\āAOKہAJgfBNg
ύXĂ܂A܂ŁAfopen("OK.txt");Ƃđ΃pXœǂݍłt@C
ǂݍ߂ȂȂĂ܂ہB

*/
inline bool FileOpenDialog( char *pPath,size_t size, const char *pTitle, const char *pFilter, const char *pExt ,HWND WindowHandle=NULL)
{
	if(pPath == NULL || size < MAX_PATH){
		return false;
	}
	pPath[0] = '\0';

	//̊֐ĂяoĂ\tg̃fBNgۑB
	char path[MAX_PATH];
	memset(path,0,sizeof(path));
	::GetCurrentDirectory(MAX_PATH,path);
	
	// t@CI[v
	
	OPENFILENAME ofn;
	ZeroMemory( &ofn, sizeof(OPENFILENAME) );
	
	ofn.lStructSize		= sizeof(OPENFILENAME);
	ofn.hwndOwner		= WindowHandle;
	ofn.lpstrTitle		= pTitle;
	ofn.lpstrFilter		= pFilter;
	ofn.nFilterIndex	= 1;
	ofn.lpstrFile		= pPath;
	ofn.nMaxFile		= 256;
	ofn.lpstrDefExt		= pExt;
	ofn.lpstrInitialDir	= NULL;
	ofn.Flags			= OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;

	bool result = (::GetOpenFileName( &ofn ) != false);

	//fBNgݒ߂
	SetCurrentDirectory(path);

	return result;
}


/*!
t@CI[v_CAO:t@CI[v_CAO܂B

@param	*pPath[out]		: t@Ci[pX
@param size[in] pPath̃TCY(MAX_PATHȏłȂfalseԂ܂B)
@param	*pTitle[in]	: _CAÕ^Cg
@param	*pFilter[in]	: gq̎w
@param	*pExt[in]		: gq
@param WindowHandle[in] eEChEnhB(ʂNULLłOK
@return	bool	:  true / s false (LZꂽꍇfalse)
@note
JgfBNgɑΉĂ܂BڂFileOpenDialog()ɂāB
*/
inline bool FileSaveDialog( char *pPath, size_t size,const char *pTitle, const char *pFilter, const char *pExt ,HWND WindowHandle=NULL)
{
	if(pPath==NULL || size < MAX_PATH){
		return false;
	}
	pPath[0] = '\0';
	
	//̊֐ĂяoĂ\tg̃fBNgۑB
	char path[MAX_PATH];
	memset(path,0,sizeof(path));
	::GetCurrentDirectory(MAX_PATH,path);


	OPENFILENAME ofn;
	ZeroMemory( &ofn, sizeof(OPENFILENAME) );
	
	ofn.lStructSize		= sizeof(OPENFILENAME);
	ofn.hwndOwner		= WindowHandle;
	ofn.lpstrTitle		= pTitle;
	ofn.lpstrFilter		= pFilter;
	ofn.nFilterIndex	= 1;
	ofn.lpstrFile		= pPath;
	ofn.nMaxFile		= 256;
	ofn.lpstrDefExt		= pExt;
	ofn.lpstrInitialDir	= NULL;
	ofn.Flags			= OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY;

	bool result = (::GetOpenFileName( &ofn ) != false);

	//fBNgݒ߂
	SetCurrentDirectory(path);

	return result;
}	
	
}//end of dkutil namespace











#endif //end of include once
