/*!
@auther d
@since 2003/08/30
*/


#ifndef _dKingyoUtilClass_global_h_
#define _dKingyoUtilClass_global_h_


#include "dkutilDefined.h"
#include "dkutilAllocatePolicy.h"


namespace dkutil{



///temporary_buffer̎Ԃ͂ꂾI(
typedef boost::scoped_array<char> temporary_buffer;


///boost::scoped_arraỹpN(ǂÃNXp~̕ɂȂŉB
///@note boost::scoped_array<char>new char[]߂ǂI
/*
class scoped_buffer : protected boost::noncopyable{
	typedef size_t size_type ;
	char *mptr;
	size_type  msize;
	void Allocate(char *buf,size_type size){
		if(size==0){
			mptr= NULL;
			msize = 0;
			return;
		}
		char *tmp=(char*)DKUTIL_SAFE_REALLOC(buf,size);
		if(!tmp){
			DK_TRUE_ASSERT_OR_THROW(!tmp,std::logic_error("I"));
		}
		//O
		memset(tmp,0,size);
		mptr = tmp;
		msize = size;
	}
public:
	scoped_buffer(size_type size=0){
		Allocate(NULL,size);
	}
	~scoped_buffer(){
		clear();
	}
	///|C^𓾂
	char *get()const{return mptr;}
	///get()wrapper
	char *data()const{return get();}
	size_type capacity()const{return msize;}
	void clear(){DKUTIL_SAFE_FREE(mptr);msize=0;}
	///Lǂ
	bool isValid()const{return mptr != NULL;}
	///memoryclearăTCYύX݂ȁH
	void reset(size_type size)
  {
		DK_TRUE_ASSERT_OR_THROW(size==0,std::invalid_argument("scoped_buffer reset"));
		clear();
		Allocate(NULL,size);
  }
	size_type size()const{return msize;}
	///킢realloc݂ȁH
	void resize(size_type size){
		Allocate(mptr,size);
	}
	inline char operator [](size_type s){
		{//z͂On܂
			DK_TRUE_ASSERT_OR_THROW(s >= msize,std::overflow_error("scoped_buffer overflowȂ"));
		}
		return get()[s];
	}

};
*/


template<class IMPL>
class scoped_buffer_base: protected boost::noncopyable{
	typedef size_t size_type ;
	char *mptr;
	size_type  msize;
	IMPL ma;
	void Allocate(char *buf,size_type size){
		if(size==0){
			mptr= NULL;
			msize = 0;
			return;
		}
		char *tmp=(char*)DKUTIL_SAFE_REALLOC(buf,size);
		if(!tmp){
			DK_TRUE_ASSERT_OR_THROW(!tmp,std::logic_error("I"));
		}
		//O
		memset(tmp,0,size);
		mptr = tmp;
		msize = size;
	}
public:
	scoped_buffer_base(size_type size=0){
		//try{
			Allocate(NULL,size);
		//catch(...){
		//	clear();
		//	throw;
		//}
	}
	virtual ~scoped_buffer_base(){
		clear();
	}
	///|C^𓾂
	char *get()const{return mptr;}
	///get()wrapper
	char *data()const{return get();}
	size_type capacity()const{return msize;}
	void clear(){DKUTIL_SAFE_FREE(mptr);msize=0;}
	///Lǂ
	bool isValid()const{return mptr != NULL;}
	///memoryclearăTCYύX݂ȁH
	void reset(size_type size)
  {
		DK_TRUE_ASSERT_OR_THROW(size==0,std::invalid_argument("scoped_buffer reset"));
		clear();
		Allocate(NULL,size);
  }
	size_type size()const{return msize;}
	///킢realloc݂ȁH
	void resize(size_type size){
		Allocate(mptr,size);
	}
	inline char & operator [](size_type s){
		{//z͂On܂
			DK_TRUE_ASSERT_OR_THROW(s >= msize,std::overflow_error("scoped_buffer overflowȂ"));
		}
		return (get())[s];
	}
	inline const char & operator [](size_type s)const{
		{//z͂On܂
			DK_TRUE_ASSERT_OR_THROW(s >= msize,std::overflow_error("scoped_buffer overflowȂ"));
		}
		return (get())[s];
	}

};
///mallocngscopedobt@
typedef scoped_buffer_base<policy::allocate_policy_malloc> scoped_buffer;
///GlobalAllocgscopedobt@
typedef scoped_buffer_base<policy::allocate_policy_globalalloc> scoped_globalalloc_buffer;

/*!
Ȃăl[~OIpꂪȂł݂܂B
vectorbۂo܂B
*/
template<class T>
class offset_pusher : protected boost::noncopyable{
public:
	typedef std::size_t size_type;
private:
	T *mbuf;
	size_type moffset;
	size_type msize;
protected:
	void SetOffset(size_type o){	moffset = o;}
	size_type GetOffset(){return moffset;}
	void OffsetPlus(size_type plus){ moffset += plus;}
	
public:

	offset_pusher(const T *buff,size_type size) : mbuf(const_cast<T *>(buff)){
		moffset=0;
		msize = size;
	}
	T *now()const{return &mbuf[moffset];}
	T *get()const{
		return mbuf;
	}
	///@return gpĂT̐Ԃ
	size_type size()const{return moffset;}
	///@return 邱Ƃ̂łT̐Ԃ
	size_type capacity()const{return msize;}
	/*!
	@param item[in] 
	@param num[in] item̐
	@return edk_SUCCEEDED== othrer==s DKUTIL_SUCCEEDED()n}NŊm߂܂B
	@throw ŏ炷łɓȂƕ肫Ăꍇstd::out_of_range𓊂܂B
	*/
	///vbV邾
	int  push_back(const T *item,size_type num){
		int result=edk_SUCCEEDED;
		if(msize == moffset && //ItZbgbuffer
			msize != 0)//buffer OłȂ
		{
			throw std::out_of_range("łɃobt@͎g܂[!!");
		}
		if(msize - moffset < num){
			result = edk_Not_Satisfactory;
			num = msize - moffset;
		}
		{
			size_type i=0;
			for(;i<num;i++){
				mbuf[moffset + i] = item[i];
			}
			moffset += i;
		}
		return result;
	}
	void reset(const T *buff,size_type size){
		mbuf = const_cast<T *>(buff);
		moffset=0;
		msize = size;
	}
};


/*!
킢obt@[@NXBboost::arraystd::vectorł͏oȂƎvmemcpynS
O܂ŁAstd::vectorpĂA
vectormemcpyIȎ̂ɔɎԂ邽߁AfOB

@note
<b>KiF</b>
<ul>
<li>󂢂Ăobt@͂OŖߐsB
</ul>
*/
template<typename T,typename A=std::allocator<T> >
class buffer_base{
public:
	typedef char value_type;
  typedef size_t size_type;
  typedef ptrdiff_t difference_type;
	typedef size_t size_type;
	typedef T * pointer;
	typedef T& reference;
	typedef const T &const_reference;
	typedef const T *const_pointer;
private:
	T *buff;//obt@
	size_type mcapacity;//ee(BbytePʂł͂Ȃ)
	size_type msize;//gpς݃TCY(BbytePʂł͂Ȃ)
	bool mEmpty;//GveBH
	void _construct(){
		mEmpty=true;buff=NULL;mcapacity=0;msize=0;
	}
	A mAlloc;
	///obt@wp
	void init_buf(void *buf,size_type num){
		::memset(buf,0,sizeof(T) * num);
	}
protected:
	void SetEmpty(bool e){	mEmpty = e;}
	void SetSize(size_type s){ msize = s;}
	void SetCapacity(size_type c){mcapacity = c;}
	/*
	struct buffer_SerializeStruct{
		size_type Capacity;
		size_type Size;
		bool Empty;
		buffer_SerializeStruct(
			size_type gCapacity,size_type gSize,bool gEmpty) : 
		Capacity(gCapacity) , Size(gSize) , Empty(gEmpty){
		}	
	};
	std::size_t GetSerializeSize()const{
		size_type lsize = sizeof(buffer_SerializeStruct); 
		lsize += mcapacity + private_::serialize_offset_pusher::get_top_size();
		return lsize;
	}
	bool GetSerializeData(char *buf,std::size_t bufsize)const{
		size_type lsize = GetSerializeSize();
		if(bufsize < lsize){
			return false;
		}
		
		
		buffer_SerializeStruct dat(mcapacity,msize,mEmpty);
		private_::serialize_offset_pusher pusher(buf,bufsize);
		pusher.push_back((const char *)&dat,sizeof(dat));
		
		if(DKUTIL_FAILED(pusher.push_back((const char *)data(),capacity())))
		{
			 DEBUGASSERT(!"Ȃ͂邩I");
		}
		
		return true;
	}

	bool SetSerialize(char *buf,std::size_t size){
		clear();
		_construct();
	
		DK_TRUE_ASSERT_OR_THROW(
			(char)isLittleEndian() != buf[0],
			std::logic_error("EndianႤVACYłȂȂ(AGfBÄႢӎȂ@\pӂ낾āIH")
		);
		//炷
		buf += private_::serialize_offset_pusher::get_top_size();
		
		//datɃA^b`
		buffer_SerializeStruct *dat;
		dat = (buffer_SerializeStruct *)&buf[0];

		SetEmpty(dat->Empty);
		SetCapacity(dat->Capacity);
		SetSize(dat->Size);
		if(false==SetBuff(&buf[sizeof(buffer_SerializeStruct)],dat->Capacity)){
			DEBUGASSERT(!"ȂI");
		}
		return true;
	}
	*/
public:


	buffer_base(){_construct();}
	buffer_base(size_type size){
		_construct();
		resize(size);
	}
	///Ղ`񂷂Ƃ炭`B@Č\AYłB
	buffer_base(const buffer_base &data){
		_construct();
		if(data.isValid()){
			reserve(data.mcapacity);
			if(!data.empty()){
				SetBuff(data.buff,data.mcapacity);
			}
		}
	}

	virtual ~buffer_base(){
		clear();
	}
	///̈悩Ȃɂ炷ׂĂB
	void clear(){
		if(isValid()){
			mAlloc.deallocate(buff);
			buff=NULL;
		}
		mEmpty=true;
		mcapacity=0;
		msize=0;
	}
	///܂ł̃obt@ׂĊJāAmۂȂAÕobt@̓e͔jB
	int reserve(size_type num){
		if(num==0) return edk_FAILED;
		clear();
		buff = mAlloc.allocate(num);
		if(!buff) return edk_FAILED;
		init_buf(buff,num);
		mcapacity = num;
		return edk_SUCCEEDED;
	}
	///reserve()wrapper
	int resize(size_type size){
		return reserve(size);
	}
	/*!
	@param data[in] Rs[f[^
	@param num[in] data̐
	@return false == s
	*/
	///obt@ɃRs[Bnumcapacity()傫΂̊֐͎s
	bool SetBuff(const T *data,size_type num){
		if(! isValid())
		{//obt@mۂĂȂm
			reserve(num);
		}else{//Ƀobt@mۍς݂Ȃobt@
			init_buf(buff,num);
		}
		bool b=DKUTIL_SUCCEEDED(dkmemcpy(buff,mcapacity * sizeof(T),data,sizeof(T) * num));
		if(!b){return false;}
		mEmpty=false;
		msize = num;//Rs[ς݃TCYۑ

		return true;
	}
	/*!
	@param buffsize[in] Ŏgpobt@̃TCY
	@param str[in] 
	@throw sizeof(T) != sizeof(char)  std::logic_error𓊂B
	@return Acapacity()Ɏ܂ȂA܂ȂԂ͐؂̂ĂB(̖̎߂lfalse
	*/
	///NULLlĂ
	bool SetString(size_type buffsize,const char *str,...){
		if(sizeof(T) != sizeof(char)) throw std::logic_error("buffer_base/ sizeof(T) != sizeof(char)");
		
		temporary_buffer b(new char[buffsize]);
		SET_VA_LIST(b.get(),buffsize,str);
		size_type len = strlen(b.get());
		if( (int)(capacity() - len) <= 0)
		{//lencapacity()𒴂Ă祥
			b.get()[capacity() - 1] = NULL;
			len = capacity();
		}
		else
		{//ĂȂ̂Ȃ			
			
		}
		return SetBuff(b.get(),len);
	}
	bool SetString(const char *str,...){
		if(sizeof(T) != sizeof(char))
		{
			//sizeof(bool)==sizeof(char)ǁA
			//`Btypeid͌``BSetStrinĝ߂ɂ˂`B
			throw std::logic_error("buffer_base/ sizeof(T) != sizeof(char)");
		}
		size_type buffsize = strlen(str);
		buffsize += 256;
		temporary_buffer b(new char[buffsize]);
		/*va_list VaList;
		va_start( VaList , str ) ;
		_vsnprintf( b.get() ,buffsize, str , VaList ) ;
		va_end( VaList ) ;*/
		SET_VA_LIST(b.get(),buffsize,str);
		size_type len = strlen(b.get());
		if( (int)(capacity() - len) <= 0)
		{//lencapacity()𒴂Ă祥
			b.get()[capacity() - 1] = NULL;
			len = capacity();
		}
		else
		{//ĂȂ̂Ȃ			
			
		}
		return SetBuff(b.get(),strlen(b.get()));
		/*buffer_base b;
		b.reserve(buffsize + 1);
		SET_VA_LIST(b.data(),b.capacity(),str);
		return SetBuff(b.data(),strlen(b.data()));*/
	}
	bool isValid()const{
		if(!buff){return false;}
		return true;
	}
	bool empty()const{
		return mEmpty;
	}
	///Ɏgpς݂T̂P̗̈̐𓾂܂B( std::vectorƓ^^;
	size_type size()const{return msize;}
	///ŊmۂĂT̂P̗̈̐𓾂܂B( std::vectorƓ^^;
	size_type capacity()const{return mcapacity;}
	///size() * sizeof(T)bytePʂ̃TCYB
	size_type byte_size()const{return size() * sizeof(T);}
	///capacity() * sizeof(T)āAbytePʂ̃TCYB
	size_type byte_capacity()const{return capacity() * sizeof(T);}
	
	///댯ȍ data()... ̃|C^zՂ̂ŔɊ댯Bgpɒ
	pointer data(){return buff;}
	const_pointer data()const {return buff;}
	///std::vectoratƓłB
	reference at(size_type s){
		if(!isValid()) throw std::logic_error("buffer_base/ not initialized");
		if(size() < s) throw std::out_of_range("buffer_base::at / out of range");
		return buff[s];
	}
	const_reference at(size_type s)const{
		if(!isValid()) throw std::logic_error("buffer_base/ not initialized");
		if(size() < s) throw std::out_of_range("buffer_base::at / out of range");
		return buff[s];
	}
	///at()WrapperłB
	reference operator[](size_type s){	return at(s);}
	const_reference operator[](size_type s)const{	return at(s);}
	
	friend bool operator==(buffer_base<T,A> t1,buffer_base<T,A> t2){
		return DKUTIL_SUCCEEDED(dkmemcmp(t1.data(),t1.size(),t2.data(),t2.size()));
	}

};


///byte_buffer̎Ԃ͂ꂾI(
typedef buffer_base<BYTE> byte_buffer;
typedef buffer_base<char> char_buffer;
//typedef buffer_base<char> byte_buffer;


///file_operator̎oiEEEC`IEAWC^[tFCXȂ̂ť
/*
template<BYTE_BUFFER_POLICY=byte_buffer>
class buffer_operator{
	byte_buffer mBuff;
public:

	buffer_operator(){}
	virtual ~buffer_operator(){}
	virtual ~file_operator(){close();}
	bool reset(const char *filename,const char *mode,const char *type){
		close();
		DK_TRUE_ASSERT_OR_THROW((filename==NULL || mode==NULL || type==NULL),
			std::invalid_argument("file_operator::resetinvalid argument"));

		mfilename=filename;
		mmode = mode;
		mmode += type;
		return true;
	}
	const char *filename()const{return mfilename.c_str();}
	const char *mode()const{return mmode.c_str();}
	bool open(){
		close();
		mfp=::fopen(mfilename.c_str(),mmode.c_str());
		if(mfp==NULL) return false;
		return true;
	}
	const FILE *handle()const{return mfp;}

	size_t read(void *buf,size_t size){
		check_fp();
		return fread((buf),1,size,mfp);
	}
	size_t write(void *buf,size_t size){
		check_fp();
		return fwrite((buf),1,size,mfp);
	}
	bool eof()const{
		check_fp();
		return ( 0 != feof(mfp) );
	}
	bool error()const{
		check_fp();
		return ( 0 != ferror(mfp) );
	}
	bool seek(long offset, int origin ){
		check_fp();
		return (0 == fseek(mfp,offset,origin) );
	}
	
	void close(){
		if(mfp){::fclose(mfp);mfp=NULL;}
	}


};
*/

/*!
@param WORKSPACE_SIZE mۂobt@̃TCY(byteP
@param BUFFER_T byte_bufferNXƓdl̃obt@NX(ʂ͂̂܂܂Ŏł傤B
@note
ꍇɂĂ̓q[vmۂȂobt@ȂăoJȂ񂾁Bͥ
dlpr:^XN[ŇƂ<br>
e:BUFFER_T^̃obt@NXgēImۂA
obt@TCY\Ȃchar̃obt@gďRXg!??<br>
咣:Ȃ񂩁Abyte_buffer,boost::arraystd::vectorƂԂĂ邯ǁA
memcpył鎖𒆐SƂAƈႤNXĎŁAFƂĂB
*/
template<std::size_t WORKSPACE_SIZE = 64,class BUFFER_T=byte_buffer>
class WorkSpaceBase{
public:
	typedef BUFFER_T BUFFER_TYPE;
	enum{
		enuWorkSize = WORKSPACE_SIZE,
	};
#	ifdef _MSC_VER
	typedef BUFFER_T::size_type size_type;
	typedef BUFFER_T::pointer pointer;
	typedef BUFFER_T::const_pointer const_pointer;
#else
	typedef size_t size_type;
	typedef char *pointer;
	typedef const pointer const_pointer;
#endif

private://߂ǂ`B
	char WorkData[enuWorkSize];

	BUFFER_T mDWorkSpace;
	void _construct(){

		NULL_CHAR_ARRAY(WorkData);
		mDWorkSpace.clear();
	}
public:


	///constructor 
	WorkSpaceBase(){
		_construct();
	}
	///copy constructor
	WorkSpaceBase(const WorkSpaceBase<WORKSPACE_SIZE,BUFFER_T> &data){
		_construct();
		if(data.mDWorkSpace.empty()){
			SetBuff(data.WorkData,enuWorkSize);
		}else{
			mDWorkSpace = data.mDWorkSpace;
		}
	}
	//destructor
	virtual ~WorkSpaceBase(){
		clear();
	}
	///[NXy[XJBi ReserveWorkOnce()ĂяoĂꍇ j
	void clear(){
		mDWorkSpace.clear();
		NULL_CHAR_ARRAY(WorkData);
	}
	/*!
	@return łɂ̊֐ĂяoĂꍇAclear()ĂяoȂƂ̊֐͎sB
	܂AWORKSPACE_SIZEŊmۂĂ̂łȉ̏ꍇfalsełB
	*/
	bool reserve(size_type size){
		if(size <= enuWorkSize || (!mDWorkSpace.empty())){
			return false;
		}
		mDWorkSpace.resize(size);
		return true;
	}
	///reserveWrapper
	bool resize(size_type size){
		return reserve(size);
	}
	///[NXy[X̃AhXQbgi͊eALXgĂB
	pointer data(){
		if(mDWorkSpace.empty()){
			return WorkData;
		}else{
			return mDWorkSpace.data();
		}
	}
	const_pointer data()const{
		if(mDWorkSpace.empty()){
			return WorkData;
		}else{
			return mDWorkSpace.data();
		}
	}
	///obt@̋eTCYQbgB
	size_type capacity()const{
		if(mDWorkSpace.empty()){
			return enuWorkSize;
		}else{
			return mDWorkSpace.size();
		}
	}

	/*!
	@param src[in] Rs[ buffer
	@param size[in] src̃TCY
	@return false = s 
	*/
	///src̃̈obt@ɃRs[B
	bool SetBuff(const char *src,size_type size){
		int r;
		if(!mDWorkSpace.isValid()){
			NULL_CHAR_ARRAY(WorkData);
			r = dkmemcpy(WorkData,capacity(),src,size);
			return DKUTIL_SUCCEEDED(r);
		}else{
			return	mDWorkSpace.SetBuff(src,size);
		}
		//return false;
	}

	bool SetString(size_type buffsize,const char *str,...){
		
		temporary_buffer b(new char[buffsize]);
		SET_VA_LIST(b.get(),buffsize,str);
		return SetBuff(b.get(),strlen(b.get()));
	}
	bool SetString(const char *str,...){
		
		size_type buffsize = strlen(str);
		buffsize += 256;
		temporary_buffer b(new char[buffsize]);
		SET_VA_LIST(b.get(),buffsize,str);
		return SetBuff(b.get(),strlen(b.get()));
	}
	
	
};

///Jb`<>Ȓ`𖳂
typedef WorkSpaceBase<> WorkSpace;


}//end of dkutil namespace
#endif//end of include once
