

#ifndef _dkutil_ZLIB_h__
#define _dkutil_ZLIB_h__

#ifdef USE_DKINGYO_ZLIB

#ifdef USE_DKINGYO_INCLUDE_SETTING_LIKE_BOOST
#include <dkutil/dkutilCompileOption.h>
#include <dkutil/dkutilDefinedC.h>
#include <dkutil/dKingyoMacro.h>
#include <dkutil/dkutilFileSystem.h>
#else
#include "../dkutilCompileOption.h"
#include "../dkutilDefinedC.h"
#include "../dKingyoMacro.h"
#include "../dkutilFileSystem.h"
#endif

#include <zlib.h>
#ifdef DKUTIL_COMPILE_OPTION_MSVC
#	ifdef _MT
#		pragma comment(lib,"zlibMT")
#	else
#		pragma comment(lib,"zlib")
#	endif
#endif



namespace dkutil{





///@return zlib̏o͂bZ[WԂB
inline const char *zlib_get_message(z_stream *z){
	static const char *mes="??? no message";
	static const char *logic_err="z_stream structure is null";
	if(!z) return logic_err;
	return ((z->msg) ? z->msg : mes);
}

inline void zlib_exception_throw(z_stream *z){
	throw dkutil_exception("zlib:%s",zlib_get_message(z));
}

template<typename PTR1>
inline void zlib_set_output_buffer(z_stream *z,PTR1 *dest,size_t destsize)
{
#	ifdef _DEBUG
	if(dest==NULL || destsize==0)
		throw std::invalid_argument("zlib_set_output_buffer:argument is invalid!!");
#	endif
	//output
	z->next_out = (BYTE *)dest;// o̓|C^ //
	z->avail_out = destsize;    // o̓obt@̃TCY //
}

template<typename PTR1>
inline void zlib_set_input_buffer(z_stream *z,PTR1 src,size_t srcsize)
{
#	ifdef _DEBUG
	if(src==NULL || srcsize==0)
		throw std::invalid_argument("zlib_set_input_buffer:argument is invalid!!");
#	endif
	//input
	z->avail_in = srcsize;     // ̓obt@̃f[^̃oCg
	z->next_in = (BYTE *)src;

}

inline bool zlib_is_error(int result){
	if(Z_OK > result) return true;
	return false;
}


/*!
@param z[in][out] z_stream\̂ւ̃|C^
*/
///zlibencode modeŏB
inline bool zlib_encode_init(z_stream *z,int compress_mode=Z_BEST_SPEED){
	z->zalloc = Z_NULL;
  z->zfree = Z_NULL;
  z->opaque = Z_NULL;
	/*if (::deflateInit(z, compress_mode) != Z_OK) {
		return false;
	}
	return true;*/
	return ::deflateInit(z, compress_mode) == Z_OK;
}
/*!
@param z[in][out] z_stream\̂ւ̃|C^
@param encode_option[in] GR[h̃IvV(Z_FINISHƂZ_NO_FLUSHƂ

@param result[out] ߂lfalse̎Aɓꂽϐ
 edk_FAILEDzlib̃G[B
 edk_BufferOverFlowƏo̓obt@ȂȂ(Sɏo͂łĂȂ)B
@return trueƐ
*/
///zlibsrcobt@kAdestobt@ɗ߂
inline int zlib_encode(z_stream *z,int encode_option)
{
	return ::deflate(z, encode_option); // k
}



/*!
@param z[in][out] z_streamւ̃|C^
*/
///zlib̃GR[h[hI
inline bool zlib_encode_end(z_stream *z){
	return (::deflateEnd(z) == Z_OK);
}

inline bool zlib_decode_init(z_stream *z){
	// ׂẴǗCuɔC //
	z->zalloc = Z_NULL;
	z->zfree = Z_NULL;
	z->opaque = Z_NULL;

	//  //
	z->next_in = Z_NULL;
	z->avail_in = 0;
	return (::inflateInit(z) == Z_OK);
}
/*!
@param z[in][out] z_stream\̂ւ̃|C^
@return inflateReturn Value
*/
///zlibsrcobt@kAdestobt@ɗ߂
inline int zlib_decode(z_stream *z,int option)
{
	return ::inflate(z, option ); // WJ //
}



inline bool zlib_decode_end(z_stream *z){
	return (::inflateEnd(z) == Z_OK) ;
}



namespace policy{




class zlib_encoder{
protected:
	z_stream m_encode;
	bool m_flag;
	int m_state;
	void check_error(int result){
		if(zlib_is_error(result)){
			zlib_exception_throw(&m_encode);
		}
	}
public:
	zlib_encoder(){m_flag=false;m_state = 0;}
	~zlib_encoder(){end();}

	bool init(int mode=Z_BEST_SPEED ){
		if(m_flag){
			if(false==end())//I
				return false;//error
		}
		DKUTIL_RETURN_FALSE(zlib_encode_init(&m_encode,mode));
		m_flag = true;
		return true;
	}
	bool process(int encode_option)
	{
		if(false==m_flag) return false;
		int result=0;
		result = zlib_encode(&m_encode,encode_option);
		m_state = result;
		check_error(result);
		return true;
	}
	bool end(){
		if(false==m_flag){return false;}
		DKUTIL_RETURN_FALSE(zlib_encode_end(&m_encode));
		//check_error(r);
		m_flag=false;
		return true;
	}
	const int get_state()const{return m_state;}
	const z_stream &get_stream()const{return m_encode;}
	void set_stream(z_stream &s){m_encode = s;}
	z_stream *get_stream_ptr(){return &m_encode;}
};

class zlib_decoder{
protected:
	z_stream m_decode;
	bool m_flag;
	int m_state;
	void check_error(int result){
		if(zlib_is_error(result)){
			zlib_exception_throw(&m_decode);
		}
	}
public:
	zlib_decoder(){m_flag=false;m_state=0;}
	~zlib_decoder(){end();}
	bool init(int mode=Z_BEST_SPEED ){
		if(m_flag){
			if(false==end())
				return false;//error
		}
		DKUTIL_RETURN_FALSE(zlib_decode_init(&m_decode));
		m_flag = true;
		return true;
	}
	bool process(int flush_option=Z_NO_FLUSH){
		if(false==m_flag) return false;
		int result=0;
		//result = zlib_decode(&m_decode,flush_option);
		result = zlib_decode(&m_decode,Z_SYNC_FLUSH );
		m_state = result;
		check_error(result);
		return true;
	}
	bool end(){
		if(false==m_flag){return false;}
		DKUTIL_RETURN_FALSE(zlib_decode_end(&m_decode));
		//check_error(r);
		m_flag=false;
		return true;
	}
	const int get_state()const{return m_state;}
	const z_stream &get_stream()const{return m_decode;}
	void set_stream(z_stream &s){m_decode = s;}
	z_stream *get_stream_ptr(){return &m_decode;}
};

}//end of policy namespace

/*!

@param srclocalbuffsize[in] Ŏgǂݍ݃obt@̃TCY
@param destlocalbuffsize[in] Ŏg݃obt@̃TCY
@param zlib[in] zlib_encoder  zlib_decoder̃NX
@param 
@note

EZLIB_OPERATION zlib_encoder  zlib_decoder̃NXB<br>
EREAD_BUFFER_LISTENER ǂݍbuffer𑀍삷郊Xi[NXB<br>
EWRITE_BUFFER_LISTENER buffer𑀍삷郊Xi[NXB<br>
<br>
BUFFER_LISTENERñev[gɂ
file_operatorn(Oreset(RXgN^Ăяo)ďĂKvB)
*/
template<class ZLIB_OPERATION,class READ_BUFFER_LISTENER,class WRITE_BUFFER_LISTENER>
inline bool zlib_general_purpose_process(size_t srclocalbuffsize,size_t destlocalbuffsize,
								 //ZLIB_OPERATION get_zlib,BUFFER_LISTENER get_listener,
								 ZLIB_OPERATION zlib,READ_BUFFER_LISTENER read_listener,WRITE_BUFFER_LISTENER write_listener,
								 int compress_mode=Z_BEST_SPEED )
{
	//variable

	//get_listener listener;
	//get_zlib zlib;
	if(destlocalbuffsize==0 || srclocalbuffsize==0)
		throw dkutil_exception("dkutil::zlib_general_purpose_process::localbuffer size was zero");
	scoped_buffer destlocalbuff(destlocalbuffsize);
	scoped_buffer srclocalbuff(srclocalbuffsize);
	

	//procedure
	
	 //initialize
	DKUTIL_RETURN_FALSE(zlib.init(compress_mode));
	//file open
	DKUTIL_RETURN_FALSE(read_listener.open());
	DKUTIL_RETURN_FALSE(write_listener.open());
	
	//ŏ͂encodeIvV
	int encode_option =  Z_NO_FLUSH;
	//ۂɓǂݍ񂾃TCY
	size_t ReadSize = 0;
	//read data
	{
		size_t read_size;
		read_size=read_listener.read(
			srclocalbuff.get(),srclocalbuff.size()
			);
		if(read_size==0) return false;
		if( srclocalbuff.size() > read_size)
		{//Ȃǂݍ񂾁B
			//Ȃ̂ŃGR[hIvVŏIpɕςB
			encode_option= Z_FINISH;
		}
		//ǂݍ񂾃TCYۑ
		ReadSize = read_size;
		//ǂݍ݃obt@ݒ肷
		zlib_set_input_buffer(zlib.get_stream_ptr(),srclocalbuff.get(),read_size);
	}
	//݃obt@ݒ肷
	zlib_set_output_buffer(zlib.get_stream_ptr(),destlocalbuff.get(),destlocalbuff.size());
	


	while (true) 
	{

		//int result=0;
		int lre = zlib.get_state();
		z_stream *z = zlib.get_stream_ptr();
		if(z->avail_in == 0){
			size_t read_size;
			read_size = read_listener.read(srclocalbuff.get(),srclocalbuff.size());
			if( srclocalbuff.size() > read_size)
			{//Ȃǂݍ񂾁B
				//Ȃ̂ŃGR[hIvVŏIpɕςB
				encode_option= Z_FINISH;
	
				//zlib.process(encode_option);
				//if(zlib.get_state()==Z_STREAM_END) break;
			}
			
			ReadSize = read_size;
			//ǂݍ݃obt@ݒ肷
			if(read_size != 0){
				zlib_set_input_buffer(
					zlib.get_stream_ptr(),srclocalbuff.get(),
					read_size
				);
			}
			//z->next_in = (BYTE *)srclocalbuff.get();  // ̓|C^̓obt@̐擪 //
			//z->avail_in = read_size;//ǂݍ񂾃TCYGO!!
		}
		zlib.process(encode_option);
		if(zlib.get_state()==Z_STREAM_END)
		{
			break;
		}
		/*if(zlib.get_state()==Z_NEED_DICT){
			MB("??");
		}*/
		if (z->avail_out == 0) 
		{
			//obt@I[o[B
			// ܂Ƃ߂ďo //
			size_t Size;
			Size = destlocalbuff.size();

			DKUTIL_TRUE_ASSERT_OR_THROW(
					write_listener.write(destlocalbuff.get(),Size) != Size,
					std::runtime_error("zlib Write error\n")
				);

			zlib_set_output_buffer(z,destlocalbuff.get(),destlocalbuff.size());
			//z->next_out = (BYTE *)destlocalbuff.get(); // o̓obt@cʂɖ߂ 
			//z->avail_out = destlocalbuff.size(); // o̓|C^ɖ߂
		}
		
	}//end of loop
	// cfo
	{
		size_t count;
		if ((count = destlocalbuff.size() - zlib.get_stream().avail_out) != 0)
		{
			DKUTIL_TRUE_ASSERT_OR_THROW(
				write_listener.write(destlocalbuff.get(),count) != count,
				std::runtime_error("zlib Write error\n")
			);
		}
	}
	//Ƃ̓fXgN^ɔC^^G
	//zlib.end();
	//read_listener.close();
	//write_listener.close();
	return true;
}


namespace policy{

class zlib_compress{
protected:
public:
	//bool init(
	/*!
	@throw vIȃG[̏ꍇAstd::runtime_error𓊂
	@param get_compress_buff[in] kf[^̃obt@ւ̃|C^
	@param compress_buffsize[in] get_compress_buff̃TCY
	*/
	bool encode(BYTE *src,size_t srcsize,byte_buffer &buff,
		int compress_mode=Z_BEST_SPEED ,bool isThrow=true)
	{
		
		

	}
	bool decode(BYTE *src,size_t srcsize,byte_buffer &buff){
		
	}
};


}//end of policy namespace


namespace private_{

/*!
zlibŃt@Ck t@Cԓm̃fR[hGR[hT|[gB
*/
/*
class zlib_file_compressor{
private:
public:
	//
	bool compress(
		char *inbuff,size_t inbuffsize,char *outbuff,size_t outbuffsize,
		FILE *fin,FILE *fout,
		int compress_mode=Z_BEST_SPEED ,bool isThrow=true)
	{
		z_stream z; // CuƂƂ肷邽߂̍\ 
		int count, flush, status;
		if(fin==NULL || fout==NULL) return false;

		// ׂẴǗCuɔC 
		z.zalloc = Z_NULL;
		z.zfree = Z_NULL;
		z.opaque = Z_NULL;

		//  
		// 2͈k̓xB0`9 ͈̔͂̐ŁC0 ͖k 
		// Z_BEST_SPEED  (= 6) W 
		if (::deflateInit(&z, compress_mode) != Z_OK) {
				DKUTIL_TRUE_ASSERT_OR_THROW(
					isThrow,
				std::runtime_error("zlib deflateInit: %s\n", (z.msg) ? z.msg : "???")
				);
			return false;
		}

		z.avail_in = 0;             // ̓obt@̃f[^̃oCg //
		z.next_out = outbuff;        // o̓|C^ //
		z.avail_out = outbuffsize;    // o̓obt@̃TCY //

		// ʏ ::deflate() ̑2 Z_NO_FLUSH ɂČĂяo //
		flush = Z_NO_FLUSH;

		while (1) {
				if (z.avail_in == 0) {  // ͂s //
						z.next_in = inbuff;  // ̓|C^̓obt@̐擪 //
						z.avail_in = fread(inbuff, 1, inbuffsize, fin); // f[^ǂݍ //

						// ͂ŌɂȂ ::deflate() ̑2 Z_FINISH ɂ //
						if (z.avail_in < inbuffsize) flush = Z_FINISH;
				}
				status = ::deflate(&z, flush); // k //
				if (status == Z_STREAM_END) break; //  //
				if (status != Z_OK) {   // G[ //
						DKUTIL_TRUE_ASSERT_OR_THROW(
								isThrow,
								std::runtime_error("zlib deflate: %s\n", (z.msg) ? z.msg : "???")
							);
							return false;
				}
				if (z.avail_out == 0) { // o̓obt@s //
						// ܂Ƃ߂ďo //
						if (fwrite(outbuff, 1, outbuffsize, fout) != outbuffsize) {
								DKUTIL_TRUE_ASSERT_OR_THROW(
										isThrow,
										std::runtime_error("zlib Write error\n")
									);
									return false;
						}
						z.next_out = outbuff; // o̓obt@cʂɖ߂ //
						z.avail_out = outbuffsize; // o̓|C^ɖ߂ //
				}
		}

		// cfo //
		if ((count = outbuffsize - z.avail_out) != 0) {
				if (fwrite(outbuff, 1, count, fout) != count) {
						DKUTIL_TRUE_ASSERT_OR_THROW(
										isThrow,std::runtime_error("zlib Write error\n"));
							return false;
				}
		}

		// n //
		if (::deflateEnd(&z) != Z_OK) {
				DKUTIL_TRUE_ASSERT_OR_THROW(
						isThrow,
						std::runtime_error("zlib deflateEnd: %s\n", (z.msg) ? z.msg : "???")
					);
					return false;
		}
			return true;
	}
	bool decompress(
		char *inbuff,size_t inbuffsize,char *outbuff,size_t outbuffsize,
		FILE *fin,FILE *fout,
		bool isThrow=true)        // WJij //
	{
		z_stream z;
		int count, status;
		if(fin==NULL || fout==NULL) return false;

		// ׂẴǗCuɔC //
		z.zalloc = Z_NULL;
		z.zfree = Z_NULL;
		z.opaque = Z_NULL;

		//  //
		z.next_in = Z_NULL;
		z.avail_in = 0;
		if (inflateInit(&z) != Z_OK) {
				DKUTIL_TRUE_ASSERT_OR_THROW(
					isThrow,
					std::runtime_error("zlib inflateInit: %s\n", (z.msg) ? z.msg : "???")
				);
				return false;
		}

		z.next_out = outbuff;        // o̓|C^ //
		z.avail_out = outbuffsize;    // o̓obt@c //
		status = Z_OK;

		while (status != Z_STREAM_END) {
			if (z.avail_in == 0) {  // ͎cʂ[ɂȂ //
					z.next_in = inbuff;  // ̓|C^ɖ߂ //
					z.avail_in = fread(inbuff, 1, inbuffsize, fin); // f[^ǂ //
			}
			status = inflate(&z, Z_NO_FLUSH); // WJ //
			if (status == Z_STREAM_END) break; //  //
			if (status != Z_OK) {   // G[ //
				DKUTIL_TRUE_ASSERT_OR_THROW(
					isThrow,
					std::runtime_error("zlib inflate: %s\n", (z.msg) ? z.msg : "???")
				);
					return false;
			}
			if (z.avail_out == 0) { // o̓obt@s //
				// ܂Ƃ߂ďo //
				if (fwrite(outbuff, 1, outbuffsize, fout) != outbuffsize) {
						DKUTIL_TRUE_ASSERT_OR_THROW(isThrow,
							std::runtime_error("zlib Write error\n");
						return false;
				}
				z.next_out = outbuff; // o̓|C^ɖ߂ //
				z.avail_out = outbuffsize; // o̓obt@cʂɖ߂ //
			}
		}

		// cfo //
		if ((count = outbuffsize - z.avail_out) != 0) {
				if (fwrite(outbuff, 1, count, fout) != count) {
						DKUTIL_TRUE_ASSERT_OR_THROW(isThrow,std::runtime_error("zlib Write error\n");
						return false;
				}
		}

		// n //
		if (inflateEnd(&z) != Z_OK) {
				DKUTIL_TRUE_ASSERT_OR_THROW(isThrow,std::runtime_error("zlib inflateEnd: %s\n", (z.msg) ? z.msg : "???");
				return false;
		}
		return true;
	}
public:
	zlib_file_compressor(){
	}
	bool zlib_compressed_file_to_normal_file(const char *infilename,const char *outfilename,size_t buffsize=2048)
	{
		scoped_buffer inbuff(buffsize);
		scoped_buffer outbuff(buffsize);
		file_operator infile(infilename);
		file_operator outfile(outfilename);
		return decompress(inbuff.get(),inbuff.size(),
			outbuff.get(),outbuff.size(),
			infile.handle(),outfile.handle(),
			false);



		return true;
	}
	bool normal_file_to_zlib_compressed_file(const char *infilename,const char *outfilename,
		int compression_mode=Z_BEST_SPEED ,size_t buffsize=2048)
	{
		scoped_buffer inbuff(buffsize);
		scoped_buffer outbuff(buffsize);
		file_operator infile(infilename);
		file_operator outfile(outfilename);
		return compress(inbuff.get(),inbuff.size(),
			outbuff.get(),outbuff.size(),
			infile.handle(),outfile.handle(),
			false);

		return true;
	}

};
*/		

}//end of private_ namespace



/*
class zlib_file_operator : public file_operator{
protected:
	policy::zlib_decoder m_decode;
	policy::zlib_encoder m_encode;



public:
	typedef file_operator BASE_TYPE;
	zlib_file_operator(){
	}
	virtual ~zlib_file_operator(){
		close();
	}

	bool reset(const char *filename,const char *mode,const char *type,
		int compress_mode=Z_BEST_SPEED )
	{
		close();
		bool r=BASE_TYPE::reset(filename,mode,type);
		if(false==r) return r;
		m_encode.init();
		m_decode.init();
		return r;
	}

//	const char *filename()const{return mfilename.c_str();}
//	const char *mode()const{return mmode.c_str();}
	bool open(){
		bool r = BASE_TYPE::open();
		if(r==false) return r;
		return r;
	}
	size_t read(const void *buf,size_t size,size_t readsize=0){
		BASE_TYPE::read(lbuff.get(),lbuff.size());
		zlib_general_purpose_process(buf,size,destlocalbuffsize,
			decoder,file_operation);
		

	}
	size_t write(const void *buf,size_t size){

	}
	//
	bool eof()const{

	}
	bool error()const{
		return 
	}
	bool seek(long offset, int origin ){
		return BASE_TYPE::seek(offset,origin);
	}//
	
	void close(){
		BASE_TYPE::close();
		m_encode.end();
		m_decode.end();
	}
};


*/

}//end of dkutil namespace


#endif//end of USE_DKINGYO_ZLIB
#endif//end of include once