/*
	fast Mersenne Twister routine for Pentium4
	2002/10/19
	MITSUNARI Shigeo(herumi@nifty.com)
	original source is http://www.math.keio.ac.jp/matumoto/emt.html
 */


//dƃJX^}CY

#ifndef MY_MT_H_
#define MY_MT_H_


//PƂł̃Cugꍇ͈ȉ̃CuNĂB
//:pX̊mFāAw肵ĂB
//#pragma comment(lib,"mymt")

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
	unsigned int state[624];
	unsigned int output[624];
	unsigned int index;
	char *mallocPtr;
} myMT_t;

///	initialize for myMT
///	return the handle of myMT
///	this library is reentrant
myMT_t *myMT_Init(void);


///	set the seed of MT
void myMT_SetSeed(myMT_t *mt, unsigned int seed);


///	set the large seed of MT
///	0 < seedNum <= 624
void myMT_SetSeeds(myMT_t *mt, unsigned int *seed, int seedNum);


///	free of the handle of myMT
void myMT_Term(myMT_t *mt);

extern void (*myMT_Next)(myMT_t *mt);

///generates a random number on [0,0xffffffff]-interval 
///You may call myMT_Next_SSE2 insted of myMT_Next if you use this on only Pentium 4 
#define myMT_GetInt32(mt) (((mt->index == 624) ? myMT_Next(mt), 0 : 0), mt->output[mt->index++])

#ifdef __cplusplus
}
#endif

#endif // MY_MT_H_ 


/*

ȉAmymt.h̃IWi

#ifndef MY_MT_H_
#define MY_MT_H_

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
	unsigned int state[624];
	unsigned int output[624];
	unsigned int index;
	char *mallocPtr;
} myMT_t;

#ifdef _MSC_VER
	#define MYMT_EXPORT __declspec(dllexport) 
#else
	#define MYMT_EXPORT
#endif


//	initialize for myMT
//	return the handle of myMT
//	this library is reentrant

MYMT_EXPORT myMT_t *myMT_Init(void);


//	set the seed of MT

MYMT_EXPORT void myMT_SetSeed(myMT_t *mt, unsigned int seed);


//	set the large seed of MT
//	0 < seedNum <= 624

MYMT_EXPORT void myMT_SetSeeds(myMT_t *mt, unsigned int *seed, int seedNum);


//	free of the handle of myMT

MYMT_EXPORT void myMT_Term(myMT_t *mt);

MYMT_EXPORT extern void (*myMT_Next)(myMT_t *mt);

//generates a random number on [0,0xffffffff]-interval 
//You may call myMT_Next_SSE2 insted of myMT_Next if you use this on only Pentium 4 
#define myMT_GetInt32(mt) (((mt->index == 624) ? myMT_Next(mt), 0 : 0), mt->output[mt->index++])

#ifdef __cplusplus
}
#endif

#endif // MY_MT_H_ 
*/