/*!
@file dkcMD5.h
@brief MD5 Algorithm
@author wrapped by d
@note
MD5͂łɏIHASYȂ̂ŁASHA1pB
܂ASlȂSHA256ȏɂƗǂƎv܂B
*/



#ifndef DKUTIL_C_MD5_H
#define DKUTIL_C_MD5_H

#include "md_misc.h"
#include "dkcOSIndependent.h"


///MD5oCĩVOl`ۑɕKvȗ̈
#define MD5_BIN_BUFFER_SIZE 16
///MD5̃VOl`ۑɕKvȗ̈
#define MD5_STR_BUFFER_SIZE 33

/*!
@return DKC_MD5\̂ւ̊mۂ̈
@note
łdkcMD5Init()͌Ă΂Ă܂B
*/
DKC_EXTERN DKC_MD5 *WINAPI dkcAllocMD5();

///@return dkcAllocMD5()擾̈B
DKC_EXTERN void WINAPI dkcMD5Init(DKC_MD5 *);

DKC_INLINE void dkcMD5InitEx(DKC_MD5 *p,uint8 flags)
{
	dkcMD5Init(p);
	p->flags = flags;
}

/*!
@param p[in][out] dkcAllocMD5()Ŏ擾|C^
@param pBuffer[in] ǂݎobt@ւ̃|C^
@param dwSize[in] obt@ɃANZXOKȃTCY
@return edk_SUCCEEDEDŐ
@note
Cu̓sɂAdkcMD5Load()INT_MAX傫obt@Ȃ
*/
DKC_EXTERN void WINAPI dkcMD5Load(DKC_MD5 *p,const BYTE *pBuffer,DWORD dwSize);


/*!
@param p[in][out] dkcAllocMD5()Ŏ擾|C^
@note
dkcMD5FinalDigest()gp鎖サ܂B
*/
DKC_EXTERN void WINAPI dkcMD5Final(DKC_MD5 *p);
/*!
@param p[in][out] dkcAllocMD5()Ŏ擾|C^
@param buff[out] ރobt@ւ̃|C^
@param size[in] buff̃TCY
@return edk_SUCCEEDEDԂ
*/
DKC_EXTERN int WINAPI dkcMD5DigestStr(DKC_MD5 *p,char *buff,size_t size);
///@see dkcMD5DigestStr()
DKC_EXTERN int WINAPI dkcMD5Digest(DKC_MD5 *p,BYTE *buff,size_t size);

/*!
@see A߂lɂĂdkcMD5Digest()ƓłB 
@note
dkcMD5Final()dkcMD5Digest()gpÅ֐̎gpサ܂B
*/
DKC_EXTERN int WINAPI dkcMD5FinalDigestStr(DKC_MD5 *p,char *buff,size_t size);
///@see dkcMD5FinalDigestStr()
DKC_EXTERN int WINAPI dkcMD5FinalDigest(DKC_MD5 *p,BYTE *buff,size_t size);

/*!
@param p[in][out] dkcAllocMD5()Ŏ擾|C^ւ̃|C^
@return 肭Jłedk_SUCCEEDED
*/
DKC_EXTERN int WINAPI dkcFreeMD5(DKC_MD5 **p);


//**********************************************************


typedef struct dkc_MD5_Adapter{
	//md5_state_t d;
	void *mpObj;
	uint32 mObjFlag;
	BYTE mFinalized;
}DKC_MD5_ADAPTER;

enum edkcMD5ObjectFlag
{
	/**
	ftHgMD5IuWFNg
	*/
	edkcMD5_Default = 0,
	///md5.c̎g
	edkcMD5_Aladdin,
};
/*!
@return DKC_MD5_ADAPTER\̂ւ̊mۂ̈
@note
łdkcMD5Init()͌Ă΂Ă܂B
*/
DKC_EXTERN DKC_MD5_ADAPTER *WINAPI dkcAllocMD5Adapter(uint32 md5_objflag);

///@return dkcAllocMD5()擾̈B
DKC_EXTERN void WINAPI dkcMD5AdapterInit(DKC_MD5_ADAPTER *);
/*!
@param p[in][out] dkcAllocMD5()Ŏ擾|C^
@param pBuffer[in] ǂݎobt@ւ̃|C^
@param dwSize[in] obt@ɃANZXOKȃTCY
@return edk_SUCCEEDEDŐ
@note
Cu̓sɂAdkcMD5Load()INT_MAX傫obt@Ȃ
*/
DKC_EXTERN int WINAPI dkcMD5AdapterLoad(DKC_MD5_ADAPTER *p,const BYTE *pBuffer,DWORD dwSize);

///dkcSHA1Load() dkcSHA256Load()ƓdlLoad
DKC_EXTERN void WINAPI dkcMD5AdapterLoadStandard(DKC_MD5_ADAPTER *p,const BYTE *pBuffer,DWORD dwSize);


/*!
@param p[in][out] dkcAllocMD5()Ŏ擾|C^
@note
dkcMD5FinalDigest()gp鎖サ܂B
*/
DKC_EXTERN void WINAPI dkcMD5AdapterFinal(DKC_MD5_ADAPTER *p);
/*!
@param p[in][out] dkcAllocMD5()Ŏ擾|C^
@param buff[out] ރobt@ւ̃|C^
@param size[in] buff̃TCY
@return edk_SUCCEEDEDԂ
*/
DKC_EXTERN int WINAPI dkcMD5AdapterDigestStr(DKC_MD5_ADAPTER *p,char *buff,size_t size);
///@see dkcMD5DigestStr()
DKC_EXTERN int WINAPI dkcMD5AdapterDigest(DKC_MD5_ADAPTER *p,BYTE *buff,size_t size);

/*!
@see A߂lɂĂdkcMD5Digest()ƓłB 
@note
dkcMD5Final()dkcMD5Digest()gpÅ֐̎gpサ܂B
*/
DKC_EXTERN int WINAPI dkcMD5AdapterFinalDigestStr(DKC_MD5_ADAPTER *p,char *buff,size_t size);
///@see dkcMD5FinalDigestStr()
DKC_EXTERN int WINAPI dkcMD5AdapterFinalDigest(DKC_MD5_ADAPTER *p,BYTE *buff,size_t size);

/*!
@param p[in][out] dkcAllocMD5()Ŏ擾|C^ւ̃|C^
@return 肭Jłedk_SUCCEEDED
*/
DKC_EXTERN int WINAPI dkcFreeMD5Adapter(DKC_MD5_ADAPTER **p);




#endif //end of include once