/**
URI BNF http://www.w3.org/Addressing/URL/5_URI_BNF.html
thanks
*/
%{

#include <stdio.h>
#include <ctype.h>
#include <math.h>

#define YYSTYPE double

int yylex(void);
void yyerror(const char* s);

%}
%%


name : alphanum
hex           : digit | 'A' | 'B' | 'C' | 'D' | 'E' | 'F' |
                        'a' | 'b' | 'c' | 'd' | 'e' | 'f'
alphanum      : alpha | digit
alpha         : lowalpha | upalpha
lowalpha : 'a' | 'b' | 'c' | 'd' | 'e' | 'f' | 'g' | 'h' | 'i' |
           'j' | 'k' | 'l' | 'm' | 'n' | 'o' | 'p' | 'q' | 'r' |
           's' | 't' | 'u' | 'v' | 'w' | 'x' | 'y' | 'z'
upalpha  : 'A' | 'B' | 'C' | 'D' | 'E' | 'F' | 'G' | 'H' | 'I' |
           'J' | 'K' | 'L' | 'M' | 'N' | 'O' | 'P' | 'Q' | 'R' |
           'S' | 'T' | 'U' | 'V' | 'W' | 'X' | 'Y' | 'Z'
digit    : '0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9'
dot : '.'
relative : ".."
invalids : '*' | '?' | '"' | '<' | '>' | '|'
path_sep : '/' | '\\'
%%
	
