/**
@author d
@file x86.c
@brief x86nHCPU̔ʂp@
@since 2005/01/23
@note
ꕔ̃\[X
<ul>
<li>umemory copy code benchmarkṽ\[XgĂ܂B
ȉ͂̕łB
<PRE>
// memory copy code benchmark
// source code for Visual C++ 6.0 + Service Pack 4 + Processor Pack
// copyright(C) 2001 XELF. All rights reserved.
// http://www.cyborg.ne.jp/~xelf/

// You can use this source code for any purpose without permission.
// Notes that this source code is not supported the processing of fraction bytes.
</PRE>

<li>uDirectX9pėpCu LunavLuna.cpp̃\[XR[hgĂ܂B
ȉp̌łB
<PRE>
_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
y^Cgz DirectX9pėpCu Luna
yt@Cz Luna.zip
y쐬z 2003/07/01 - 2004/01/01
yJeSz Cu
y  ҁz t`
yz DirectX9SDKpAvP[VRpCł
yzz`ԁz t[EFA
y E-Mail z haniwa@twin-tail.jp
yHomePagez http://www.twin-tail.jp/
y]@@ځz R
y  z ̂ŁADgĂB
_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/


@^Cĝ܂܂łB
@쌠Ƃ͂ǂłōDgĂB
@ꉞgpƂ""QƁB

...


Ӂ
@̃vOp邱Ƃɂĉ炩̔QAMɂƂĂA
@͈ؐӔC𕉂܂̂łB
</PRE>

</ul>
*/
#include "x86.h"
#include "memory.h"


#if 1!=DKUTIL_CSTD_MSVC_IASM
//#	error "unsupport msvc inline assembler"
#else

BOOL WINAPI dkcstd_getX86CPUInfo(DKCSTD_CPU_INFO *dest,int CPUClockCalcTime)
{

	char CPUName[256]	= "";
	char CPUType[128]	= "";
	long bFPU			= FALSE;
	long bTSC			= FALSE;
	long bCMOV			= FALSE;
	long bFCMOV			= FALSE;
	long bCPUID			= FALSE;
	long bMMX			= FALSE;
	long bMMX2			= FALSE;
	long bSSE			= FALSE;
	long bSSE2			= FALSE;
	long b3DNOW			= FALSE;
	long bE3DNOW		= FALSE;
	long TypeID			= 0;
	long FamilyID		= 0;
	long ModelID		= 0;
	long SteppingID		= 0;
	long CPUClock		= 0;

	__asm
	{
		//-----------------------------------------------------------
		// CPUID߂̑݃`FbN
		//-----------------------------------------------------------
		PUSHFD
		POP		EAX
		MOV		EBX,		EAX
		XOR		EAX,		1<<21
		PUSH	EAX
		POPFD
		PUSHFD
		POP		EAX
		CMP		EAX,		EBX
		JE		EXIT				// Ȃ
		MOV		bCPUID,		1

		//-----------------------------------------------------------
		// CPUID 0
		//-----------------------------------------------------------
		MOV		EAX,		0
		CPUID

		CMP		EAX,		0
		JE		EXIT				// 0ł͘bɂȂ

		MOV DWORD PTR [CPUType+0],	EBX
		MOV DWORD PTR [CPUType+8],	ECX
		MOV DWORD PTR [CPUType+4],	EDX

		//-----------------------------------------------------------
		// CPUID 1
		//-----------------------------------------------------------
		MOV		EAX,		1
		CPUID

		//----------------------------------------------
		// EAXWX^̒g
		//----------------------------------------------
		// XebsOID
		MOV		ESI,		EAX
		AND		ESI,		0x0F;		// 4oCgɃXebsOID
		MOV		[SteppingID],ESI

		// fID
		SHR		EAX,		4			// EXebsOIDɋl߂ĥ
		MOV		ESI,		EAX
		AND		ESI,		0x0F		// 4oCg
		MOV		[ModelID],	ESI

		// t@~[ID
		SHR		EAX,		4			// ܂l߂ĥ
		MOV		ESI,		EAX
		AND		ESI,		0x0F		// Ȃ4oCg
		MOV		[FamilyID],	ESI

		// ^CvID
		SHR		EAX,		4			// 
		MOV		ESI,		EAX
		AND		ESI,		0x03		// x2oCg
		MOV		[TypeID],	ESI

		//----------------------------------------------
		// EDXWX^̒g
		//----------------------------------------------
		// FPUiȂ烄oCƎvǂˁOOG
		XOR		EAX,		EAX			// [NA
		TEST	EDX,		1<<0		// 1oCgڃ`FbN
		SETNZ	AL						// 0łȂȂALWX^֓]
		MOV		[bFPU],		EAX			// ʂ₢

		// TSC
		TEST	EDX,		1<<4
		SETNZ	AL
		MOV		[bTSC],		EAX

		// t]߂єr
		XOR		EAX,		EAX
		TEST	EDX,		1<<15
		SETNZ	AL
		MOV		[bCMOV],	EAX

		// MMX
		XOR		EAX,		EAX
		TEST	EDX,		1<<23
		SETNZ	AL
		MOV		[bMMX],		EAX

		// MMX2 & SSE 
		XOR		EAX,		EAX
		TEST	EDX,		1<<25
		SETNZ	AL
		MOV		[bMMX2],	EAX
		MOV		[bSSE],		EAX

//////////////////////////////////
//		ȉAMDCPU		//
//////////////////////////////////

		//-----------------------------------------------------------
		// CPUID 0x80000000
		//-----------------------------------------------------------
		MOV		EAX,		0x80000000
		CPUID

		CMP		EAX,		0x80000001	// CPUID߂̃T|[g`FbN
		JB		EXIT

		//-----------------------------------------------------------
		// CPUID 0x80000001
		//-----------------------------------------------------------
		MOV		EAX,		0x80000001
		CPUID

		// MMX2
		XOR		EAX,		EAX
		TEST	EDX,		1<<22
		SETNZ	AL
		MOV		[bMMX2],	EAX

		// Enhansed 3DNow!
		XOR		EAX,		EAX
		TEST	EDX,		1<<30
		SETNZ	AL
		MOV		[bE3DNOW],	EAX

		// Enhansed 3DNow!
		XOR		EAX,		EAX
		TEST	EDX,		1<<31
		SETNZ	AL
		MOV		[b3DNOW],	EAX

		//-----------------------------------------------------------
		// CPUID 0x80000002 - 0x80000004
		//-----------------------------------------------------------
		// T|[gĂ邩H
		MOV		EAX,		0x80000000
		CPUID
		CMP		EAX,		0x80000004
		JB		EXIT

		// 0x80000002
		MOV EAX, 0x80000002
		CPUID

		MOV DWORD PTR [CPUName+ 0],		EAX
		MOV DWORD PTR [CPUName+ 4],		EBX
		MOV DWORD PTR [CPUName+ 8],		ECX
		MOV DWORD PTR [CPUName+12],		EDX

		// 0x80000003
		MOV EAX, 0x80000003
		CPUID

		MOV DWORD PTR [CPUName+16],		EAX
		MOV DWORD PTR [CPUName+20],		EBX
		MOV DWORD PTR [CPUName+24],		ECX
		MOV DWORD PTR [CPUName+28],		EDX

		// 0x80000004
		MOV EAX, 0x80000004
		CPUID

		MOV DWORD PTR [CPUName+32],		EAX
		MOV DWORD PTR [CPUName+36],		EBX
		MOV DWORD PTR [CPUName+40],		ECX
		MOV DWORD PTR [CPUName+44],		EDX
		
	// I
	EXIT:
	}

	

	//------------------------------------------------------------------------
	// CPUNbN擾
	//------------------------------------------------------------------------
	if ( bTSC && 0 != CPUClockCalcTime)
	{

		/*__asm
		{
			RDTSC
			MOV		[CPUClock],		EAX
		}

		Sleep( 1000 );

		__asm
		{
			RDTSC
			SUB		EAX,			[CPUClock]
			MOV		[CPUClock],		EAX
		}

		CPUClock /= 1000000;
		*/

		__asm
		{
			RDTSC
			MOV		[CPUClock],		EAX
		}

		Sleep( CPUClockCalcTime );

		__asm
		{
			RDTSC
			SUB		EAX,			[CPUClock]
			MOV		[CPUClock],		EAX
		}

		CPUClock /= (CPUClockCalcTime * 1000);
	}

	//--------------------------------------------------
	// `FbN`
	//--------------------------------------------------


	{//ߍ
		size_t cns = sizeof(dest->CPUName);
		size_t cts = sizeof(dest->CPUType);
	
		dkcstd_memcpy(dest->CPUName,CPUName,cns);
		dest->CPUName[cns - 1] = '\0';

		dkcstd_memcpy(dest->CPUType,CPUType,cts);
		dest->CPUType[cts - 1] = '\0';
		
		dest->bFPU		= (unsigned char)bFPU;
		dest->bTSC		= (unsigned char)bTSC;
		dest->bCMOV		= (unsigned char)bCMOV;
		dest->bCPUID	= (unsigned char)bCPUID;
		dest->bMMX		= (unsigned char)bMMX;
		dest->bMMX2		= (unsigned char)bMMX2;
		dest->bSSE		= (unsigned char)bSSE;
		dest->bSSE2		= (unsigned char)bSSE2;
		dest->b3DNOW	= (unsigned char)b3DNOW;
		dest->bE3DNOW	= (unsigned char)bE3DNOW;
		dest->TypeID	= TypeID;
		dest->FamilyID= FamilyID;
		dest->ModelID	= ModelID;
		dest->SteppingID	= SteppingID;
		dest->CPUClock		= CPUClock;
	}
	return TRUE;
}

int WINAPI dkcstd_IsCPUID(){
	int flag = 0;

	__asm{
		pushfd
		pop eax
		mov ebx,eax
		xor eax,00200000h
		push eax
		popfd
		pushfd
		pop eax
		cmp eax,ebx //CPUID̗Lr
		je end 
		mov flag,1
end:
	}
	return flag;
}

int WINAPI dkcstd_getCPUID(){
	int flags=0;
	__asm {
		xor eax,eax;
		cpuid;
		or eax,eax;
		jz quit;
		mov eax,1;
		cpuid;
		mov flags,edx;
	quit:
	}
	return flags;
}

uint32 WINAPI dkcstd_getX86CPUType() {
	int flags;
	uint32 type;

	if(FALSE==dkcstd_IsCPUID()){
		return 0;
	}
	flags=dkcstd_getCPUID();


	//AMDn
	if (flags&(1<<31))
	{
		type|=edkcCPU_3DNOW;
		if (flags&(1<<30))
		{
			type|=edkcCPU_E3DNOW;
		}
	}
	//Inteln
	if (flags&(1<<23))
	{
		type|=edkcCPU_MMX;
		if (flags&(1<<25))
		{
			type|=edkcCPU_SSE;
			//g炵
			type|=edkcCPU_MMX2;
			if (flags&(1<<26)) 
			{
				type|=edkcCPU_SSE2;
			}
		}
	}
	return type;
}

uint16 WINAPI dkcstd_getFPUMode(){
	uint16 wSave;
	__asm fstcw wSave

	return wSave;
}

int WINAPI dkcstd_setFPUMode(uint16 data){
	if(data > 0x300){
		return edk_FAILED;
	}
	__asm fldcw data
	return edk_SUCCEEDED;
}


void WINAPI dkcstd_getRDTSC(DKC_UINT64_STRUCT *p)
{
	*p = dkcstd_getRDTSC_Fast();
}
#endif