/*!
@author d
@see dkcString.h
*/
#define DKUTIL_C_STRING_C
#include "dkcString.h"
#include "dkcStdio.h"
#include "dkcOSIndependent.h"
#include <limits.h>

/*
// SJIŜPoCgڂ̃R[h
extern const BYTE SJIS1_S1 = 0x81;
extern const BYTE SJIS1_E1 = 0x9f;
extern const BYTE SJIS1_S2 = 0xe0;
extern const BYTE SJIS1_E2 = 0xf5;

// SJIŜQoCgڂ̃R[h
extern const BYTE SJIS2_S1 = 0x40;
extern const BYTE SJIS2_E1 = 0x7e;
extern const BYTE SJIS2_S2 = 0x80;
extern const BYTE SJIS2_E2 = 0xfc;
*/

// SJIŜPoCgڂ̃R[h
static const BYTE SJIS1_S1 = 0x81;
static const BYTE SJIS1_E1 = 0x9f;
static const BYTE SJIS1_S2 = 0xe0;
static const BYTE SJIS1_E2 = 0xf5;

// SJIŜQoCgڂ̃R[h
static const BYTE SJIS2_S1 = 0x40;
static const BYTE SJIS2_E1 = 0x7e;
static const BYTE SJIS2_S2 = 0x80;
static const BYTE SJIS2_E2 = 0xfc;




BOOL dkcIsSJIS1(BYTE c)
{
  // ʂɏ΂̂悤ȊA
  // if((c >= SJIS1_S1 && c <= SJIS1_E1) || (c >= SJIS1_S2 && c <= SJIS1_E2)) return TRUE;
  /*
	c ^= 0x20;
  if(c >= (SJIS1_S1 ^ 0x20) && c <= (SJIS1_E2 ^ 0x20)) return TRUE;
  return FALSE;
	*/
	return ((c ^= 0x20) && (c >= (SJIS1_S1 ^ 0x20) && c <= (SJIS1_E2 ^ 0x20)));
}

BOOL dkcIsSJIS2(BYTE c)
{
	/*if(dkcmIsSJIS2(c)) return TRUE;
  return FALSE;
	*/
	return (c >= SJIS2_S1 && c <= SJIS2_E1) || (c >= SJIS2_S2 && c <= SJIS2_E2);
}

BOOL dkcIsSpace(BYTE c)
{
	return (c=='\0' || c==0x0a || c==0x0d || c==' ' || c=='\t');
}

const char *dkcGetSpaceSeparator(){
	static const char temp[]={
		'\0',0x0a,0x0d,' ','\t','\0','\0'
	};
	return temp;
}

// SJISOĕAŏɌʒuԂ
int WINAPI dkcSJIS_StrChrSearch(const char *s, char c)
{
  // c == 0 lĂ
  int i;
	for(i = 0; ; i++){
      if(s[i] == c) return i;
      if(s[i] == '\0') break;
      if(dkcmIsSJIS1(s[i]) && dkcmIsSJIS2(s[i + 1])) i++;
  }
  return -1;
} 

// SJISOĕAŌɌʒuԂ
int WINAPI dkcSJIS_StrChrSearchLast(const char *s, char c)
{
  int nLast = -1,i;
  // c == 0 lĂ
  for(i = 0; ; i++){
    if(s[i] == c) nLast = i;
    if(s[i] == '\0') break;
    if(dkcmIsSJIS1(s[i]) && dkcmIsSJIS2(s[i + 1])) i++;
  }
  return nLast;
} 

int WINAPI dkcSJIS_StrChrSearchTail(const char *s,size_t len,char c){
	int i;
	for(i=len;i > 0;i--){//sjis𒲂ׂ邽i > 0 i0ɂȂIB
		if(dkcmIsSJIS1(s[i - 1]) && dkcmIsSJIS2(s[i]) )
		{
			i--;
			continue;
		}
		if(s[i] == c) return i;
	}
	//i0̎B
	if(! (dkcmIsSJIS1(s[i]) && dkcmIsSJIS2(s[i + 1]) ))
	{
		if(c==s[i]){
			return 0;
		}
	}
	return -1;
}

int WINAPI dkcSJIS_StrChrSearchInStr(const char *s,const char *c)
{
	// c == 0 lĂ
  size_t i,j;
	size_t len = strlen(c);
	for(i = 0; ; i++){
		if(s[i] == '\0') break;
		if(dkcmIsSJIS1(s[i]) && dkcmIsSJIS2(s[i + 1])){
			i++;
			continue;
		}
		for(j=0;j<len;j++){
      if(s[i] == c[j]) return i;
		}
  }
  return -1;
}

int WINAPI dkcSJIS_StrChrSearchInStrLast(const char *s, const char *c)
{
  int nLast = -1;
	size_t i,j;
	size_t len = strlen(c);
  // c == 0 lĂ
  for(i = 0; ; i++){
    if(s[i] == '\0') break;
    if(dkcmIsSJIS1(s[i]) && dkcmIsSJIS2(s[i + 1])){
			i++;
			continue;
		}
		for(j=0;j<len;j++){
			if(s[i] == c[j]) nLast = i;
		}
  }
  return nLast;
} 

int WINAPI dkcSJIS_SearchPathSep(const char *s)
{
	const char *target = dkcGetPathSep();
	return dkcSJIS_StrChrSearchInStr(s,target);
}

int WINAPI dkcSJIS_SearchPathSepLast(const char *s)
{
	const char *target = dkcGetPathSep();
	return dkcSJIS_StrChrSearchInStrLast(s,target);
}


int WINAPI dkcStrStr(const char *dest,const char *src)
{
	char *p = strstr(dest,src);
	if(NULL==p) return -1;
	if((size_t)p - (size_t)dest > INT_MAX){
		return -2;
	}
	return (int)(p - dest);
	/*int offset = p - dest;//overflowƊȂ
	if(offset < 0) return -1;
	return offset;
	*/
}

static int dkcBMStrStrLogic(const char *text,const char *pattern)
{
	int i, j, k, len;
	int skip[UCHAR_MAX + 1];
	unsigned char c, tail;

	len = strlen((char *)pattern);  /* ̒ */
	if (len == 0) return -1;        /* G[: 0 */
	tail = pattern[len - 1];        /* Ō̕ */
	if (len == 1) {                 /* 1ȂȒP! */
		for (i = 0; text[i] != '\0'; i++)
			if (text[i] == tail) return i;
	} else {                        // 2ȏȂ\āc 
		for (i = 0; i <= UCHAR_MAX; i++) skip[i] = len;
		for (i = 0; i < len - 1; i++)
			skip[pattern[i]] = len - 1 - i;
		/* i = len - 1; */          // 悢ƍ 
		while ((c = text[i]) != '\0') {
/*     // fXg[Vp 
			printf("e: %s\n", text);
			printf(": %*s\n", i + 1, pattern);
*/
			if (c == tail) {
				j = len - 1;  k = i;
				while (pattern[--j] == text[--k])
					if (j == 0) return k;  // 
			}
			i += skip[c];
		}
	}
	return -1;  // Ȃ 
}


int WINAPI dkcBMStrStr(const char *dest,const char *src)
{
	return dkcBMStrStrLogic(dest,src);
}

//**********************************************************



DKC_STRING * WINAPI dkcAllocString(size_t size){
	DKC_STRING *p;
	//ւȈ͏O
	//if(dkcErrorFlagCheck(flag)) return edk_ArgumentException;
	
	p = (DKC_STRING *)dkcAllocate(sizeof(DKC_STRING));
	if(NULL==p) return NULL;
	
	p->mStream = dkcAllocMemoryStream(size + 1);
	if(NULL==p->mStream) goto Error;

	p->mByteSize = 0;

	return p;
Error:
	dkcFree((void **)&p);
	return NULL;
}

int WINAPI dkcFreeString(DKC_STRING **ptr){
	//ςȈȁI
	if(NULL==ptr || NULL==*ptr || NULL==(*ptr)->mStream){return edk_ArgumentException;}
	dkcFreeMemoryStream(&(*ptr)->mStream);
	return dkcFree((void **)ptr);
}


int WINAPI dkcStringCopy(DKC_STRING *ptr,const char *str,size_t size)
{
	dkcmNOT_ASSERT(NULL==ptr  || NULL==ptr->mStream || 0==size);

	if(DKUTIL_FAILED(dkcMemoryStreamSeek(ptr->mStream,0,edkcMemoryStreamSeekSet))){
		return edk_FAILED;
	}

	dkcMemoryStreamClear(ptr->mStream);
	
	if(DKUTIL_FAILED(dkcMemoryStreamDynamicWrite(ptr->mStream,str,
		size + 1/* + 1NULLRs[*/)))
	{
		return edk_FAILED;
	}

	ptr->mByteSize = size;

	return edk_SUCCEEDED;
}

int WINAPI dkcStringConcatenate(DKC_STRING *ptr,const char *str,size_t size){
	dkcmNOT_ASSERT(NULL==ptr  || NULL==ptr->mStream || 0==size);

	if(0 != ptr->mByteSize){
		ptr->mStream->mNowOffset --;//炵NULLׂB
	}
	if(DKUTIL_FAILED(dkcMemoryStreamDynamicWrite(ptr->mStream,str,size + 1)))//+1NULLRs[
	{
		return edk_FAILED;
	}

	ptr->mByteSize += size;

	return edk_SUCCEEDED;
}

int WINAPI dkcStringInsert(DKC_STRING *ptr,size_t point,const char *str,size_t size)
{
	size_t tpo;//ꎞItZbgۑ
	char *tp;//buffertemp
	//char *mlctp;//mallocŊmۂobt@temp
	//size_t len;//tpo - point
	//size_t maxbuffsize;//ptr->mStream->mSize - len

	dkcmNOT_ASSERT(NULL==ptr  || NULL==ptr->mStream);
	if(0==size){
		return edk_Not_Satisfactory;
	}
	//lock thread

	//ւ񂪃Xe[g}V猙OOG



	//G[`FbN
	{
		tpo = dkcMemoryStreamGetSeekPoint(ptr->mStream);
		if(point > tpo)
		{//point͂ݏoĂB
			return edk_ArgumentException;
		}
		//Ƃ肠Apush!!
		dkcStringConcatenate(ptr,str,size);//mByteSize+=ĂB

		tp = (char *)ptr->mStream->mBuffer;

		//xAConcatenatêōĎ擾
		tpo = dkcMemoryStreamGetSeekPoint(ptr->mStream);

		//ւĂB
		dkc_stream_swap(&tp[point],tpo - point - 1,tpo - point - size - 1);

	}
	return edk_SUCCEEDED;
		
	//unlock thread



}

int WINAPI dkcStringErase(DKC_STRING *ptr,size_t point,size_t len)
{
	char *tp;
	size_t size;
	int r;

	tp = (char *)ptr->mStream->mBuffer;
	size = ptr->mStream->mNowOffset;
	if(point + len >= size){
		len = size - len;
		dkcMemoryStreamSeek(ptr->mStream,len,edkcMemoryStreamSeekSet);

		return edk_Not_Satisfactory;
	}
	else
	{
		dkc_stream_swap(&tp[point],size - point - 1,len);//vȂ̈ɎĂB
	
		ptr->mByteSize -= len;//ȂB
		//obt@I[o[t[ȂƎvǥB
		ptr->mStream->mBuffer[ptr->mByteSize] = '\0';
		
	
		r = dkcMemoryStreamSeek(ptr->mStream,size - len,edkcMemoryStreamSeekSet);
	}
	return r;
}

int WINAPI dkcStringReplace(DKC_STRING *ptr,size_t begin_,size_t end_,
														const char *str,size_t size)
{
	//ǂŁOOGGGG
	dkcStringErase(ptr,begin_,end_ - begin_);
	return dkcStringInsert(ptr,begin_,str,size);
}



size_t dkcStringSize(const DKC_STRING *ptr){
	return ptr->mByteSize;
}

size_t dkcStringNum(const DKC_STRING *ptr){
	return ptr->mByteSize;
}

const char * WINAPI dkcStringPointer(const DKC_STRING *ptr){
	//if(dkcErrorPtrCheck(ptr)) return edk_FAILED;
	return (const char *)ptr->mStream->mBuffer;
}

int WINAPI dkcStringGetBuffer(const DKC_STRING *ptr,char *buffer,size_t buffsize)
{
	int r;
	size_t num;
	if(NULL==ptr) return edk_FAILED;
	num = dkcStringNum(ptr);
	r = dkc_memcpy(buffer,buffsize,ptr->mStream->mBuffer,ptr->mStream->mNowOffset);
	if(DKUTIL_FAILED(r)) return r;
	
	return r;
	//return dkcStreamToBuffer(ptr->mStream,edkcStreamSeekSet,0,num,buffer,buffsize);
}
#if 0

int WINAPI dkcStringSerialize(const DKC_STRING *ptr,DKC_SERIALIZE *se)
{
	int id = edkcSerializeIDString;
	dkcmNOT_ASSERT(NULL==ptr);
	dkcSerializeWrite(se,&id,sizeof(id));
	dkcMemoryStreamSerialize(ptr->mStream,se);
	return dkcSerializeWrite(se,ptr,sizeof(DKC_STRING));
}

DKC_STRING* WINAPI dkcAllocStringDeserialize(DKC_DESERIALIZE *se)
{
	DKC_STRING *p;
	DKC_STRING t;
	DKC_MEMORYSTREAM *mem;
	size_t read;
	int id;
	
	dkcDeserializeRead(se,&id,sizeof(id),&read);
	if(id !=  edkcSerializeIDString)
	{
		return NULL;
	}

	mem = dkcAllocMemoryStreamDeserialize(se);
	if(NULL==mem){
		return NULL;
		}

	dkcDeserializeRead(se,&t,sizeof(t),&read);

	p = dkcAllocString(0);
	if(NULL==p){
		return NULL;
		}
	
	dkcFreeMemoryStream(&p->mStream);
	p->mByteSize = t.mByteSize;
	p->mStream = mem;

	//dkcmNOT_ASSERT(read != p->mSize);
	
	return p;

}

#endif