/*!
@file dkcMD2.h
@brief MD2 Algorithm
@author wrapped by d
@note
MD2͂łɏIHASYȂ̂ŁASHA1pB
܂A2005Nx݂ňSlȂSHA256ȏɂƗǂƎv܂B
*/



#ifndef DKUTIL_C_MD2_H
#define DKUTIL_C_MD2_H

#include "md_misc.h"
#include "dkcOSIndependent.h"


///MD2oCĩVOl`ۑɕKvȗ̈
#define MD2_BIN_BUFFER_SIZE 16
///MD2̃VOl`ۑɕKvȗ̈
#define MD2_STR_BUFFER_SIZE 33


typedef struct dkc_MD2{
  	
	uint8 C[16];
	uint8 X[48];
	//int count;
	unsigned int count;
	uint8 buf[16];
	uint8 flags;
}DKC_MD2;


/*!
@return DKC_MD2\̂ւ̊mۂ̈
@note
łdkcMD2Init()͌Ă΂Ă܂B
*/
DKC_EXTERN DKC_MD2 *WINAPI dkcAllocMD2();

///@return dkcAllocMD2()擾̈B
DKC_EXTERN void WINAPI dkcMD2Init(DKC_MD2 *);

DKC_INLINE void dkcMD2InitEx(DKC_MD2 *p,uint8 flags)
{
	dkcMD2Init(p);
	p->flags = flags;
}

/*!
@param p[in][out] dkcAllocMD2()Ŏ擾|C^
@param pBuffer[in] ǂݎobt@ւ̃|C^
@param dwSize[in] obt@ɃANZXOKȃTCY
@return edk_SUCCEEDEDŐ
@note
Cu̓sɂAdkcMD2Load()INT_MAX傫obt@Ȃ
*/
DKC_EXTERN void WINAPI dkcMD2Load(DKC_MD2 *p,const BYTE *pBuffer,DWORD dwSize);


/*!
@param p[in][out] dkcAllocMD2()Ŏ擾|C^
@note
dkcMD2FinalDigest()gp鎖サ܂B
*/
DKC_EXTERN void WINAPI dkcMD2Final(DKC_MD2 *p);
/*!
@param p[in][out] dkcAllocMD2()Ŏ擾|C^
@param buff[out] ރobt@ւ̃|C^
@param size[in] buff̃TCY
@return edk_SUCCEEDEDԂ
*/
DKC_EXTERN int WINAPI dkcMD2DigestStr(DKC_MD2 *p,char *buff,size_t size);
///@see dkcMD2DigestStr()
DKC_EXTERN int WINAPI dkcMD2Digest(DKC_MD2 *p,BYTE *buff,size_t size);

/*!
@see A߂lɂĂdkcMD2Digest()ƓłB 
@note
dkcMD2Final()dkcMD2Digest()gpÅ֐̎gpサ܂B
*/
DKC_EXTERN int WINAPI dkcMD2FinalDigestStr(DKC_MD2 *p,char *buff,size_t size);
///@see dkcMD2FinalDigestStr()
DKC_EXTERN int WINAPI dkcMD2FinalDigest(DKC_MD2 *p,BYTE *buff,size_t size);

/*!
@param p[in][out] dkcAllocMD2()Ŏ擾|C^ւ̃|C^
@return 肭Jłedk_SUCCEEDED
*/
DKC_EXTERN int WINAPI dkcFreeMD2(DKC_MD2 **p);



#endif //end of include once