/**
@file dkcLZW.h
@brief LZWkASY
@author d
@note
gifɏkɂ邩A
M.HiroiHPŏЉĂgbL[Ȏ@ňk҂c
ǂɂ悤H

łȀAC@|P|Q 2005/03/20 d

2005/03/27 
	M.HiroiHPi@http://www.geocities.jp/m_hiroi/@jŏЉĂ	
	http://www.geocities.jp/m_hiroi/zsaru/zsarub36.html̃TCgQlɂA
	Hash + Ternary Search Tree + Red Black TreẽASYgpĎ鎖ɂB




*/
#ifndef DKUTILC_LZW_H
#define DKUTILC_LZW_H


#include "dkcOSIndependent.h"
#include "dkcRedBlackTree.h"
#include "dkcBit.h"



///LZW̃VOl`iύXĂv`i))
#define dkcdLZW_SIGNATURE edk_LZW_SIGNATURE

//#define dkcdLZW_SIGNATURE 'LZW'

//**********************************************************
//TST


///code size ?
#define dkcdLZW_CODE_SIZE 15
///lzw buffer ̐
#define  dkcdLZW_NUM (1 << dkcdLZW_CODE_SIZE)
///NULL̑Asentinel
#define  dkcdLZW_NIL(objp) objp->sentinel//(&(objp->sentinel))
///@see dkcdLZW_NIL()
#define dkcdLZW_NIL_OFFSET dkcdLZW_NUM


//**********************************************************
//hash

///65521A  
#define dkcdLZW_HASH_TABLE_SIZE 32749 

#define dkcmLZW_HASH_FUNC(node,c) ((((node) << 8) + (c)) % dkcdLZW_HASH_TABLE_SIZE)

///f[^^Cv
#define dkcdLZW_DATA int
///red black treeŎgFۑpϐ(int^ɂĂǂj
#define dkcdLZW_COLOR uint8

///LZWTernary Search Tree + Red Black TreeASYɎgm[h
typedef struct dkc_LZW_Node{
	///f[^
	dkcdLZW_DATA code;
	///e
	struct dkc_LZW_Node *parent;
	///̗t
	struct dkc_LZW_Node *left;
	///^̗t
	struct dkc_LZW_Node *middle;
	///E̗t
	struct dkc_LZW_Node *right;
	///red black̂ǂ炩̐F
	dkcdLZW_COLOR color;
}DKC_LZW_NODE;

typedef struct dkc_LZW_Trie{
	dkcdLZW_DATA code;
	dkcdLZW_DATA p;
}DKC_LZW_TRIE;

typedef struct dkc_LZW
{
	
	union{
		///tst node pool
		DKC_LZW_NODE tst[dkcdLZW_NUM];
		DKC_LZW_TRIE trie[dkcdLZW_NUM];
		///hash algorithm
	}pool;
	///nbVe[u num of dkcdLZW_HASH_TABLE_SIZE
	dkcdLZW_DATA *hash_table;
	///}ԂL^ num of dkcdLZW_NUM
	dkcdLZW_DATA *hash_stack;
	///count
	size_t node_count;

	DKC_LZW_NODE *sentinel;

	DKC_BIT_MEMORYSTREAM *mbs;
}DKC_LZW;

typedef struct dkc_LZW_Header{
	unsigned long mSignature;
	///̃TCY
	size_t mOriginSize;
	///kTCY
	size_t mCompressedSize;
	///kIvV @see edk_LZW_Option
	ULONG option;
}DKC_LZW_HEADER;

enum edk_LZW_Option{
	///ftHg̐ݒ
	edkcLZW_Default = 0,
	///ϒg
	edkcLZW_Variableness = 1,
	///TSTg
	edkcLZW_TST = 2,
	///hash@g
	edkcLZW_HASH = 4,
	///red black treeg
	edkcLZW_REDBLACK = 8,
	///trieg
	edkcLZW_TRIE = 16,
	
};
/**
@param output_block_size[in] ̃GR[hAfR[hɏTCY
*/
DKC_EXTERN DKC_LZW *WINAPI dkcAllocLZW(size_t output_block_size);

DKC_EXTERN int WINAPI dkcFreeLZW(DKC_LZW **);
/*!
@param ptr[in][out] dkcAllocLZW()Ŏ擾|C^
@param ph[out] DKC_LZW_HEADERւ̃|C^
@param dest[out] fR[hꂽf[^̏oobt@ւ̃|C^
@param dsize[in] dest̃TCY
@param src[in] obt@ւ̃|C^
@param ssize[in] src̃TCY
@param sig[in] dkcLZWEncode()̎Aw肵VOl`ID
@return edk_Result̂ǂꂩԂB
@note
DKC_LZW_HEADER̃omOriginSizedsizeƂ̊֐͎s܂B
*/
DKC_EXTERN int WINAPI dkcLZWDecode(DKC_LZW *ptr,DKC_LZW_HEADER *ph,
	BYTE *dest,size_t dsize,const BYTE *src,size_t ssize,ULONG sig);
/*!
@param ptr[in][out] dkcAllocLZW()Ŏ擾|C^
@param ph[out] DKC_LZW_HEADERւ̃|C^
@param dest[out] LZWňkꂽf[^̏oobt@ւ̃|C^
@param dsize[in] dest̃TCY
@param src[in] obt@ւ̃|C^
@param ssize[in] src̃TCY
@param CloseProcessSize[in] ł؂ɂTCY dsize菬̂ZI[
@param sig[in] LZWƏؖVOl`
@return edk_Result̂ǂꂩԂBk鉿l̖ꍇedk_NoValueToProcessԂB
*/
DKC_EXTERN int WINAPI dkcLZWEncode(DKC_LZW *ptr,DKC_LZW_HEADER *ph,
	BYTE *dest,size_t dsize,const BYTE *src,size_t ssize,
	size_t CloseProcessSize,ULONG sig,ULONG option);



//headerLZW̃VOl`ǂmF @return TRUELZWf[^ƎvB
//p~FVOl`͎Rɐݒł悤ɁII
//DKC_EXTERN BOOL WINAPI dkcLZWIsLZW(DKC_LZW_HEADER *p);

///@see dkcBitMemoryStreamDump()
#define dkcLZWDump(lzwobj,filename) dkcBitMemoryStreamDump(lzwobj->mbs,filename,edkcDumpNowOffset)


#endif //end of include once