

#include "dkcCamellia.h"


static const uint8 sbox1[256]={
  0x70,0x82,0x2c,0xec,0xb3,0x27,0xc0,0xe5,0xe4,0x85,0x57,0x35,0xea,0x0c,0xae,0x41,
  0x23,0xef,0x6b,0x93,0x45,0x19,0xa5,0x21,0xed,0x0e,0x4f,0x4e,0x1d,0x65,0x92,0xbd,
  0x86,0xb8,0xaf,0x8f,0x7c,0xeb,0x1f,0xce,0x3e,0x30,0xdc,0x5f,0x5e,0xc5,0x0b,0x1a,
  0xa6,0xe1,0x39,0xca,0xd5,0x47,0x5d,0x3d,0xd9,0x01,0x5a,0xd6,0x51,0x56,0x6c,0x4d,
  0x8b,0x0d,0x9a,0x66,0xfb,0xcc,0xb0,0x2d,0x74,0x12,0x2b,0x20,0xf0,0xb1,0x84,0x99,
  0xdf,0x4c,0xcb,0xc2,0x34,0x7e,0x76,0x05,0x6d,0xb7,0xa9,0x31,0xd1,0x17,0x04,0xd7,
  0x14,0x58,0x3a,0x61,0xde,0x1b,0x11,0x1c,0x32,0x0f,0x9c,0x16,0x53,0x18,0xf2,0x22,
  0xfe,0x44,0xcf,0xb2,0xc3,0xb5,0x7a,0x91,0x24,0x08,0xe8,0xa8,0x60,0xfc,0x69,0x50,
  0xaa,0xd0,0xa0,0x7d,0xa1,0x89,0x62,0x97,0x54,0x5b,0x1e,0x95,0xe0,0xff,0x64,0xd2,
  0x10,0xc4,0x00,0x48,0xa3,0xf7,0x75,0xdb,0x8a,0x03,0xe6,0xda,0x09,0x3f,0xdd,0x94,
  0x87,0x5c,0x83,0x02,0xcd,0x4a,0x90,0x33,0x73,0x67,0xf6,0xf3,0x9d,0x7f,0xbf,0xe2,
  0x52,0x9b,0xd8,0x26,0xc8,0x37,0xc6,0x3b,0x81,0x96,0x6f,0x4b,0x13,0xbe,0x63,0x2e,
  0xe9,0x79,0xa7,0x8c,0x9f,0x6e,0xbc,0x8e,0x29,0xf5,0xf9,0xb6,0x2f,0xfd,0xb4,0x59,
  0x78,0x98,0x06,0x6a,0xe7,0x46,0x71,0xba,0xd4,0x25,0xab,0x42,0x88,0xa2,0x8d,0xfa,
  0x72,0x07,0xb9,0x55,0xf8,0xee,0xac,0x0a,0x36,0x49,0x2a,0x68,0x3c,0x38,0xf1,0xa4,
  0x40,0x28,0xd3,0x7b,0xbb,0xc9,0x43,0xc1,0x15,0xe3,0xad,0xf4,0x77,0xc7,0x80,0x9e
  };
static const uint8 sbox2[256]={
  0xe0,0x05,0x58,0xd9,0x67,0x4e,0x81,0xcb,0xc9,0x0b,0xae,0x6a,0xd5,0x18,0x5d,0x82,
  0x46,0xdf,0xd6,0x27,0x8a,0x32,0x4b,0x42,0xdb,0x1c,0x9e,0x9c,0x3a,0xca,0x25,0x7b,
  0x0d,0x71,0x5f,0x1f,0xf8,0xd7,0x3e,0x9d,0x7c,0x60,0xb9,0xbe,0xbc,0x8b,0x16,0x34,
  0x4d,0xc3,0x72,0x95,0xab,0x8e,0xba,0x7a,0xb3,0x02,0xb4,0xad,0xa2,0xac,0xd8,0x9a,
  0x17,0x1a,0x35,0xcc,0xf7,0x99,0x61,0x5a,0xe8,0x24,0x56,0x40,0xe1,0x63,0x09,0x33,
  0xbf,0x98,0x97,0x85,0x68,0xfc,0xec,0x0a,0xda,0x6f,0x53,0x62,0xa3,0x2e,0x08,0xaf,
  0x28,0xb0,0x74,0xc2,0xbd,0x36,0x22,0x38,0x64,0x1e,0x39,0x2c,0xa6,0x30,0xe5,0x44,
  0xfd,0x88,0x9f,0x65,0x87,0x6b,0xf4,0x23,0x48,0x10,0xd1,0x51,0xc0,0xf9,0xd2,0xa0,
  0x55,0xa1,0x41,0xfa,0x43,0x13,0xc4,0x2f,0xa8,0xb6,0x3c,0x2b,0xc1,0xff,0xc8,0xa5,
  0x20,0x89,0x00,0x90,0x47,0xef,0xea,0xb7,0x15,0x06,0xcd,0xb5,0x12,0x7e,0xbb,0x29,
  0x0f,0xb8,0x07,0x04,0x9b,0x94,0x21,0x66,0xe6,0xce,0xed,0xe7,0x3b,0xfe,0x7f,0xc5,
  0xa4,0x37,0xb1,0x4c,0x91,0x6e,0x8d,0x76,0x03,0x2d,0xde,0x96,0x26,0x7d,0xc6,0x5c,
  0xd3,0xf2,0x4f,0x19,0x3f,0xdc,0x79,0x1d,0x52,0xeb,0xf3,0x6d,0x5e,0xfb,0x69,0xb2,
  0xf0,0x31,0x0c,0xd4,0xcf,0x8c,0xe2,0x75,0xa9,0x4a,0x57,0x84,0x11,0x45,0x1b,0xf5,
  0xe4,0x0e,0x73,0xaa,0xf1,0xdd,0x59,0x14,0x6c,0x92,0x54,0xd0,0x78,0x70,0xe3,0x49,
  0x80,0x50,0xa7,0xf6,0x77,0x93,0x86,0x83,0x2a,0xc7,0x5b,0xe9,0xee,0x8f,0x01,0x3d
  };
static const uint8 sbox3[256]={
  0x38,0x41,0x16,0x76,0xd9,0x93,0x60,0xf2,0x72,0xc2,0xab,0x9a,0x75,0x06,0x57,0xa0,
  0x91,0xf7,0xb5,0xc9,0xa2,0x8c,0xd2,0x90,0xf6,0x07,0xa7,0x27,0x8e,0xb2,0x49,0xde,
  0x43,0x5c,0xd7,0xc7,0x3e,0xf5,0x8f,0x67,0x1f,0x18,0x6e,0xaf,0x2f,0xe2,0x85,0x0d,
  0x53,0xf0,0x9c,0x65,0xea,0xa3,0xae,0x9e,0xec,0x80,0x2d,0x6b,0xa8,0x2b,0x36,0xa6,
  0xc5,0x86,0x4d,0x33,0xfd,0x66,0x58,0x96,0x3a,0x09,0x95,0x10,0x78,0xd8,0x42,0xcc,
  0xef,0x26,0xe5,0x61,0x1a,0x3f,0x3b,0x82,0xb6,0xdb,0xd4,0x98,0xe8,0x8b,0x02,0xeb,
  0x0a,0x2c,0x1d,0xb0,0x6f,0x8d,0x88,0x0e,0x19,0x87,0x4e,0x0b,0xa9,0x0c,0x79,0x11,
  0x7f,0x22,0xe7,0x59,0xe1,0xda,0x3d,0xc8,0x12,0x04,0x74,0x54,0x30,0x7e,0xb4,0x28,
  0x55,0x68,0x50,0xbe,0xd0,0xc4,0x31,0xcb,0x2a,0xad,0x0f,0xca,0x70,0xff,0x32,0x69,
  0x08,0x62,0x00,0x24,0xd1,0xfb,0xba,0xed,0x45,0x81,0x73,0x6d,0x84,0x9f,0xee,0x4a,
  0xc3,0x2e,0xc1,0x01,0xe6,0x25,0x48,0x99,0xb9,0xb3,0x7b,0xf9,0xce,0xbf,0xdf,0x71,
  0x29,0xcd,0x6c,0x13,0x64,0x9b,0x63,0x9d,0xc0,0x4b,0xb7,0xa5,0x89,0x5f,0xb1,0x17,
  0xf4,0xbc,0xd3,0x46,0xcf,0x37,0x5e,0x47,0x94,0xfa,0xfc,0x5b,0x97,0xfe,0x5a,0xac,
  0x3c,0x4c,0x03,0x35,0xf3,0x23,0xb8,0x5d,0x6a,0x92,0xd5,0x21,0x44,0x51,0xc6,0x7d,
  0x39,0x83,0xdc,0xaa,0x7c,0x77,0x56,0x05,0x1b,0xa4,0x15,0x34,0x1e,0x1c,0xf8,0x52,
  0x20,0x14,0xe9,0xbd,0xdd,0xe4,0xa1,0xe0,0x8a,0xf1,0xd6,0x7a,0xbb,0xe3,0x40,0x4f
  };
static const uint8 sbos4[256]={
  0x70,0x2c,0xb3,0xc0,0xe4,0x57,0xea,0xae,0x23,0x6b,0x45,0xa5,0xed,0x4f,0x1d,0x92,
  0x86,0xaf,0x7c,0x1f,0x3e,0xdc,0x5e,0x0b,0xa6,0x39,0xd5,0x5d,0xd9,0x5a,0x51,0x6c,
  0x8b,0x9a,0xfb,0xb0,0x74,0x2b,0xf0,0x84,0xdf,0xcb,0x34,0x76,0x6d,0xa9,0xd1,0x04,
  0x14,0x3a,0xde,0x11,0x32,0x9c,0x53,0xf2,0xfe,0xcf,0xc3,0x7a,0x24,0xe8,0x60,0x69,
  0xaa,0xa0,0xa1,0x62,0x54,0x1e,0xe0,0x64,0x10,0x00,0xa3,0x75,0x8a,0xe6,0x09,0xdd,
  0x87,0x83,0xcd,0x90,0x73,0xf6,0x9d,0xbf,0x52,0xd8,0xc8,0xc6,0x81,0x6f,0x13,0x63,
  0xe9,0xa7,0x9f,0xbc,0x29,0xf9,0x2f,0xb4,0x78,0x06,0xe7,0x71,0xd4,0xab,0x88,0x8d,
  0x72,0xb9,0xf8,0xac,0x36,0x2a,0x3c,0xf1,0x40,0xd3,0xbb,0x43,0x15,0xad,0x77,0x80,
  0x82,0xec,0x27,0xe5,0x85,0x35,0x0c,0x41,0xef,0x93,0x19,0x21,0x0e,0x4e,0x65,0xbd,
  0xb8,0x8f,0xeb,0xce,0x30,0x5f,0xc5,0x1a,0xe1,0xca,0x47,0x3d,0x01,0xd6,0x56,0x4d,
  0x0d,0x66,0xcc,0x2d,0x12,0x20,0xb1,0x99,0x4c,0xc2,0x7e,0x05,0xb7,0x31,0x17,0xd7,
  0x58,0x61,0x1b,0x1c,0x0f,0x16,0x18,0x22,0x44,0xb2,0xb5,0x91,0x08,0xa8,0xfc,0x50,
  0xd0,0x7d,0x89,0x97,0x5b,0x95,0xff,0xd2,0xc4,0x48,0xf7,0xdb,0x03,0xda,0x3f,0x94,
  0x5c,0x02,0x4a,0x33,0x67,0xf3,0x7f,0xe2,0x9b,0x26,0x37,0x3b,0x96,0x4b,0xbe,0x2e,
  0x79,0x8c,0x6e,0x8e,0xf5,0xb6,0xfd,0x59,0x98,0x6a,0x46,0xba,0x25,0x42,0xa2,0xfa,
  0x07,0x55,0xee,0x0a,0x49,0x68,0x38,0xa4,0x28,0x7b,0xc9,0xc1,0xe3,0xf4,0xc7,0x9e
  };




void Camellia_Ekeygen( const int, const Byte *, Byte * );
void Camellia_Encrypt( const int, const Byte *, const Byte *, Byte * );
void Camellia_Decrypt( const int, const Byte *, const Byte *, Byte * );
void Camellia_Feistel( const Byte *, const Byte *, Byte * );
void Camellia_FLlayer( Byte *, const Byte *, const Byte * );

void ByteWord( const Byte *, uint32 * );
void WordByte( const uint32 *, Byte * );
void XorBlock( const Byte *, const Byte *, Byte * );
void SwapHalf( Byte * );
void RotBlock( const uint32 *, const int, uint32 * );

const Byte SIGMA[48] = {
0xa0,0x9e,0x66,0x7f,0x3b,0xcc,0x90,0x8b,
0xb6,0x7a,0xe8,0x58,0x4c,0xaa,0x73,0xb2,
0xc6,0xef,0x37,0x2f,0xe9,0x4f,0x82,0xbe,
0x54,0xff,0x53,0xa5,0xf1,0xd3,0x6f,0x1c,
0x10,0xe5,0x27,0xfa,0xde,0x68,0x2d,0x1d,
0xb0,0x56,0x88,0xc2,0xb3,0xe6,0xc1,0xfd};

const int KSFT1[26] = {
0,64,0,64,15,79,15,79,30,94,45,109,45,124,60,124,77,13,
94,30,94,30,111,47,111,47 };
const int KIDX1[26] = {
0,0,4,4,0,0,4,4,4,4,0,0,4,0,4,4,0,0,0,0,4,4,0,0,4,4 };
const int KSFT2[34] = {
0,64,0,64,15,79,15,79,30,94,30,94,45,109,45,109,60,124,
60,124,60,124,77,13,77,13,94,30,94,30,111,47,111,47 };
const int KIDX2[34] = {
0,0,12,12,8,8,4,4,8,8,12,12,0,0,4,4,0,0,8,8,12,12,
0,0,4,4,8,8,4,4,0,0,12,12 };

const Byte SBOX[256] = {
112,130, 44,236,179, 39,192,229,228,133, 87, 53,234, 12,174, 65,
 35,239,107,147, 69, 25,165, 33,237, 14, 79, 78, 29,101,146,189,
134,184,175,143,124,235, 31,206, 62, 48,220, 95, 94,197, 11, 26,
166,225, 57,202,213, 71, 93, 61,217,  1, 90,214, 81, 86,108, 77,
139, 13,154,102,251,204,176, 45,116, 18, 43, 32,240,177,132,153,
223, 76,203,194, 52,126,118,  5,109,183,169, 49,209, 23,  4,215,
 20, 88, 58, 97,222, 27, 17, 28, 50, 15,156, 22, 83, 24,242, 34,
254, 68,207,178,195,181,122,145, 36,  8,232,168, 96,252,105, 80,
170,208,160,125,161,137, 98,151, 84, 91, 30,149,224,255,100,210,
 16,196,  0, 72,163,247,117,219,138,  3,230,218,  9, 63,221,148,
135, 92,131,  2,205, 74,144, 51,115,103,246,243,157,127,191,226,
 82,155,216, 38,200, 55,198, 59,129,150,111, 75, 19,190, 99, 46,
233,121,167,140,159,110,188,142, 41,245,249,182, 47,253,180, 89,
120,152,  6,106,231, 70,113,186,212, 37,171, 66,136,162,141,250,
114,  7,185, 85,248,238,172, 10, 54, 73, 42,104, 60, 56,241,164,
 64, 40,211,123,187,201, 67,193, 21,227,173,244,119,199,128,158};

#define SBOX1(n) SBOX[(n)]
#define SBOX2(n) (Byte)((SBOX[(n)]>>7^SBOX[(n)]<<1)&0xff)
#define SBOX3(n) (Byte)((SBOX[(n)]>>1^SBOX[(n)]<<7)&0xff)
#define SBOX4(n) SBOX[((n)<<1^(n)>>7)&0xff]

void Camellia_Ekeygen( const int n, const Byte *k, Byte *e )
{
	Byte t[64];
	uint32 u[20];
	int  i;

	if( n == 128 ){
		for( i=0 ; i<16; i++ ) t[i] = k[i];
		for( i=16; i<32; i++ ) t[i] = 0;
	}
	else if( n == 192 ){
		for( i=0 ; i<24; i++ ) t[i] = k[i];
		for( i=24; i<32; i++ ) t[i] = k[i-8]^0xff;
	}
	else if( n == 256 ){
		for( i=0 ; i<32; i++ ) t[i] = k[i];
	}

	XorBlock( t+0, t+16, t+32 );

	Camellia_Feistel( t+32, SIGMA+0, t+40 );
	Camellia_Feistel( t+40, SIGMA+8, t+32 );

	XorBlock( t+32, t+0, t+32 );

	Camellia_Feistel( t+32, SIGMA+16, t+40 );
	Camellia_Feistel( t+40, SIGMA+24, t+32 );

	ByteWord( t+0,  u+0 );
	ByteWord( t+32, u+4 );

	if( n == 128 ){
		for( i=0; i<26; i+=2 ){
			RotBlock( u+KIDX1[i+0], KSFT1[i+0], u+16 );
			RotBlock( u+KIDX1[i+1], KSFT1[i+1], u+18 );
			WordByte( u+16, e+i*8 );
		}
	}
	else{
		XorBlock( t+32, t+16, t+48 );

		Camellia_Feistel( t+48, SIGMA+32, t+56 );
		Camellia_Feistel( t+56, SIGMA+40, t+48 );

		ByteWord( t+16, u+8  );
		ByteWord( t+48, u+12 );

		for( i=0; i<34; i+=2 ){
			RotBlock( u+KIDX2[i+0], KSFT2[i+0], u+16 );
			RotBlock( u+KIDX2[i+1], KSFT2[i+1], u+18 );
			WordByte( u+16, e+(i<<3) );
		}
	}
}

void Camellia_Encrypt( const int n, const Byte *p, const Byte *e, Byte *c )
{
	int i;

	XorBlock( p, e+0, c );

	for( i=0; i<3; i++ ){
		Camellia_Feistel( c+0, e+16+(i<<4), c+8 );
		Camellia_Feistel( c+8, e+24+(i<<4), c+0 );
	}

	Camellia_FLlayer( c, e+64, e+72 );

	for( i=0; i<3; i++ ){
		Camellia_Feistel( c+0, e+80+(i<<4), c+8 );
		Camellia_Feistel( c+8, e+88+(i<<4), c+0 );
	}

	Camellia_FLlayer( c, e+128, e+136 );

	for( i=0; i<3; i++ ){
		Camellia_Feistel( c+0, e+144+(i<<4), c+8 );
		Camellia_Feistel( c+8, e+152+(i<<4), c+0 );
	}

	if( n == 128 ){
		SwapHalf( c );
		XorBlock( c, e+192, c );
	}
	else{
		Camellia_FLlayer( c, e+192, e+200 );

		for( i=0; i<3; i++ ){
			Camellia_Feistel( c+0, e+208+(i<<4), c+8 );
			Camellia_Feistel( c+8, e+216+(i<<4), c+0 );
		}

		SwapHalf( c );
		XorBlock( c, e+256, c );
	}
}

void Camellia_Decrypt( const int n, const Byte *c, const Byte *e, Byte *p )
{
	int i;

	if( n == 128 ){
		XorBlock( c, e+192, p );
	}
	else{
		XorBlock( c, e+256, p );

		for( i=2; i>=0; i-- ){
			Camellia_Feistel( p+0, e+216+(i<<4), p+8 );
			Camellia_Feistel( p+8, e+208+(i<<4), p+0 );
		}

		Camellia_FLlayer( p, e+200, e+192 );
	}

	for( i=2; i>=0; i-- ){
		Camellia_Feistel( p+0, e+152+(i<<4), p+8 );
		Camellia_Feistel( p+8, e+144+(i<<4), p+0 );
	}

	Camellia_FLlayer( p, e+136, e+128 );

	for( i=2; i>=0; i-- ){
		Camellia_Feistel( p+0, e+88+(i<<4), p+8 );
		Camellia_Feistel( p+8, e+80+(i<<4), p+0 );
	}

	Camellia_FLlayer( p, e+72, e+64 );

	for( i=2; i>=0; i-- ){
		Camellia_Feistel( p+0, e+24+(i<<4), p+8 );
		Camellia_Feistel( p+8, e+16+(i<<4), p+0 );
	}

	SwapHalf( p );
	XorBlock( p, e+0, p );
}

void Camellia_Feistel( const Byte *x, const Byte *k, Byte *y )
{
	Byte t[8];

	t[0] = SBOX1(x[0]^k[0]);
	t[1] = SBOX2(x[1]^k[1]);
	t[2] = SBOX3(x[2]^k[2]);
	t[3] = SBOX4(x[3]^k[3]);
	t[4] = SBOX2(x[4]^k[4]);
	t[5] = SBOX3(x[5]^k[5]);
	t[6] = SBOX4(x[6]^k[6]);
	t[7] = SBOX1(x[7]^k[7]);

	y[0] ^= t[0]^t[2]^t[3]^t[5]^t[6]^t[7];
	y[1] ^= t[0]^t[1]^t[3]^t[4]^t[6]^t[7];
	y[2] ^= t[0]^t[1]^t[2]^t[4]^t[5]^t[7];
	y[3] ^= t[1]^t[2]^t[3]^t[4]^t[5]^t[6];
	y[4] ^= t[0]^t[1]^t[5]^t[6]^t[7];
	y[5] ^= t[1]^t[2]^t[4]^t[6]^t[7];
	y[6] ^= t[2]^t[3]^t[4]^t[5]^t[7];
	y[7] ^= t[0]^t[3]^t[4]^t[5]^t[6];
}

void Camellia_FLlayer( Byte *x, const Byte *kl, const Byte *kr )
{
	uint32 t[4],u[4],v[4];

	ByteWord( x, t );
	ByteWord( kl, u );
	ByteWord( kr, v );

	t[1] ^= (t[0]&u[0])<<1^(t[0]&u[0])>>31;
	t[0] ^= t[1]|u[1];
	t[2] ^= t[3]|v[1];
	t[3] ^= (t[2]&v[0])<<1^(t[2]&v[0])>>31;

	WordByte( t, x );
}

void ByteWord( const Byte *x, uint32 *y )
{
	int i;
	for( i=0; i<4; i++ ){
		y[i] = ((uint32)x[(i<<2)+0]<<24) + ((uint32)x[(i<<2)+1]<<16)
		     + ((uint32)x[(i<<2)+2]<<8 ) + ((uint32)x[(i<<2)+3]<<0 );
	}
}

void WordByte( const uint32 *x, Byte *y )
{
	int i;
	for( i=0; i<4; i++ ){
		y[(i<<2)+0] = (Byte)(x[i]>>24&0xff);
		y[(i<<2)+1] = (Byte)(x[i]>>16&0xff);
		y[(i<<2)+2] = (Byte)(x[i]>> 8&0xff);
		y[(i<<2)+3] = (Byte)(x[i]>> 0&0xff);
	}
}

void RotBlock( const uint32 *x, const int n, uint32 *y )
{
	int r;
	if( r = (n & 31) ){
		y[0] = x[((n>>5)+0)&3]<<r^x[((n>>5)+1)&3]>>(32-r);
		y[1] = x[((n>>5)+1)&3]<<r^x[((n>>5)+2)&3]>>(32-r);
	}
	else{
		y[0] = x[((n>>5)+0)&3];
		y[1] = x[((n>>5)+1)&3];
	}
}

void SwapHalf( Byte *x )
{
	Byte t;
	int  i;
	for( i=0; i<8; i++ ){
		t = x[i];
		x[i] = x[8+i];
		x[8+i] = t;
	}
}

void XorBlock( const Byte *x, const Byte *y, Byte *z )
{
	int i;
	for( i=0; i<16; i++ ) z[i] = x[i] ^ y[i];
}
