/*!
@file dkcCRC.h
@author d
@since 2004/08/24
@brief CRC[` boost::crcCڐA
@bug ܂oO`FbNĂȂB܂AB
@note

Licence : http://www.boost.org/LICENSE_1_0.txt

T|[gĂCRC
- CRC32 left right

- CRC-CCITT left right (ITU-T V.41  ... X^16 + X^12 + X^5 + 1 ) (HDLC ??)
- XMODEM left right
- CRC ANSI16 left right

- CRC12 x12+x11+x3+x2+x1+P
- CRC7 

boost::crcCłڎwĂƍlĂƕ₷ƥB<br>
ɂĂboost::crc̎͂ȂEB<br>
ULONGƂĂ鏊ẼeNƎvB<br>
iMinGWłtemplate<class T,class C=std::vector<T> >݂ȎoȂB)<br>


<h3>Ql</h3>
- http://www.kmonos.net/alang/boost/classes/crc.html
- http://hp.vector.co.jp/authors/VA011148/srclib.html


*/

#ifndef DKUTIL_C_CRC_H
#define DKUTIL_C_CRC_H

#include "dkcOSIndependent.h"




typedef struct dkc_CRC{
	//[h֐ւ̃|C^
	//void (*mLoader)(struct dkc_CRC *,const BYTE *,size_t);
	///e[uւ̃|C^
	void *mTable;
	///ԑJڕϐ
	unsigned long mR;
	///ςCRCۑϐ
	unsigned long mResult;
	///CRC̃rbg
	size_t mBits;
	///
	ULONG mTruncPoly;
  ///l
	ULONG mInitRem;
	///ŌXORl
	ULONG mFinalXor;
  
	dkctBOOL mReflectIn;

	dkctBOOL mReflectRem;
}DKC_CRC;

DKC_EXTERN DKC_CRC* WINAPI dkcAllocCRC( size_t Bits, ULONG TruncPoly,
           ULONG InitRem, ULONG FinalXor,
           dkctBOOL ReflectIn, dkctBOOL ReflectRem);

DKC_EXTERN DKC_CRC* WINAPI dkcAllocCRC_32left();

DKC_EXTERN DKC_CRC* WINAPI dkcAllocCRC_32right();

DKC_EXTERN DKC_CRC* WINAPI dkcAllocCRC_ansi16left();

DKC_EXTERN DKC_CRC* WINAPI dkcAllocCRC_ansi16right();

DKC_EXTERN DKC_CRC* WINAPI dkcAllocCRC_ccitt_left();

DKC_EXTERN DKC_CRC* WINAPI dkcAllocCRC_ccitt_right();

DKC_EXTERN DKC_CRC* WINAPI dkcAllocCRC_xmodem();

DKC_EXTERN int WINAPI dkcFreeCRC(DKC_CRC **pp);

/*!
@param p[in][out] CRC\̂ւ̃|C^
@param buffer[in] w肵obt@ ULONGUSHORT256̔zł鎖
@param Bits[in] rbgCRCl𐶐邩Bʂ16Ƃ32ʓI
@param TruncPoly[in] 
@param InitRem[in] l
@param FinalXor[in] CRCvZ̍ŌXORl
@param ReflectIn[in] ΂ɂ邩ǂB
@param ReflectRem[in] ΂ɂ邩ǂB(X}ANJjboost::crcڐAB
*/
DKC_EXTERN int WINAPI dkcCRCInit(DKC_CRC *p,void *buffer,
					size_t Bits, ULONG TruncPoly,
          ULONG InitRem, ULONG FinalXor,
          dkctBOOL ReflectIn, dkctBOOL ReflectRem );

/*!
@param Bits[in] w肷CRCl(dkcCRCInit()BitsƓlɂ)
@return 0ƃG[ ȊO gpł낤e[ubytePʂ̃TCYԂB
*/

///dkcCRCInit()bufferɓnobt@TCY߂B
DKC_EXTERN size_t WINAPI dkcCRCGetUseTableSize(size_t Bits);

/*!
@param p[in][out] DKC_CRC\̂ւ̃|C^
@param pBuffer[in] ǂݎobt@ւ̃|C^
@param dwSize[in] obt@ɃANZXOKȃTCY
*/
DKC_EXTERN void WINAPI dkcCRCLoad(DKC_CRC *p,const BYTE *pBuffer,size_t size);

DKC_EXTERN void WINAPI dkcCRCLoadBlock(DKC_CRC *p,const void *Begin,const void *End);


/*!
@param p[in][out] dkcAllocSHA1()Ŏ擾|C^
@note

*/
DKC_EXTERN ULONG WINAPI dkcCRCFinal(DKC_CRC *p);

DKC_EXTERN ULONG WINAPI dkcCRCResult(const DKC_CRC *p);
#if !defined(   DKUTIL_C_CRC_C ) &&  defined(USE_DKC_INDEPENDENT_INCLUDE)
#	include "dkcCRC.c"
#endif


#endif //end of include once