/*!
@file dkcBuffer.h
@author d
@since 2004/3/xx
@brief ȈՃobt@[[`
@note
{IɁAvOő삷^Cṽobt@[B
G[NȂ悤ɒӂ悤B
*/

#ifndef DKUTIL_C_BUFFER_H
#define DKUTIL_C_BUFFER_H

#include "dkcOSIndependent.h"
#include "dkcStdio.h"

/*!
obt@[\
*/
typedef struct dkc_Buffer{
	///obt@ւ̃|C^
	BYTE *mBuff;
	///obt@̃TCY
	size_t mSize;
}DKC_BUFFER;




/*!
@param data[in] obt@փRs[f[^ւ̃|C^
@param size[in] obt@̃TCYidatãTCYj
*/
///obt@̈𓾂B
DKC_EXTERN DKC_BUFFER* WINAPI dkcAllocBuffer(const void *data,size_t size);
/*!
DKC_BUFFERf[g
@note
KgpƂ͂ĂłB
*/
///dkcAllocBuffer()ŊmۂXg̈Ɠobt@폜BdkcAllocBufferƑ΁B
DKC_EXTERN int WINAPI dkcFreeBuffer(DKC_BUFFER **ptr);

/**
dkcAllocBuffer()gȂŏB
@warning Ă̊֐̎gpɂ̓̏ԑJڂ蓪ɓĂdv
@note
ȂAInitUninitdkcRedBlackTree.hƖڂɂĂB
*/
DKC_INLINE void dkcBufferInit(DKC_BUFFER *p,size_t size){
	p->mBuff=(BYTE *)dkcAllocate(size);
	p->mSize = size;
}
///dkcBufferInit()ŏ̂̏I
DKC_INLINE void dkcBufferUninit(DKC_BUFFER *p){
	if(p->mBuff){
		dkcFree((void **)&p->mBuff);
	}
	p->mSize = 0;
}
DKC_INLINE int dkcBufferCopy(DKC_BUFFER *p,const DKC_BUFFER *src){
	void *tp = p->mBuff;
	if(tp){//cĂ폜ȂB
		dkcFree(&tp);
	}
	p->mBuff = (BYTE *)dkcAllocate(src->mSize);
	if(NULL==p->mBuff){
		return edk_OutOfMemory;
	}
	p->mSize = src->mSize;
	return edk_SUCCEEDED;
}
DKC_INLINE void dkcBufferCopyShared(DKC_BUFFER *p,DKC_BUFFER *src){
	p->mBuff = src->mBuff;
	p->mSize = src->mSize;
}
/*!
obt@̐擪dataԂ
*/
DKC_EXTERN int WINAPI dkcBufferSet(DKC_BUFFER *ptr,const void *data,size_t size);
///obt@̐擪offset̏dataԂ
DKC_EXTERN int WINAPI dkcBufferSetOffset(DKC_BUFFER *ptr,
																				 const void *data,size_t size,size_t offset);


/*!
obt@̐擪sizef[^
*/
DKC_EXTERN int WINAPI dkcBufferGet(DKC_BUFFER *ptr,void *data,size_t size);

DKC_EXTERN int WINAPI dkcBufferGetOffset(DKC_BUFFER *ptr,
																				 void *data,size_t size,size_t offset);
/*!
obt@̃TCYςB
*/
DKC_EXTERN int WINAPI dkcBufferResize(DKC_BUFFER *ptr,size_t size);
///C++Ōcopy constructor
DKC_EXTERN DKC_BUFFER* WINAPI dkcAllocBufferCopy(const DKC_BUFFER *);

///obt@̃TCY
DKC_EXTERN size_t WINAPI dkcBufferSize(DKC_BUFFER *p);

DKC_EXTERN BYTE *WINAPI dkcBufferPointer(DKC_BUFFER *p);


//**********************************************************
//inline 
DKC_INLINE int WINAPI dkcBufferSet_INL(DKC_BUFFER *ptr,const void *data,size_t size)
{
	//if(NULL==ptr) return edk_ArgumentException;//

	return dkc_memcpy(ptr->mBuff,ptr->mSize,data,size);
}


DKC_INLINE int WINAPI dkcBufferSetOffset_INL(DKC_BUFFER *ptr,
															const void *data,size_t size,size_t offset){
	if(ptr->mSize < offset + size){
		return edk_BufferOverFlow;
	}
	return dkc_memcpy(
		ptr->mBuff + offset,
		ptr->mSize - offset
		,data,size);
}




DKC_INLINE int WINAPI dkcBufferGet_INL(DKC_BUFFER *ptr,void *data,size_t size){
	//if(NULL==ptr) return edk_ArgumentException;//fast
	return dkc_memcpy(data,size,ptr->mBuff,ptr->mSize);
}

DKC_INLINE int WINAPI dkcBufferGetOffset_INL(DKC_BUFFER *ptr,
															void *data,size_t size,size_t offset){
	if(ptr->mSize < offset + size){
		return edk_BufferOverFlow;
	}
	return dkc_memcpy(
		data,size,
		ptr->mBuff + offset,
		size
	);

}

DKC_INLINE int WINAPI dkcBufferResize_INL(DKC_BUFFER *ptr,size_t size)
{
	void *NewPtr;
	if(NULL==ptr || 0==size || NULL==ptr->mBuff) return edk_ArgumentException;
	if(DKUTIL_FAILED(dkcReallocate(&NewPtr,size,(void **)&(ptr->mBuff)))){
		return edk_FAILED;
	}

	ptr->mBuff = (BYTE *)NewPtr;
	ptr->mSize = size;

	return edk_SUCCEEDED;
}



DKC_INLINE DKC_BUFFER* WINAPI dkcAllocBufferCopy_INL(const DKC_BUFFER *ptr){
	dkcmNOT_ASSERT(NULL==ptr || NULL==ptr->mBuff);

	return dkcAllocBuffer(ptr->mBuff,ptr->mSize);
}

DKC_INLINE size_t WINAPI dkcBufferSize_INL(DKC_BUFFER *p){
	return p->mSize;
}
DKC_INLINE BYTE *WINAPI dkcBufferPointer_INL(DKC_BUFFER *p){
	return p->mBuff;
}

#if !defined( DKUTIL_C_BUFFER_C ) &&  defined(USE_DKC_INDEPENDENT_INCLUDE)
#	include "dkcBuffer.c"
#endif


#endif //end of include once