/*!
@file dkcTelecomConfirmFile.h
@brief ʐM̂ƂɎgt@CtH[}bg
@since 2005/11/17
@note
version 01
 header
 block
*/
#ifndef  DKUTIL_C_TELECOM_CONFIRM_FILE_H
#define  DKUTIL_C_TELECOM_CONFIRM_FILE_H

#include "dkcHash.h"
#include "dkcLZW.h"
#include "dkcStream.h"

#if 0


#define dkcdTELECOM_CONFIRM_FILE_MAX_LENGTH 0x7FFFFFFF

/**
@note
1b64KB҂ƂSHA512̌vZ30bɂƂ1966080byte낵ȁH
*/
#define dkcdTELECOM_CONFIRM_FILE_DEFAULT_PAUSE_SIZE 1966080

typedef struct dkc_TelecomConfirmFileHeader01{
	uint32 version;
	///wb_̂̃VOl`
	uint8 header_sig[SHA512_BIN_BUFFER_SIZE];
	///VOl` kAÍÕv[ȏԂ̂́j
	uint8 origin_sig[SHA512_BIN_BUFFER_SIZE];
	///̃wb_̌̃TCY
	uint64 length;
	///block̐
	uint32 block_num;
	///lzẅ
	uint32 lzw_output_block_size;
}DKC_TELECOM_CONFIRM_FILE_HEADER01;

typedef struct dkc_TelecomConfirmFileBlock01{
	DKC_LZW_HEADER lzw_header;
	///LZWňkς݂̃f[^MD5l MD5Ȃ̂͂̕Ǝvꂽ߁B
	uint8 compress_md5[MD5_BIN_BUFFER_SIZE];
	///LZWŉ𓀂ꂽf[^MD5l
	uint8 origin_md5[MD5_BIN_BUFFER_SIZE];
}DKC_TELECOM_CONFIRM_FILE_BLOCK01;

#define dkcdTELECOM_CONFIRM_FILE_BEGIN_BUFFER_SIZE (1024 * 64)

///
typedef struct dkc_TelecomConfirmFile{
	//setting
	uint32 version;

	//save
	uint32 block_num;
	uint32 lzw_output_block_size;
	//state
	DKC_LZW *mLZW;
	DKC_MD5 *mMD5;
	DKC_SHA512 *mSHA512;

	///OutputBlock鎞ɎgLZWdestp
	DKC_BUFFER *mBuff;


}DKC_TELECOM_CONFIRM_FILE;


enum edkcTelecomConfirmFile{
	///all sha512 / block md5 lzw
	edkcTelecomConfirmFileVersion01 = 1,
	edkcTelecomConfirmFileVersionNewest =  edkcTelecomConfirmFileVersion01,
};
#define dkcmTelecomConfirmFileVersionError(a) (a < edkcTelecomConfirmFileVersion01 && edkcTelecomConfirmFileVersionNewest < a)

/**
@param version[in] versionlBenum edkcTelecomConfirmFileVersionĂl̂ǂꂩBȂׂVl悤B
*/
DKC_EXTERN DKC_TELECOM_CONFIRM_FILE* WINAPI dkcAllocTelecomConfirmFileGenerate(uint32 version,size_t lzw_output_block_size);

DKC_EXTERN DKC_TELECOM_CONFIRM_FILE *WINAPI dkcAllocTelecomConfirmFileExtract(DKC_STREAM *input);

DKC_EXTERN int WINAPI dkcFreeTelecomConfirmFile(DKC_TELECOM_CONFIRM_FILE **);

DKC_EXTERN int WINAPI dkcTelecomConfirmFileInit(DKC_TELECOM_CONFIRM_FILE *p);


///@warning outputstreamdkcStreamSeek(output,0,edkcStreamSeekSet);ƂĂ
DKC_EXTERN int WINAPI dkcTelecomConfirmFileGenerateBegin(DKC_TELECOM_CONFIRM_FILE *p,DKC_STREAM *output);

DKC_EXTERN int WINAPI dkcTelecomConfirmFileGenerateOutputBlock(DKC_TELECOM_CONFIRM_FILE *p,DKC_STREAM *output,const uint8 *buff,size_t size);

DKC_EXTERN int WINAPI dkcTelecomConfirmFileGenerateFinal(DKC_TELECOM_CONFIRM_FILE *p,DKC_STREAM *output);

/*
DKC_EXTERN int WINAPI dkcTelecomConfirmFileGetHeader(DKC_STREAM *input,DKC_TELECOM_CONFIRM_FILE_HEADER01 *header);

DKC_EXTERN int WINAPI dkcTelecomConfirmFileGetBlock(DKC_STREAM *input,DKC_TELECOM_CONFIRM_FILE_BLOCK01 *block);
*/

DKC_EXTERN int WINAPI dkcTelecomConfirmFileExtractOutputBlock(
	DKC_TELECOM_CONFIRM_FILE *p,DKC_STREAM *input,const DKC_TELECOM_CONFIRM_FILE_BLOCK *block,
	uint8 *buff,size_t buffsize
);


DKC_EXTERN int WINAPI dkcTelecomConfirmFileEncode(const char *dest_filename,const char *src_filename);


DKC_EXTERN int WINAPI dkcTelecomConfirmFileDecode(const char *dest_filename,const char *src_filename);

																				 
DKC_EXTERN size_t WINAPI dkcTelecomConfirmFileGetDecodeSize(const char *filename);
																				 
/*
DKC_EXTERN int WINAPI dkcTelecomConfirmFileEncode(uint8 *dest,size_t destsize,const uint8 *src,size_t srcsize);

DKC_EXTERN int WINAPI dkcTelecomConfirmFileDecode(uint8 *dest,size_t destsize,const uint8 *src,size_t srcsize);
*/


#if !defined( DKUTIL_C_TELECOM_CONFIRM_FILE_C ) &&  defined(USE_DKC_INDEPENDENT_INCLUDE)
#	include "dkcTelecomConfirmFile.c"
#endif

#endif //eo0

#endif //end of include once