/*!
@file dkc2Tree.h
@since 2004/3/xx , 2004/12/13
@brief P2
@note Basic Binary Tree...
P2؂łB
AVLƂł͂ȂP2؂dkcSingleList.h
VOXgƓʂ炷Ƃ܂B
iڂ̓ASY̎QlƂĂOOG

uCB(@LT`)@vAAVL؂̂ɂƃC[W΂ȂߗK̂ߍ鎖ɂB

#define DKUTIL_C_2TREE_FAST_IMPL
錾ƁAm[h{SoCggp܂Am[hwł̍폜O(1)ɂ܂B
*/

#ifndef DKUTIL_C_2TREE_H
#define DKUTIL_C_2TREE_H

#include "dkcOSIndependent.h"
#include "dkcMemoryPool.h"




typedef struct dkc_2TreeNode{
	///L[ւ̃|C^
	void *key;
	///f[^ւ̃|C^
	void *data;
	///f[^̃TCY
	size_t data_size;
	///m[h@݂ȂꍇNULL
	struct dkc_2TreeNode *left;
	///Em[h@݂ȂꍇNULL
	struct dkc_2TreeNode *right;
}DKC_2TREE_NODE;


///킢Root݂Ȃ́B
typedef struct dkc_2TreeRoot{
	///̐
	size_t now_num;
	///ő吔
	size_t max_num;
	///v[̍ől
	size_t pool_max;

	///L[̃TCY
	size_t key_size;
	///r֐ւ̃|C^
	DKC_COMPARE_TYPE compare;
	///AP[^ keyp
	DKC_SAME_OBJECT_POOL *key_ac;
	///AP[^ DKC_2TREE_NODE p
	DKC_SAME_OBJECT_POOL *obj_ac;

	///̏ root
	DKC_2TREE_NODE *root;
	///Ԑl
	DKC_2TREE_NODE *sentinel;
}DKC_2TREE_ROOT;


/**
@param key_size[in] L[̃TCYݒ肷B
@param pool_num[in] v[̗e
@param compare[in] r֐ւ̃|C^ qsort()ƓKi
@param max_num[in] 񕪖؂̍őeʂݒ肷B0xFFFFFFFFOK
@return DKC_2TREE_ROOT̈ԂBNULLƎsB
*/
///Qؗ̈𓾂B
DKC_EXTERN DKC_2TREE_ROOT * WINAPI 
	dkcAlloc2TreeRoot(size_t key_size,size_t pool_num,DKC_COMPARE_TYPE compare,size_t max_num);
/*!
DKC_2TREEf[g
(NĂ郊Xg폜܂B
̗vf폜ꍇdkcErase2TreegĂBj
@note
KgpƂ͂ĂłB
*/
///dkcAllocNew2Tree()ŊmۂXg̈Ɠobt@폜BdkcAllocNew2TreeƑ΁B
DKC_EXTERN int WINAPI dkcFree2TreeRoot(DKC_2TREE_ROOT **ptr);


/*!
*/
///Vf[^}B
DKC_EXTERN int WINAPI dkc2TreeInsert(DKC_2TREE_ROOT *ptr,
																		 const void *Key,const void *data,size_t data_size);

/*!
Q؂`FCB
destsrcqB
dest̂Q؂src̓񕪖؂\[gdestɏo͂B
A
- dest̕srcƏdKeyꍇ͎sB
- destsrc̏ԂĂ玸sB
@return enum edkResult̂ǂꂩԂB
*/
DKC_EXTERN int WINAPI dkc2TreeChain(DKC_2TREE_ROOT *dest,DKC_2TREE_ROOT *src);



//DKC_EXTERN int WINAPI dkc2TreeErase(DKC_2TREE_ROOT *ptr,DKC_2TREE_NODE **parent,DKC_2TREE_NODE *node);
DKC_EXTERN int WINAPI dkc2TreeErase(DKC_2TREE_ROOT *ptr,DKC_2TREE_NODE *node);

/**
dkc2TreeExist()ŕԂ錋ʂ̍\
*/
typedef struct dkc_2TreeExist{
	BOOL isExist;
	///node̐em[h
	DKC_2TREE_NODE *parent;
	///parent̎qm[h
	DKC_2TREE_NODE *node;
	///nodewĂ|C^ւ̃|C^
	DKC_2TREE_NODE **leaf_ptr;
}DKC_2TREE_EXIST;

///nodeɓꂽ|C^ptrɑ݂邩ǂׂ鑶݂猋ʒlԂB
DKC_EXTERN DKC_2TREE_EXIST WINAPI dkc2TreeExist(DKC_2TREE_ROOT *ptr,const DKC_2TREE_NODE *node);

/**
@param ptr[in] 폜Nodeւ̃L[
*/
DKC_EXTERN int WINAPI dkc2TreeEraseFromKey(DKC_2TREE_ROOT *ptr,const void *Key);
/*!
@param Key[in] key ID
@return DKC_2TREEւ̃|C^ԂBȂꍇNULL
*/
DKC_EXTERN DKC_2TREE_NODE * WINAPI dkc2TreeFindEqual(DKC_2TREE_ROOT *ptr,const void*Key);


DKC_EXTERN DKC_2TREE_NODE * WINAPI dkc2TreeFindMinimalGreater(DKC_2TREE_ROOT *ptr,const void* Key);

DKC_EXTERN DKC_2TREE_NODE * WINAPI dkc2TreeFindMaximumLess(DKC_2TREE_ROOT *ptr,const void* Key);
/**
*/
///Q؍\̓ɕۑĂf[^炤
DKC_EXTERN int WINAPI dkc2TreeGetBuffer(DKC_2TREE_NODE *ptr,void *data,size_t size);
/**
Q؍\̂ɕۑĂf[^̈Ƀf[^B
Q؍\̓̃obt@Ȃꍇ͂̊֐̓ŊgĂB
@return size==0edk_NoValueToProcessԂBI edk_SUCCEEDED
*/
DKC_EXTERN int WINAPI dkc2TreeSetBuffer(DKC_2TREE_NODE *ptr,const void *data,size_t size);
///dkc2TreeSetBuffer()G[`FbN}N TRUE G[
#define dkcm2TREE_SET_BUFFER_ERROR(tr) (tr != edk_NoValueToProcess && DKUTIL_FAILED(tr))



#endif //end of include once
