/**
@author d
@file macro.h
@brief C̒`(ƎgA)
@since 2003/9/13 reconstruct:2005/01/17
*/


#ifndef DKUTIL_CSTD_MACRO_H
#define DKUTIL_CSTD_MACRO_H


///h ApXbv
#define SWAP_NUM(a,b) \
    (a) = (b) - (a) ;\
    (b) -= (a) ;\
    (a) += (b) 
/*!
@see SWAP_NUM
@param ex[in] ^@unsigned char 
*/
#define SWAP_NUM_EX(a,b,ex) \
	(ex)(a) = (ex)((b) - (a) ); \
	(ex)(b) = (ex)((b) - (a) ); \
	(ex)(a) = (ex)((a) + (b) )
/*!
@note

@code
//example
UINT get_offset = SM_OFFSET(_WIN32_FIND_DATA *,dwReserved1);
@endcode
*/
///\̂̃ItZbg߂ Struct Member Offset
#define SM_OFFSET(p_type,field)     ((unsigned int)&(((p_type)NULL)->field))

///RECT\̂ɓB
#define SET_RECT(rect, l, t, r, b) \
{\
    rect##.left   = l;\
    rect##.top    = t;\
    rect##.right  = r;\
    rect##.bottom = b;\
}


///z̐𐔂
#define DKUTIL_ARRAY_NUMOF(array) (sizeof(array)/sizeof(array[0]))
///O킹B
#define DKUTIL_NAMELINK(X,Y) X##Y
///VOl`̖OB
#define DKUTIL_MAKESIGNATURE(X) DKUTIL_NAMELINK(X,__LINE__)
///@param id[in] example 'abcd'  @return unsigned int
#define DKUTIL_MAKE_UINT_ID(id) ((((UINT)(id) & 0xFF) << 24) |     \
                  (((UINT)(id) & 0xFF00) << 8) |    \
                  (((UINT)(id) & 0xFF0000) >> 8) |  \
                  (((UINT)(id) & 0xFF000000) >> 24))

///http://d.hatena.ne.jp/paserry/ paserryɋĂBm(_ _)m 
#define DKUTIL_FLAG_DOWN(x,n) {x &= ~n;}//{(x & n) ? x |= (x^n) : 0;}//{x |= (x^n);}
///tOAbv}NB͏펯B
#define DKUTIL_FLAG_UP(x,n) {x |= n;}

///UINTnϐ̍Nrbgڂ̃tOAbvBӁF0͂܂ƎvB

#define DKUTIL_FLAG_UP_N(x,n) DKUTIL_FLAG_UP(x,(1 << n))
///@see DKUTIL_FLAG_UP_N() nrbgڂ̃tO_EB

#define DKUTIL_FLAG_DOWN_N(x,n) DKUTIL_FLAG_DOWN(x,( 1<<n ))
//#define DKUTIL_FLAG_DOWN_N(x,n) {x &= (x^ ( 1<<n ) );}
//#define DKUTIL_FLAG_UP_N(x,n) {x |= (1 << n);}


#ifdef __cplusplus

/*!
* ̕ɑR悤ɂva_list̏B<br>
* buff = char̃obt@ <br>
* buffnum = buff̃TCY(oCgP)<br>
* origin = ŏ̕ <br>
* FႦ΁AʂɏƂȊB<br>
* <PRE>
* void ERROR_BOX(char *str,...){
* 	char s[512];
* 	va_list VaList ;
* 	va_start( VaList , str ) ;
* 	vsprintf( s , str , VaList ) ;
* 	va_end( VaList ) ;
* 	MessageBox(NULL,s,"ERROR_BOX",MB_OK);
* }
* ̃}N͂̂悤ɎgB
* void ERROR_BOX(char *str,...){<
* 	char s[512];
* 	SET_VA_LIST(s,512,str);
* 	MessageBox(NULL,s,"ERROR_BOX",MB_OK);
* }
* </PRE>
* ǂIIIłȂʓ|ȕII<br>
*	@param buff [out] obt@
*	@param buffnum [in] obt@̃TCY(oCgP
*	@param origin [in] ̕
@note
(2004/1/2 ƒȂ񂩂PBYTEʂɂĂ悤
*/
///R֐̃T|[gOOG
#define SET_VA_LIST(buff,buffnum,origin) \
{\
	va_list VaList;\
	va_start( VaList , origin ) ;\
	int r;\
	r = _vsnprintf( buff ,buffnum - 1, origin , VaList );\
	if(0 > r){\
		buff[buffnum - 1] = '\0';\
	}else{\
		buff[r+1] = '\0';\
	}\
	va_end( VaList ); \
}


#	define DKUTIL_SAFE_REALLOC(b,s) ::realloc(b,s)
#	define DKUTIL_SAFE_MALLOC(s) ::malloc(s)
#	define DKUTIL_SAFE_FREE(a) if(a){::free(a);a=NULL;}
	
///\̂B(\̂ւ̃|C^ł͂ȂBj
#	define DKUTIL_STRUCTURE_INIT(s) ::memset(&(s),0,sizeof(s))
///ZeroMemory()݂Ȃ
#	define DKUTIL_MEMZERO(mem,size) ::memset(mem,0,size)

#else // for c lang



#define DKUTIL_SAFE_REALLOC(b,s) realloc(b,s)
#define DKUTIL_SAFE_MALLOC(s) malloc(s)
#define DKUTIL_SAFE_FREE(a) if(a){free(a);a=NULL;}
#define DKUTIL_STRUCTURE_INIT(s) memset(&(s),0,sizeof(s))
///ZeroMemory()݂Ȃ
#	define DKUTIL_MEMZERO(mem__,size__) memset(mem__,0,size__)
#endif

///z
#define DKUTIL_ARRAY_ZERO(arr) DKUTIL_MEMZERO(arr,sizeof(arr))
///CHAR̔zB
#define NULL_CHAR_ARRAY(s) DKUTIL_ARRAY_ZERO(s)

#define SET_VA_LIST_C(VaList,r,buff,buffnum,origin) \
{\
	va_start( VaList , origin ) ;\
	r = _vsnprintf( buff ,buffnum - 1, origin , VaList );\
	if(0 > r){\
		buff[buffnum - 1] = '\0';\
	}else{\
		buff[r+1] = '\0';\
	}\
	va_end( VaList ); \
}

#define DKUTIL_BIT_TO_BYTE(a) (a / 8)

/// this version of the macro is fastest on Pentium 3 and Pentium 4 with MSVC 6 SP5 w/ Processor Pack @note by cryptopp
#define dkcmGETBYTE(x, y)		((x)>>(8*(y)))
#define dkcmGETBYTE8(x,y)				(uint8)dkcmGETBYTE(x,y)
#define dkcmGETBYTE16(x,y)				(uint16)dkcmGETBYTE(x,y)
#define dkcmGETBYTE32(x,y)	(uint32)dkcmGETBYTE8(x,y)

// @note by cryptopp
#if defined(__GNUC__) || defined(__MWERKS__)
# define dkcmUINT64DEFINE(x) x##LL
#elif defined(_MSC_VER) || defined(__BCPLUSPLUS__)
#	define dkcmUINT64DEFINE(x) x##ui64
#else
#	define dkcmUINT64DEFINE(x) (x)
#endif

#endif //end of include once

