/*!
@file dkcRegex.h
@brief		K\CuH
@author		d
@since		2004/09/01
@note
C++ŐK\boost::regexĝCCH
܂yaneSDK3rdDLLB

@section \[X
dkcRegex.cdkcRegex.hGreenPad̎CɈڐAĂ܂B
*/
#ifndef dkutil_c_Regex__h
#define dkutil_c_Regex__h



#include "dkcStream.h"
#include "dkcOSIndependent.h"

typedef struct dkc_Replace{
	DKC_STREAM *mStream;
}DKC_REPLACE;

typedef wchar_t DKC_UNICODE;

DKC_EXTERN DKC_REPLACE *WINAPI dkcAllocReplace();

DKC_EXTERN int WINAPI dkcFreeReplace(DKC_REPLACE **);

DKC_EXTERN int WINAPI dkcReplaceRun(	 const BYTE *src,size_t srcsize,
																		 const BYTE *target_data,size_t target_data_size,
																		 const BYTE *replace_data,size_t replace_data_size
															);



///̎
enum edkcRegToken
{
	/// ʂ̕
	R_Char,
	/// '.'
	R_Any, 
  /// '['
	R_Lcl,
	/// ']'
	R_Rcl,
	/// '^'
	R_Ncl,
	/// '-'
	R_Range,
	/// '('
	R_Lbr,
	/// ')'
	R_Rbr,
	/// '|'
	R_Bar,
	/// '*'
	R_Star,
	/// '+'
	R_Plus,
	/// '?'
	R_Quest,
	/// '\0'
	R_End,
};


///\؂̃m[hɐUl̎
enum edkcRegType
{
	N_Char,     // ʂ̕ (ch)
	N_Class,    // [...] Ȃ (cls)
	N_Concat,   // A       (left, right)
	N_Or,       // |          (left, right)
	N_Closure,  // *          (left)
	N_Closure1, // +          (left)
	N_01,       // ?          (left)
	N_Empty     //          (--)
};

///K\IuWFNg
typedef struct dkcRegularExpression{
	void *re_;
	BOOL caseS_;
	BOOL down_;
}DKC_Regular_EXPRESSION,DKC_REX,DKC_REGEX;

/**
@param key[in] L[
@param caseS[in] 啶ʂȂ̂łTRUE
@param down[in] 猟̏ꍇTRUE
*/
DKC_EXTERN DKC_REGEX *WINAPI dkcAllocRegex(const DKC_UNICODE* key, BOOL caseS, BOOL down);

DKC_EXTERN int WINAPI dkcFreeRegex(DKC_REGEX **);

DKC_EXTERN BOOL WINAPI dkcRegexSearch(DKC_REGEX *p,const DKC_UNICODE* str, ULONG len, ULONG stt,ULONG* mbg, ULONG* med);


/**
@{
	s
	@param str Ώە
	@param len Ώە̒
	@param stt JnindexB0Ȃ擪
	@param mbg }b`ʂ̐擪index
	@param med }b`ʂ̏I[index̂P
	@return }b`ǂ

	T[`IuWFNg̏ꍇAstt <= *beg ͈̔
	T[`IuWFNg̏ꍇA*beg <= stt ͈̔͂
@}
*/
DKC_EXTERN BOOL WINAPI dkcRegularExpressionSearch( const DKC_UNICODE* key, BOOL caseS, BOOL down,const DKC_UNICODE* str, ULONG len, ULONG stt,ULONG* mbg, ULONG* med );
/**

@{ @pkg Gp.Search @}
@{
	ȈՐK\}b`O֐B

	patstrŜ}b`ȂtrueA_ȂfalseԂ
@}
*/

DKC_EXTERN BOOL WINAPI dkcRegularExpressionMatch( const DKC_UNICODE* pat, const DKC_UNICODE* str, BOOL caseS );


#endif //end of include once