/**
@file dkcRLE.h
@brief Run Length Encode kASY
@author d
@note

dkcRLERLE̎dl

fR[h

DKC_RLE_HEADERɉ
<ul>
<li>k̏ꍇ
A (1byte) 0,1͂肦Ȃ
f[^ (1byte) 0 - 255܂
<li>񈳏k̏ꍇ
񈳏kʒl BYTE		(1byte) dkcdRLE_NOCOMPRESS_IDƂ
f[^̒ BYTE (1byte) 2N܂
c̓f[^ ( 2N byte ... )
</ul>

wb_ɋLqĂI[L(dkcdRLE_END_IDŏIB
wb_ɋLqĂTCYʂłȂꍇ̓G[(e֐Q)ԂďI

DKC_RLE_PACKBITS_HEADERɉ
k̏ꍇ
unsignedȏꍇ0x80Ń}XNƂ TRUEn- 0x80 RunkĂ
񈳏k̏ꍇ
unsignedȏꍇ0x80Ń}XNƂ FALSEnf[^łB
*/
#ifndef DKUTIL_C_RLE_H
#define DKUTIL_C_RLE_H


#include "dkcOSIndependent.h"
#include "dkcMemoryStream.h"

#define dkcdRLE_EOF_ID 0x01

#define dkcdRLE_NOCOMPRESS_ID 0x00
///RLẼVOl`iύXĂv`i))
#define dkcdRLE_SIGNATURE 'RLE\0'

typedef struct dkc_RLE
{
	///e|obt@
	BYTE mTemp[256];
	///LtO
	//unsigned char mValidFlag[256];
}DKC_RLE;



typedef struct dkc_RLE_Header{
	///VOl`
	unsigned long mSignature;
	///̃TCY
	USHORT mOriginSize;
	///kTCY
	USHORT mCompressedSize;

	///I[ ʒl
	BYTE mEOF;

	///񈳏k ʒl
	BYTE mABS;
}DKC_RLE_HEADER;

typedef struct dkc_RLE_Comp{
	BYTE length;
	BYTE data;
}DKC_RLE_COMP;

typedef struct dkc_RLE_NoComp{
	BYTE sig;
	USHORT length;
}DKC_RLE_NOCOMP;


DKC_EXTERN DKC_RLE *WINAPI dkcAllocRLE();

DKC_EXTERN int WINAPI dkcFreeRLE(DKC_RLE **);




/*!
@param ptr[in][out] dkcAllocRLE()Ŏ擾|C^
@param ph[out] DKC_RLE_HEADERւ̃|C^
@param dest[out] fR[hꂽf[^̏oobt@ւ̃|C^
@param dsize[in] dest̃TCY (src2{pӂĂB)
@param src[in] obt@ւ̃|C^
@param ssize[in] src̃TCY
@param sig[in] dkcRLEEncode()̎Aw肵VOl`ID
@param CloseProcessSize[in] ł؂ɂTCY 
@param aEOF_ID[in] RLEEOFl@dkcdRLE_EOF_IDw肷鎖シ
@param aABS_ID[in] RLE̔񈳏kl dkcdRLE_NOCOMPRESS_IDw肷鎖シ
@return
߂ledk_SUCCEEDEDŐB
ǂ̏łł؂ɂTCY𒴂edk_NoValueToProcessԂB
ȊO̖͂߂lɂĊefB
@note
DKC_RLE_HEADER̃omOriginSizedsizeƂ̊֐͎s܂B
`bgl^F
dkcRLEEncodeĖȂ񂩕ςȂH Run Length Encode Encode ... ?? ܂AdlĎť
*/
DKC_EXTERN int WINAPI dkcRLEEncode(DKC_RLE *ptr,DKC_MEMORYSTREAM *pms,DKC_RLE_HEADER *ph,
																	 BYTE *dest,size_t dsize,const BYTE *src,USHORT ssize,
	size_t CloseProcessSize,ULONG sig,BYTE aEOF_ID,BYTE aABS_ID);
/*!
@param ptr[in][out] dkcAllocRLE()Ŏ擾|C^
@param pms[in][out] dkcAllocMemoryStream()Ŏ擾Memory Stream Objectւ̃|C^
@param ph[out] DKC_RLE_HEADERւ̃|C^
@param src[in] obt@ւ̃|C^
@param ssize[in] src̃TCY
@param sig[in] RLEƏؖVOl`
@return edk_Result̂ǂꂩԂBk鉿l̖ꍇedk_NoValueToProcessԂB
*/
DKC_EXTERN int WINAPI dkcRLEDecode(DKC_RLE *p,DKC_MEMORYSTREAM *pms,
												const DKC_RLE_HEADER *ph,const BYTE *src,USHORT ssize,
												ULONG sig);

typedef struct dkc_RLEPackBits_Header{
	///̃TCY
	size_t mOriginSize;
	///kTCY
	size_t mCompressedSize;
	///RLE邩
	int mCount;
}DKC_RLE_PACKBITS_HEADER;


DKC_EXTERN int WINAPI dkcRLEPackBitsEncode(DKC_RLE_PACKBITS_HEADER *p,
																					 BYTE *dest,size_t dsize,
																						const BYTE *src,size_t ssize,BYTE count);

DKC_EXTERN int WINAPI dkcRLEPackBitsDecode(DKC_RLE_PACKBITS_HEADER *p,
																					 BYTE *dest,size_t dsize,
																const BYTE *src,size_t ssize);

#if !defined(  DKUTIL_C_RLE_C ) &&  defined(USE_DKC_INDEPENDENT_INCLUDE)
#	include "dkcRLE.c"
#endif

#endif //end of include once