/*!
@file dkcOSIndependent.h
@brief Ɨn
@note
ڂdkc.hɏĂ܂B

*/
#ifndef DKUTIL_C_OS_INDEPENDENT_H
#define DKUTIL_C_OS_INDEPENDENT_H





#if defined(_MSC_VER) && (_MSC_VER >= 1020)
#	pragma once
#else


#endif

#ifdef __cplusplus //C++̂

#	include <limits>


#endif


#include "dkcDefined.h"
#include <limits.h>
#include <float.h>
#include <assert.h>

/*
#define DKUTIL_C_USE_DKUTIL_CSTD
#ifdef DKUTIL_C_USE_DKUTIL_CSTD
#define DKUTIL_CSTD_NOT_DEFINE_STDLIB_MACRO
#	include "dkutil_cstd/stdlib.h"
#else
#	include <stdlib.h>
#endif
*/
#define DKUTIL_CSTD_NOT_DEFINE_STDLIB_MACRO
#	include "dkutil_cstd/stdlib.h"
#	include <stdlib.h>

#ifdef __BORLANDC__
#	include <dir.h>
#else
#	include <direct.h>
#endif

#if defined(_WIN32) || defined(__WIN32__)
#	ifndef WIN32
#		define WIN32
#	endif
#endif

//**********************************************************
//^`

#if defined(_MSC_VER) || defined(WIN32) || defined(__BCPLUSPLUS__)
	typedef unsigned __int64 QWORD;

#else
	typedef unsigned long long QWORD;

#endif




///boolean^
typedef unsigned char dkctBOOL;
/*
#ifndef uint32
typedef unsigned long uint32;
#endif

#ifndef uint16
typedef unsigned short uint16;
#endif

#ifndef uint8
typedef unsigned char uint8;
#endif
*/


#ifndef WIN32

#ifndef DWORD
#	define DWORD  		uint32
#endif
#ifndef WORD
#	define WORD  		uint16
#endif
#ifndef BYTE
#	define BYTE  		uint8
#endif





#ifndef ULONGLONG
#	define ULONGLONG unsigned long long int
#endif

#ifndef LONGLONG
#	define LONGLONG long long int
#endif


#ifndef TRUE
#	define TRUE 1
#endif
#ifndef FALSE
#	define FALSE 0
#endif

#ifndef NULL
#	define NULL 0
#endif

#	define dkcdPATH_SEP '/'
#	define dkcdPATH_SEP_STR "/"
#	define dkcdPATH_LIST_SEP ':'
#	define dkcdPATH_LIST_SEP_STR ":"
#	define dkcmIS_PATH_SEP(c) (dkcdPATH_SEP==(c))
/*.,:;*/
#	define dkcmIS_INVALID_FILENAME_CHAR(c) ( ((c) =='\\') || ((c)=='/') || ((c)=='*') || ((c)=='?') \
		|| ((c)== '"') || ((c) == '<') || ((c) == '>') || ((c) == '|') )

#	define dkcmIS_INVALID_FOLDERNAME_CHAR(c) \
	dkcmIS_INVALID_FILENAME_CHAR(c)

#define dkcmIS_INVALID_PATH_CHAR(c) \
	( ( (c)=='\\') || ((c)=='*') || ((c)=='?') || ((c)== '"') || \
	((c) == '<') || ((c) == '>') || ((c) == '|') )

//realloc̊֐̌^
typedef void *(*DKC_REALLOC_F_TYPE)(void *,size_t);

typedef int BOOL;
//typedef unsigned char BYTE;




#ifndef CALLBACK
#	define CALLBACK
#endif
#ifndef WINAPI
#	define WINAPI
#endif

#else //else of WIN32

#ifdef _MSC_VER
#	ifdef _DEBUG
#		ifndef DEBUG
#			define DEBUG
#		endif
#	else
#		ifndef NDEBUG
#			define NDEBUG
#		endif
#	endif

#	pragma warning(disable:4115)//union{ } struct{ }
#	pragma warning(disable:4100)//֐̖{̂ 1 xQƂ܂B
#	pragma warning(disable:4206)//vvZX̃t@CłB #if 0 #endif
#	pragma warning(disable:4710)//ꍇɂĂͲײݏs܂B
#	pragma warning(disable:4505)//QƂĂȂ۰ي֐͍폜܂B
#endif

# include <windows.h>




#	ifndef CALLBACK
#		define CALLBACK __stdcall
#	endif
#	ifndef WINAPI
#		define WINAPI __stdcall
#	endif



#	define dkcdPATH_SEP '\\'
#	define dkcdPATH_SEP_STR "\\"
#	define dkcdPATH_LIST_SEP ';'
#	define dkcdPATH_LIST_SEP_STR ";"
#	define dkcmIS_PATH_SEP(c) (dkcdPATH_SEP==(c) || '/'==(c))

/*!.,;*/
#	define dkcmIS_INVALID_FILENAME_CHAR(c) ( ((c) =='\\') || ((c)=='/') || ((c)=='*') || ((c)=='?') \
		|| ((c)== '"') || ((c) == '<') || ((c) == '>') || ((c) == '|') || (':'== (c)) )

#	define dkcmIS_INVALID_FOLDERNAME_CHAR(c) \
	dkcmIS_INVALID_FILENAME_CHAR(c)

///t@CpXɎgĂ͂Ȃ񂾂TRUE
#	define dkcmIS_INVALID_PATH_CHAR(c) \
	((c)=='*') || ((c)=='?') || ((c)== '"') || \
	((c) == '<') || ((c) == '>') || ((c) == '|')

#ifdef _MT
#	define dkcdMultiThread 
#endif

#ifdef _MSC_VER
#define CRTDBG_MAP_ALLOC
#	include <crtdbg.h>
#	ifdef DEBUG
#		pragma comment(linker,"/NODEFAULTLIB:LIBC")
#		pragma comment(linker,"/NODEFAULTLIB:LIBCMT")
#	ifdef dkcdMultiThread 
#		pragma comment(linker,"/NODEFAULTLIB:LIBCD")
#	else
#		pragma comment(linker,"/NODEFAULTLIB:LIBCMTD")
#	endif
#else
#		pragma comment(linker,"/NODEFAULTLIB:LIBCD")
#		pragma comment(linker,"/NODEFAULTLIB:LIBCMTD")
#	ifdef dkcdMultiThread 
#		pragma comment(linker,"/NODEFAULTLIB:LIBC")
#	else
#		pragma comment(linker,"/NODEFAULTLIB:LIBCMT")
#	endif
#endif
#endif //end of _MSC_VER

#endif //end of  #ifndef WIN32



#ifdef WIN32//WindowsȂ
/// choose a byte order for your hardware
#define ORDER_DCBA	// chosing Intel in this case
#define dkcdLITTLE_ENDIAN 1
#define dkcdBIG_ENDIAN 0
#else //macƂȂ
#define ORDER_ABCD
#define dkcdLITTLE_ENDIAN 0
#define dkcdBIG_ENDIAN 1
//#define ORDER_ABCD //motorola (MacƂ)
#endif

#ifdef ORDER_DCBA  	// DCBA - little endian - intel

	union aword {
	  DWORD dword;
	  BYTE byte [4];
	  struct {
	    unsigned int byte3:8;
	    unsigned int byte2:8;
	    unsigned int byte1:8;
	    unsigned int byte0:8;
	  } w;
	};

union dkc4ByteUnionLittleEndianBase{
	DWORD dword;
	BYTE byte [4];
	struct {
	  unsigned int byte0:8;
	  unsigned int byte1:8;
	  unsigned int byte2:8;
	  unsigned int byte3:8;
	} w;
};
#endif

#ifdef ORDER_ABCD  	// ABCD - big endian - motorola
	union aword {
	  DWORD dword;
	  BYTE byte [4];
	  struct {
	    unsigned int byte0:8;
	    unsigned int byte1:8;
	    unsigned int byte2:8;
	    unsigned int byte3:8;
	  } w;
	};
	union dkc4ByteUnionLittleEndianBase{
		DWORD dword;
		BYTE byte [4];
		struct {
			unsigned int byte3:8;
	    unsigned int byte2:8;
	    unsigned int byte1:8;
	    unsigned int byte0:8;
		} w;
};
#endif

#ifdef ORDER_BADC  	// BADC - vax
	union aword {
	  DWORD dword;
	  BYTE byte [4];
	  struct {
	    unsigned int byte1:8;
	    unsigned int byte0:8;
	    unsigned int byte3:8;
	    unsigned int byte2:8;
	  } w;
};
#endif

typedef union aword DKC_4BYTE_UNION_BIG_ENDIAN_BASE;

typedef union dkc4ByteUnionLittleEndianBase DKC_4BYTE_UNION_LITTLE_ENDIAN_BASE;

typedef union dkc_2int32_to_int64{
	struct{
		LONG LowPart;
		LONG HighPart;
	}u;
	LONGLONG QuadPart;
}DKC_TWOINT32_TO_INT64;
/*
#ifdef WIN32
	typedef DKC_4BYTE_UNION_LITTLE_ENDIAN_BASE DKC_4BYTE_UNION;
*/



#ifdef WIN32
	///realloc̊֐̌^
	typedef void *(WINAPIV *DKC_REALLOC_F_TYPE)(void *,size_t);
	///֐̃|C^^
	//typedef int (WINAPI *PROC)();
	typedef PROC DKC_WINAPI_PROC_F_TYPE ;
#else
	
	typedef void *(*DKC_REALLOC_F_TYPE)(void *,size_t);
	typedef void *DKC_WINAPI_PROC_F_TYPE;
#endif

///ȏʂŎgR[obN֐
typedef BOOL (*DKC_STD_CALLBACK)(void *peculiar,void *user);


//**********************************************************
//limits

#ifndef ULONGLONG_MAX
#	define ULONGLONG_MAX DKINGYO_ULONGLONG_MAX
#endif
#ifndef LONGLONG_MAX
#	define LONGLONG_MAX DKINGYO_LONGLONG_MAX
#endif
#ifndef LONGLONG_MIN
#	define LONGLONG_MIN DKINGYO_LONGLONG_MIN
#endif



#ifndef dkcdMAXPATH 
#	if defined(PATH_MAX)
#		define dkcdMAXPATH   PATH_MAX

#	elif defined(MAX_PATH)
#		define dkcdMAXPATH   MAX_PATH 

#	elif  defined(_MAX_PATH)
#		define dkcdMAXPATH   _MAX_PATH

#	else
#		define dkcdMAXPATH   1024

#	endif
#endif

#ifndef dkcdMAXPATH_LEN
#	define dkcdMAXPATH_LEN dkcdMAXPATH
#endif

/* Ol̂؂BĎbuffer͕ʂ̂Q{擾饥Bi 
	ǋLF
	ɗ\z͓Iăobt@TCY͖Q{ƊȂ鎖B
	*/


#ifndef dkcdMAXPATH_BUFFER 
/**
@ȂWindows NTnƂꍇ炵
ڂ͉LURL̎QƂꂽ
http://beefway.hp.infoseek.co.jp/prog/filename.html
*/
///SMAX_PATH̃obt@̃TCY(oCgPʁj
#	define dkcdMAXPATH_BUFFER (dkcdMAXPATH * 2 + 2)
#endif


#ifndef dkcdMAXPATH_FIXED_SIZE
///dkcdMAXPATH_BUFFER̃TCY͊eOSɂăTCYႤ̂OSɂčEȂŒTCY`Ă̂ǂƎv
#	define dkcdMAXPATH_FIXED_SIZE 2050

#endif

#ifndef MAYBE
#	define MAYBE 2
#endif




typedef struct dkc_4char{
	signed char mode1,mode2,mode3,mode4;
}DKC_4CHAR;




///@return FALSEȂNativeȃt@CpXł͂ȂB
DKC_EXTERN BOOL WINAPI dkcIsNativePathString(const char *s,size_t size);



/*
@param OldSize[in] ̃̈̃TCY
@param ExpandSize[in] Ȃ̈̃TCY
@return AzñTCYHJiH
@note realloc鎞̍œKȃTCYvZB
(͂傭傭ς܂B
*/

DKC_EXTERN  size_t dkcReallocateSizeFunction(size_t OldSize,size_t ExpandSize);

///malloc()n ֐̌^
typedef void *( WINAPIV *DKC_ALLOC_FUNC_TYPE)(size_t);
///free()n ֐̌^
typedef void (WINAPIV *DKC_FREE_FUNC_TYPE)(void *);

DKC_EXTERN void *WINAPIV dkcMallocAdapter(size_t);

DKC_EXTERN void WINAPIV dkcFreeAdapter(void *);

DKC_EXTERN  void* WINAPIV dkcAllocate(size_t size);

DKC_EXTERN  int	WINAPIV dkcFree(void **p);

DKC_EXTERN void *WINAPIV dkcAllocateFast(size_t size);

DKC_EXTERN void *WINAPIV dkcAllocateFill(size_t size,BYTE fill);

DKC_EXTERN  int WINAPI dkcReallocate(
	void **NewPtr,size_t NewSize,void **OldPtr
);

/*!
@param your_realloc[in] realloc֐
@param NewPtr[out] VԃAhX
@param NewSize[in] VԃAhX̃TCYB
@param OldPtr[in][out] ÂԃAhXB֐ƁAOldPtr͖ɂȂ
@param OldSize[in] OldPtr̃TCY
*/
///@return edk_SUCCEEDED琬
DKC_EXTERN int WINAPI dkcReallocateEx(
	DKC_REALLOC_F_TYPE your_realloc,void **NewPtr,size_t NewSize,
	void **OldPtr
);

/*!
@param your_realloc[in] realloc֐
@param NewPtr[out] VԃAhX
@param OldPtr[in][out] ÂԃAhXB֐ƁAOldPtr͖ɂȂ
@param OldSize[in] OldPtr̃TCY
@param reallocated_size[out] mۂTCY
@note
TCYgp
*/
DKC_EXTERN int WINAPI dkcReallocateAutoExpand(
	DKC_REALLOC_F_TYPE your_realloc,void **NewPtr,
	void **OldPtr,size_t OldSize,size_t *reallocated_size
);

DKC_EXTERN int WINAPI dkcGetMemorySize(uint64 *pTotalMemory,uint64 *pFreeMemory);

/*!
ZSwapBSWAP_NUM()}NQƁB
*/
DKC_EXTERN void WINAPI 
	dkcSwap(void *p1,void *p2,size_t size);
/*!
ǂȕ@łƂSwapB
@note
sizẽ𓮓ImۂăXbv܂B
*/

DKC_EXTERN BOOL WINAPI dkcSwapFast(void *p1,void *p2,size_t size);

/*!
@param p1[in] ULONGLONG *̃obt@ւ̃|C^
@param p2[in] ULONGLONG *̃obt@ւ̃|C^
@param size[in] p1,p2obt@̃TCY
@note
p1,p2ULONGLONG *ɋ^LXgĂB
*/
DKC_EXTERN void WINAPI dkcSwap64(ULONGLONG *p1,ULONGLONG *p2,size_t size);


//#define dkcSwap(p1_,p2_,size) dkcSwap64(p1_,p2_,size)
/*
#define dkcSwapFast(p1,p2,size) dkcSwap64(p1,p2,size)
*/


///fopen̎̑LȒlǂׂB
DKC_EXTERN BOOL dkcIs_foepn_mode(const char *s);
///fopeñbp[
DKC_EXTERN FILE * WINAPI dkcFOpen(const char *filename,const char *mode);
///fclosẽbp[
DKC_EXTERN int WINAPI dkcFClose(FILE **ptr);

///fread̑SӔCēǂݍ݂܂o[WB(ǂݍ߂ȂꍇEOFerror)
DKC_EXTERN size_t WINAPI dkcFReadAll(void *,size_t size,FILE *fp);


///@see dkcFReadAll() dkcFReadAllfwrite
DKC_EXTERN size_t WINAPI dkcFWriteAll(const void *,size_t size,FILE *fp);

///dkcFileSize()𕁒i͂gBG[͓͖̎`łB
DKC_EXTERN size_t WINAPI dkcFSize(FILE *fp);


///fopeñt@C֐găoCiZ[usB@note ގ: dkcMemoryToFile()
DKC_EXTERN int WINAPI dkcSaveBinary(const void *data,size_t size,const char *fname);
///oCif[^ɓǂݍށBdkcSaveBinary()Ƒ @note ގ: dkcFileToMemory()
DKC_EXTERN int WINAPI dkcLoadBinary(void *data,size_t size,const char *fname,size_t *readsize);
///fopenŃeLXgZ[us
DKC_EXTERN int WINAPI dkcSaveText(const char *text,size_t length,const char *fname);
///eLXgf[^ɓǂݍށBdkcSaveText()Ƒ
DKC_EXTERN int WINAPI dkcLoadText(char *text,size_t length,const char *fname,size_t *readsize);
///t@CB
DKC_EXTERN BOOL WINAPI dkcCreateEmptyFile(const char *filename);
///G[O(t@C)ɏA@note Sɖ킯ł͂Ȃ @param filename[in] t@C̖O
DKC_EXTERN int WINAPI dkcInitFileFast( const char *filename );
///Of @param filename[in] t@Cl[ @param str[in] f @note o͑xx̂őp͏サȂ
DKC_EXTERN  int WINAPI dkcAddLogFile( const char *filename,const char *str , ... );

DKC_EXTERN void WINAPI dkcTwoDWORDToULONGLONG(ULONGLONG *dest,DWORD high,DWORD low);

DKC_EXTERN void WINAPI dkcULONGLONGToTwoDWORD(DWORD *dhigh,DWORD *dlow,ULONGLONG src);

DKC_EXTERN void WINAPI dkcLONGLONGToTwoLONG(LONG *high,LONG *low,LONGLONG src);

DKC_EXTERN void WINAPI dkcTwoLONGToLONGLONG(LONGLONG *dest,LONG high,LONG low);


///@note GfBAɂď肭o邩Ȃ
DKC_INLINE void dkcTwoLONGToULONGLONG(ULONGLONG *dest,LONG high,LONG low){
	ULONG *p = (ULONG *)&low,*p2;
	*dest = *p;
	p = (ULONG *)(dest + 1);
	p2 = (ULONG *)&high;
	*p = *p2;
}

DKC_EXTERN int WINAPI dkcOutputDebugString(const char *str,...);
/*!
@return almost TRUE(1)
*/
DKC_EXTERN int WINAPI dkcErrorMessage(const char *expression,
										 const char *filename,size_t line,const char *message,...);



#if defined(DEBUG) || defined(DKUTIL_DEBUG)
#	define dkcmNOT_ASSERT(ex) ( (ex) && dkcErrorMessage(#ex,__FILE__,__LINE__,NULL) )
#	define dkcmASSERT(ex) ( (ex) || dkcErrorMessage(#ex,__FILE__,__LINE__,NULL) )
#	define dkcmNOT_ASSERT_MESSAGE(ex,mes) ( (ex) && dkcErrorMessage(#ex,__FILE__,__LINE__,mes) )
#	define dkcmASSERT_MESSAGE(ex,mes) ( (ex) || dkcErrorMessage(#ex,__FILE__,__LINE__,mes) )
#else
#	define dkcmNOT_ASSERT_MESSAGE(ex,mes) ((void)0)
#	define dkcmASSERT_MESSAGE(ex,mes) ((void)0)
#	define dkcmNOT_ASSERT(ex) ((void)0)
#	define dkcmASSERT(ex) ((void)0)
#endif

#	define dkcmFORCE_NOT_ASSERT(ex) ( (ex) && dkcErrorMessage(#ex,__FILE__,__LINE__,NULL) )
#	define dkcmFORCE_ASSERT(ex) ( (ex) || dkcErrorMessage(#ex,__FILE__,__LINE__,NULL) )
#	define dkcmFORCE_NOT_ASSERT_MESSAGE(ex,mes) ( (ex) && dkcErrorMessage(#ex,__FILE__,__LINE__,mes) )
#	define dkcmFORCE_ASSERT_MESSAGE(ex,mes) ( (ex) || dkcErrorMessage(#ex,__FILE__,__LINE__,mes) )

///@return path separator̓(1bytepath separator̕萔Ă)Qbg										 
DKC_EXTERN const char *WINAPI dkcGetPathSep();

/**
@param isForceExit[in] TRUEw肷dkutil_c̏ƈꍇAIB
@return edk_Result
*/
DKC_EXTERN int dkcDynamicCheckEnvironment(BOOL isForceExit);
///@param flag[in] TRUEŃ`FbNL
DKC_EXTERN void WINAPI dkcCheckMemoryLeak(BOOL flag);
///@return MMXgȂTRUE
DKC_EXTERN BOOL WINAPI dkcIsMMX();



#define dkcmREVERSE_ENDIAN16(x) ( (USHORT)( (x >> 8) | (x << 8) ) )

#define dkcmREVERSE_ENDIAN32(x) \
	( (x << 24) | ( (x & 0x0000ff00) << 8) | ( (x & 0x00ff0000) >> 8 ) | (x >> 24) )

#ifdef WIN32
#	define dkcmREVERSE_ENDIAN64(x) (\
		(ULONGLONG)dkcReverseEndian32( (DWORD) (x & 0x00000000ffffffff) ) << 32 )\
		| \
		dkcReverseEndian32((DWORD)(x >> 32)\
	)
#else
#	define dkcmREVERSE_ENDIAN64(x) dkcReverseEndian64(x)

#endif
///@note  General Function Library  Copyright (C) 2000,2001 SYN All Rights Reserved.
DKC_EXTERN ULONG dkcReverseEndian32(ULONG x);
///@note  General Function Library  Copyright (C) 2000,2001 SYN All Rights Reserved.
DKC_EXTERN ULONGLONG dkcReverseEndian64(ULONGLONG x);
///endian change 16 bit version
DKC_EXTERN USHORT dkcReverseEndian16(USHORT x);

///@return little endian ȂTRUE
DKC_EXTERN BOOL dkcIsLittleEndian();
///@return big endianȂTRUE
#define dkcIsBigEndian() (!dkcIsLittleEndian())

enum edkcByteOrder{
	///big-endian motorola
	edkcByteOrder_ABCD = 0,
	///little-endian intel
	edkcByteOrder_DCBA,
	///BADC - vax i386?
	edkcByteOrder_BADC,
	edkcByteOrder_Unknown = 255,
};
typedef union dkc_byte_order_check_union{
	uint32 x;
	uint8 abcd[4];
}DKC_BYTE_ORDER_CHECK_UNION;
///@return enum edkcByteOrder
DKC_EXTERN int WINAPI dkcGetByteOrder();

///unsigned long^̓̐vXI[o[t[邩ǂ`FbNB
DKC_EXTERN BOOL dkcCheckOverflowULONG(ULONG a1,ULONG a2);
DKC_EXTERN BOOL dkcCheckOverflowULONGLONG(ULONGLONG a1,ULONGLONG a2);

#define dkcCheckOverflow32(a,b) dkcCheckOverflowULONG(a,b)
#define dkcCheckOverflow64(a,b) dkcCheckOverflowULONGLONG(a,b)


typedef int (WINAPIV *DKC_COMPARE_TYPE)(const void *,const void *);

/*!
@param dest[out] Ԗڂ̃f[^邽߂̃obt@ widthoCg̃obt@Kv
@param a_src[in] ւ̃|C^
@param n[in] ̗vf邩
@param k[in] ڂ̗vf̃ItZbgm肽
@param width[in] ItZbg
@param less[in] LESS̃RyA֐ւ̃|C^
@return edk_SUCCEEDEDŐ
ItZbgl (BYTE *)a_src + width * offset łB
@note
Ȃ݂a_srcɓn|C^͓ŃmۂARs[܂B
@code
int greater_comp(const void *v1,const void *v2){
	return *( ( int * ) v2 ) - *( ( int * ) v1 );
}
void test()
{
	int arr[]={0,1,2,3};
	int dest;
	dkcSelect((void *)&dest,(const void *)arr,4,3,sizeof(int),greater_comp);
}
@endcode
*/
///킢ZNg(I)ASY
DKC_EXTERN int WINAPI dkcSelect(void *dest,const void *a_src,size_t n,int k,size_t width ,DKC_COMPARE_TYPE comp);

/*!
őlI
@see dkcSelect()  k
*/
DKC_EXTERN int WINAPI dkcSelectMax(void *dest,const void *a, size_t n,size_t width ,DKC_COMPARE_TYPE comp);
/*!
ŏlI 
@see dkcSelect()  k
*/
DKC_EXTERN int WINAPI dkcSelectMin(void *dest,const void *a, size_t n,size_t width ,DKC_COMPARE_TYPE comp);


DKC_INLINE int dkcRotateShiftRightMemoryLogic(void *dest,size_t size,size_t n,void *workbuff,size_t worksize);


DKC_EXTERN int WINAPI dkcRotateShiftRightMemory(void *dest,size_t size,size_t n);

/*
DKC_EXTERN void dkcSetAllocateMode(int flag);

DKC_EXTERN void *dkcDebugAlloc
*/



#if DKC_HAVE_INLINE==1

DKC_FORCE_INLINE void *WINAPI dkcSecureFillMemory (void * Destination,size_t Length,uint8 Fill){
	volatile uint8 *vptr = (volatile uint8 *)Destination;
	while(Length){
		*vptr = Fill;
		vptr++;
		Length--;
	}
	return Destination;
}

DKC_FORCE_INLINE void *dkcSecureZeroMemory(void  *ptr, size_t cnt)
{
	/*volatile char *vptr = (volatile char *)ptr;
	while (cnt) {
		*vptr = 0;
		vptr++;
		cnt--;
	}
	return ptr;*/
	return dkcSecureFillMemory(ptr,cnt,0);
}


///ǂݍ߂ȂiFALSEjfeofferror()gĂB
DKC_INLINE BOOL dkcFReadAllCheck(void *buff,size_t size,FILE *fp)
{
	if(size != dkcFReadAll(buff,size,fp))
		return FALSE;
	return TRUE;
}
DKC_INLINE BOOL dkcFWriteAllCheck(const void *buff,size_t size,FILE *fp)
{
	if(size != dkcFWriteAll(buff,size,fp))
		return FALSE;
	return TRUE;
}



///Óȃe|obt@̃TCYԂ
DKC_INLINE size_t dkcGetProperTemporaryBufferSize(){
	uint64 total_size,free_size;
	if(DKUTIL_FAILED(dkcGetMemorySize(&total_size,&free_size)))
	{
		return 1024 * 64;
	}

	/*if(free_size < 1024 * 1024)
	{
		return 1024;
	}
	//freespace肠
	if(free_size > total_size / 2)
	{
		return total_size / 0x4000;//32768
	}*/
	total_size = free_size / 0x1000;//4096
	if(total_size > 1024 * 1024){
		total_size = 1024 * 1024;
	}
	else if(0==total_size) 
	{
		total_size = free_size % 0x1000;
		if(0==total_size){
			return 1;
		}
	}
	return (size_t)total_size;
}
#else

// WINAPI ...

#endif





#ifdef __cplusplus

namespace dkutil{


/*!

@param data[in] t@C̃f[^ւ̃|C^(void *)ɃLXgĂԂłB
@param size[in] t@C̃f[^̃TCY@(ރTCY)
@param fname[in] t@C̖O
@param mode[in] ftHg="wb" I[v[h ڂMSDNfopen֐I
@return true= false=s

*/
///fopeñt@C֐găoCiZ[usB
inline bool SaveBinary(const void *data,size_t size,const char *fname,const char *mode="wb"){//="wb"
	FILE *fp;
	fp = fopen( fname , mode ) ;//wb
	if(fp==NULL) return false;
	//fwrite( data , size  , 1 , fp ) ;
	dkcFWriteAll(data,size,fp);
	//fwrite( data , sizeof(size)  , 1 , fp ) ;
	fclose( fp ) ;
	return true;
	//return dkcSaveBinary(data,size,fname);
}

/*!
@param data[out] t@C̃f[^̃obt@ (void *)ɃLXgĂԂłB
@param size[in] t@C̃f[^̃obt@TCY@(ǂݍރTCY)
@param fname[in] t@C̖O
@param mode[in] ftHg="rb" I[v[h ڂMSDNfopen֐I
@return true= false=s
*/
///oCif[^ɓǂݍށBSaveBinary()Ƒ
inline bool LoadBinary(void *data,size_t size,const char *fname,const char *mode="rb" ){//="rb"
	FILE *fp ;
	fp = fopen( fname , mode ) ;//rb
	if(fp==NULL)return false;
	dkcFReadAll(data,size,fp);
	//fread( data ,  size , 1 , fp ) ;
	//fread( data , sizeof(size)  , 1 , fp ) ;
	fclose( fp ) ;
	return true;
}

inline bool SaveText(const char *text,size_t length,const char *fname,const char *mode="wt"){
	return SaveBinary(text,length,fname,mode);
}
inline bool LoadText(char *text,size_t length,const char *fname,const char *mode="rt"){
	return LoadBinary(text,length,fname,mode);
}



}//end of dkutil namespace


#else //for c lang




#endif //end of __cplusplus

#endif //end of include once