/*!
@file dkcDCF01.h
@brief dKingyo Cryption File Version01
@note
dKingyo Cryption File Version01`̎
version01
f[^\
 HEADER01
 Íς݃f[^
ÍɂSNOW2gpB
<br>
t@CʁX̃pX[hňÍ肷
pX[hWbN͂\邩H
Ȃ̂ł̏ꍇ͓dÍ铙ĂB
@since 2005/11/22
*/
#ifndef DKUTIL_C_DCF01_H
#define DKUTIL_C_DCF01_H

#include "dcf_misc.h"

typedef struct dkc_dKingyoCryptionFileHeader01{
	uint8 hash_value[SHA512_BIN_BUFFER_SIZE];
	uint64 data_size;
}DKC_DCF_HEADER01;


/**
@param attach_cp[in] DKC_SNOW2IuWFNgւ̃|C^
@param attach_sp[in] DKC_STREAMIuWFNgւ̃|C^@炩ߏ݂ǂݍ݂AedkcStreamInitFile64ŏĂB
*/
DKC_EXTERN DKC_DCF *WINAPI dkcAllocDCF_Version01_SNOW2(DKC_SNOW2 *attach_cp,DKC_STREAM *attach_sp);

DKC_EXTERN DKC_DCF *WINAPI dkcAllocDCF01(const char *filename,uint32 stream_flags,const void *key,size_t keysize);

DKC_EXTERN int WINAPI dkcFreeDCF01(DKC_DCF **pp);

/**
bZ[W_CWFXg֐
*/
DKC_EXTERN void WINAPI dkcDCF01Init(DKC_DCF *p);


/**
@return edk_SUCCEEDEDŐB
sdkcDCFInit()Ăяočŏ珈ȂĂB
*/
DKC_EXTERN int WINAPI dkcDCF01Write(DKC_DCF *p,const void *data,size_t size,size_t *write_size);
/**
@return edk_SUCCEEDEDŃnbVݐ
sdkcDCFInit()Ăяočŏ珈ȂĂB
*/
DKC_EXTERN int WINAPI dkcDCF01WriteFinal(DKC_DCF *p);
/**
@return edk_EndProcessłׂēǂݍ񂾁Bedk_SUCCEEDEDŐ폈B
߂lOqȊOdkcDCFInit()Ăяočŏ珈ȂĂB
*/
DKC_EXTERN int WINAPI dkcDCF01Read(DKC_DCF *p,void *buff,size_t size,size_t *readsize);

/**
@return edk_SUCCEEDEDŃnbV`FbNBf[^͐B
*/
DKC_EXTERN int WINAPI dkcDCF01ReadFinal(DKC_DCF *p);

//DKC_EXTERN BOOL WINAPI dkcDCF01PasswordCheck(const char *filename,const void *password,size_t size);

DKC_EXTERN int WINAPI dkcFileToDCF01(const char *save_filename,const char *target_filename,
					 const void *key,size_t keysize);

DKC_EXTERN int WINAPI dkcDCF01ToFile(const char *dest_filename,const char *target_filename,
					 const void *key,size_t keysize);



#endif //end of include once