/*!
@file dkcCircularMemoryStream.h
@since 2004/3/xx
@brief obt@[ boost::circular_stream݂Ȃ́@ȁH
@note
*/
#ifndef DKUTIL_C_CIRCULAR_MEMORYSTREAM_H
#define DKUTIL_C_CIRCULAR_MEMORYSTREAM_H


#include "dkcMemoryStream.h"


enum edkcCirculerMemoryStream{
	///̈ʒuV[N
	edkcCirculerMemoryStreamSeekCurrent = edkcSeekCurrent,
	///Ō̈ʒuV[N
	edkcCirculerMemoryStreamSeekEnd = edkcSeekEnd,
	///ŏ̈ʒuV[N
	edkcCirculerMemoryStreamSeekSet = edkcSeekSet,


};
/*
enum edkcCircularMemoryStream{
	edkcCircularMemoryStreamInitBuffer = edkcStreamInitBuffer,
	edkcCircularMemoryStreamInitFile = edkcStreamInitFile,
	///ȗ̈܂߂ׂĂ̓obt@_vB
	edkcCircularMemoryStreamDumpAll,
	///Lȗ݂̈̂̓obt@_vB
	edkcCircularMemoryStreamDumpEnable,

};
*/
/*!
 ~^Xg[iOobt@f[^j\
 */
typedef struct dkc_CircularMemoryStream{
	/// f[^̈̃Xg[
	BYTE *mBuffer;
	/// Oobt@̑傫 
	size_t mSize ;
	/// Lf[^̎n܂ƏI
	size_t mStart,mEnd;		
	/// Lȃf[^̒
	size_t mEnableLength ;

} DKC_CIRCULAR_MEMORYSTREAM;

DKC_EXTERN DKC_CIRCULAR_MEMORYSTREAM * WINAPI dkcAllocCircularMemoryStream(size_t size);

DKC_EXTERN int WINAPI dkcFreeCircularMemoryStream(DKC_CIRCULAR_MEMORYSTREAM **ptr);

/*!
@param readsize[out] ۂɓǂ񂾃TCYԂBNULLnĂOK.
@note
Ew肵TCY(size)Xg[obt@̃TCYꍇ
readsizeɎۂɓǂ񂾃TCY܂B
EReadf[^͎of[^ƂďA
̃obt@ẽ͎f[^ۑ̈Ƃčėp܂B
܂AxReadf[^͓xƎo܂B
*/
///stream[hBfread݂Ȃ
DKC_EXTERN int WINAPI dkcCircularMemoryStreamRead(DKC_CIRCULAR_MEMORYSTREAM *ptr,void *buffer,size_t size,size_t *readsize);

///`邾BɂĂdkcCircularMemoryStreamRead()ׂB
DKC_EXTERN int WINAPI dkcCircularMemoryStreamReference(DKC_CIRCULAR_MEMORYSTREAM *ptr,void *buffer,size_t size,size_t *readsize);

/*!
@note
Xg[obt@͉~^łB킢RingBufferēzłB
dkcCircularMemoryStreamWritedkcCircularMemoryStreamReadăf[^oĂ܂傤B
Ȃ΁AA~^obt@̗Lf[^tɂȂĂ̊֐͎s܂B
C boost::circular_buffer݂Ȃ̂łˁOOGiƂ܂A܂ԗւ̍ĊJĂ邵B

*/
///streamCgBfwrite݂Ȃ
DKC_EXTERN int WINAPI dkcCircularMemoryStreamWrite(DKC_CIRCULAR_MEMORYSTREAM *ptr,const void *buffer,size_t size);

///stream̃JE^OɂĎシׂăNA[ɂB
DKC_EXTERN int WINAPI dkcCircularMemoryStreamClear(DKC_CIRCULAR_MEMORYSTREAM *ptr);

/*!
DKC_CIRCULAR_MEMORYSTREAMRs[B
C++ŌRs[RXgN^݂Ȃ́OOG
*/
DKC_EXTERN DKC_CIRCULAR_MEMORYSTREAM *WINAPI 
	dkcAllocCircularMemoryStreamCopy(const DKC_CIRCULAR_MEMORYSTREAM *ptr);

DKC_INLINE size_t dkcCirculerMemoryStreamTell(DKC_CIRCULAR_MEMORYSTREAM *ptr)
{
	return ptr->mStart;
}
DKC_INLINE size_t dkcCirculerMemoryStreamSize(DKC_CIRCULAR_MEMORYSTREAM *ptr)
{
	return ptr->mEnableLength;
}
DKC_INLINE size_t dkcCirculerMemoryStreamEOF(DKC_CIRCULAR_MEMORYSTREAM *ptr)
{
	return ptr->mSize == ptr->mEnd;
}

///todo test ܂eXgĖOOG
DKC_INLINE int dkcCirculerMemoryStreamSeek(DKC_CIRCULAR_MEMORYSTREAM *ptr,long offset,long origin)
{
	long point;
	size_t change;
	switch(origin){
	case edkcCirculerMemoryStreamSeekCurrent:
		point = ptr->mStart;
		break;
	case edkcCirculerMemoryStreamSeekEnd:
		point = ptr->mEnd;
		break;
	case edkcCirculerMemoryStreamSeekSet:
		point = 0;
		break;
	default:
		return edk_ArgumentException;
	}
	//LȃOobt@Ɏ܂TCYɂȂ悤
	change = offset % ptr->mEnableLength;
	change = (point + change);

	if(TRUE==dkcCheckOverflow32(ptr->mStart ,change)){
		return edk_FAILED;
	}
	/*//if(!(ptr->mSize > change)){
	if(!(ptr->mSize >= change)){
		return edk_FAILED;
	}*/
	if( ptr->mStart + change > ptr->mEnd)
	{
		return edk_FAILED;
	}
	ptr->mSize += change;
	return edk_SUCCEEDED;
}

//stream̂̂obt@ɃRs[B
//DKC_EXTERN int WINAPI dkcCircularMemoryStreamToBuffer(
//	const DKC_CIRCULAR_MEMORYSTREAM *ptr,char *buff,size_t size,size_t want_size);

/*
#ifndef DKUTIL_C_CIRCULAR_MEMORYSTREAM_H
#	include "dkcCircularMemoryStream.c"
#endif
*/

#endif