/*!
@file dkcCamellia.h
@brief {Ă鍑YÍCamellia
*/
#ifndef  DKUTIL_C_CAMELLIA_H
#define  DKUTIL_C_CAMELLIA_H

#include "dkutil_c/dkcOSIndependent.h"


///arcfour algprithm state (RC4݊̃ASY
typedef struct dkc_Camellia{
	unsigned char mi;
	unsigned char mj;
	unsigned char msbox[256];
}DKC_CAMELLIA;

#if 0
/*!
@param key[in] keyւ̃|C^
@param keylen[in] keỹTCY
@return DKC_CAMELLIA_STATE \̂ւ̃|C^
@note
gIdkcFreeCamelliag܂傤B
*/
DKC_EXTERN DKC_CAMELLIA_STATE * WINAPI dkcAllocCamellia(const unsigned char *key,size_t keylen);

/*!
@param dkcAllocCamelliaŊmۂ̈ւ̃|C^ւ̃|C^
@return edk_SUCCEEDEDŐ
*/
DKC_EXTERN int WINAPI dkcFreeCamellia(DKC_CAMELLIA_STATE **p);

/*!
@param p[in][out] dkcAllocCamellia()Ŋmۂ̈ւ̃|C^
@return XORׂl
*/
DKC_EXTERN unsigned char WINAPI dkcCamelliaByte(DKC_CAMELLIA_STATE *p);
/*!
@param p[in] dkcAllocCamellia()Ŋmۂ̈ւ̃|C^
@param dest[in] o̓obt@ւ̃|C^
@param destsize[in] dest̃TCY
@param src[in] ̓obt@ւ̃|C^
@param srcsize[in] src̃TCY
@return edk_SUCCEEDED Ő
*/
DKC_EXTERN int WINAPI dkcCamelliaEncrypt(DKC_CAMELLIA_STATE *p,
	unsigned char *dest,size_t destsize,
	const unsigned char *src,size_t srcsize);

DKC_EXTERN void WINAPI dkcCamelliaEncryptNoDest(DKC_CAMELLIA_STATE *p,
	unsigned char *dest_and_src,size_t dest_and_srcsize);	

#define dkcCamelliaDecrypt(p,dest,destsize,src,srcsize) \
	dkcCamelliaEncrypt(p,dest,destsize,src,srcsize)

#define dkcCamelliaDecryptNoDest(p,dest_and_src,dest_and_srcsize) \
	dkcCamelliaEncryptNoDest(p,dest_and_src,dest_and_srcsize)

#endif


#if !defined( DKUTIL_C_CAMELLIA_C ) &&  defined(USE_DKC_INDEPENDENT_INCLUDE)
#	include "dkcCamellia.c"
#endif

#endif //end of include once