# vim: fileencoding=utf8
import amf

class_mappings = {}

def get_module(mod_name):
    mod = __import__(mod_name)
    components = mod_name.split('.')
    for comp in components[1:]:
        mod = getattr(mod, comp)
    return mod

def get_class(fqcn):
    try:
        mod_and_class = fqcn.split('.')
        if mod_and_class:
            mod_name = '.'.join(mod_and_class[:-1])
            class_name = mod_and_class[-1]
            amf.logger.debug("get_class(%s) -- module='%s', class='%s'", fqcn, mod_name, class_name)
            mod = get_module(mod_name)
            clz = getattr(mod, class_name)
            if callable(clz):
                return clz
    except:
        pass

def classcast(type, obj={}):
    amf.logger.debug("classcast(%s, %s)", str(type), str(obj))
    if class_mappings:
        type = class_mappings.get(type, type)
    clz = get_class(type)
    if clz:
        c = clz()
        for key, value in obj.iteritems():
            setattr(c, key, value)
        return c
    else:
        return obj

def get_as_type(obj):
    """Find the name of ActionScript class mapped to the class of given python object.
       If the mapping for the given object class is not found, return the class name of the object."""
    type = obj.__module__ + '.' + obj.__class__.__name__
    if class_mappings:
        for as_class, py_class in class_mappings.iteritems():
            if type == py_class:
                return as_class
    return type
