# vim: fileencoding=utf8
from cStringIO import StringIO
from xml.dom.minidom import parseString
import logging
import codecs
import datetime
import time
import struct

logger = logging.getLogger()

def set_logger(custom_logger):
    global logger
    logger = custom_logger


class AMFMessageBody(object):

    def __init__(self, target, response, data):
        self.target = target
        self.response = response
        self.data = data
        self.__service_name = None
        self.__service_method_name = None

    def __get_service_method_path(self):
        if not self.__service_name or not self.__service_method_name:
            self.__setup_target()
        return self.__service_name + '/' + self.__service_method_name
    service_method_path = property(__get_service_method_path)

    def __setup_target(self):
        dotIndex = self.target.rfind('.')
        if dotIndex > 0:
            self.__service_name = self.target[:dotIndex]
            self.__service_method_name = self.target[dotIndex+1:]

    def __get_args(self):
        if isinstance(self.data, list):
            return self.data
        return []
    args = property(__get_args)
         
    def __str__(self):
        return "target=%s,response=%s,data=%s" % (self.target, self.response, self.data)


class AMFMessage(object):

    def __init__(self):
        self.headers = []
        self.headerMap = {}
        self.bodies = []
        self.version = 0x03

    def add_header(self, amfHeader):
        self.headers.append(amfHeader)
        self.headerMap[amfHeader['name']] = amfHeader['value']

    def add_body(self, amfBody):
        self.bodies.append(amfBody)

    def get_body_count(self):
        return len(self.bodies)

    def __str__(self):
        return "AMFMessage object [%d headers, %d bodies]" % (len(self.headers), len(self.bodies))


RESPONSE_RESULT = '/onResult'
RESPONSE_STATUS = '/onStatus'

def read(raw_post_data):
    import amf0
    amfreader = amf0.AMFReader(raw_post_data)
    return amfreader.read()

def write(message):
    import amf0
    amfwriter = amf0.AMFWriter()
    return amfwriter.write(message)

