# -*- coding: utf-8 -*-
'''
Created on 2010/11/01

@author: katsuhiro
'''
import cgi
import facebook
import urllib
from datetime import datetime

from django.conf import settings
from django.core.urlresolvers import reverse
from django.contrib.auth.decorators import login_required
from django.contrib.sites.models import Site
from django.http import HttpResponseRedirect
from django.utils.translation import ugettext as _
from django.views.generic.simple import redirect_to

from djanction.appauth.models import LoginLog
from djanction.socialapi.models import SocialService


domain = Site.objects.get_current().domain

def authenticate(request, redirect_uri=None):
    if redirect_uri is None:
        redirect_uri = 'http://' + domain + reverse(fblogin)
#    if request.GET.has_key('next'):
#        redirect_uri += '?next=' + request.GET['next']
    args = { 'client_id': settings.FACEBOOK_APP_ID,
            'redirect_uri': redirect_uri,
            'scope': 'user_groups,publish_stream,offline_access',
            }
    return HttpResponseRedirect('https://graph.facebook.com/oauth/authorize?' + urllib.urlencode(args))


def fblogin(request):
    fbinfo = facebook.get_user_from_cookie(request.COOKIES, settings.FACEBOOK_APP_ID, settings.FACEBOOK_APP_SECRET)
    if fbinfo is None:
        if request.GET.has_key('code'):
            access_token = get_access_token(request)
            fbinfo = {'access_token':access_token, 'uid':get_fb_user(access_token)}
        else:
            return authenticate(request)
    return login(request, fbinfo)


@login_required
def fbsetup(request):
    fbinfo = facebook.get_user_from_cookie(request.COOKIES, settings.FACEBOOK_APP_ID, settings.FACEBOOK_APP_SECRET)
    if fbinfo is None:
        redirect_uri = 'http://' + domain + reverse(fbsetup)
        if request.GET.has_key('code'):
            access_token = get_access_token(request, redirect_uri=redirect_uri)
            fbinfo = {'access_token':access_token, 'uid':get_fb_user(access_token)}
        else:
            return authenticate(request, redirect_uri=redirect_uri)
    _regist(request.user, fbinfo)
    return login(request, fbinfo, redirect_uri=reverse('djanction.mypage.views.socialservice_settings'))


def fbteardown(request):
    _unregist(request.user)
    return redirect_to(request, reverse('djanction.mypage.views.socialservice_settings'))


def _regist(user, fbinfo):
    fbservice = SocialService()
    fbservice.service_id = fbinfo['uid']
    fbservice.service_name = 'facebook'
    fbservice.user = user
    fbservice.save()


def _unregist(user):
    service = SocialService.objects.get(user=user, service_name='facebook')
    service.delete()


def login(request, fbinfo, redirect_uri=None):
    if not request.user.is_authenticated():
        try:
            user = SocialService.objects.filter(service_name='facebook', service_id=fbinfo['uid'])[0].user
        except:
            # login from top page
            if redirect_uri is None:
                from djanction.appauth.views import direct_to_login
                msg = u'facebook アカウントの設定がされていません。'
                if hasattr(settings, 'AUCTION_NAME'):
                    msg += settings.AUCTION_NAME
                msg += u'アカウントでログインした後、' + _('Settings') + '->' + _('Social Service Settings') + u' から設定を行ってください。'
                return direct_to_login(request, msg)
            raise
        user.backend = 'djanction.appauth.backends.ModelBackend'
        if user.is_active:
            from django.contrib.auth import login
            login(request, user)
            _log_login(user, request, True)
        else:
            _log_login(user, request, False)
#        return _direct_to_login(request, _('The account is stopping.'))
    request.session['fb_access_token'] = fbinfo['access_token']
    if redirect_uri is None:
        if request.GET.has_key('next'):
            redirect_uri = request.GET['next']
        else:
            redirect_uri = reverse('top_page')
    return redirect_to(request, redirect_uri)


def _log_login(user, request, isSuccess):
    log = LoginLog()
    log.user = user
    log.is_success = isSuccess
    log.session_id = request.COOKIES.get('sessionid')
    log.ip_address = request.META.get('REMOTE_ADDR')
    log.user_agent = request.META.get('HTTP_USER_AGENT')
    log.login_date = datetime.today()
    log.save()


def get_access_token(request, redirect_uri=None):
    args = { 'client_id': settings.FACEBOOK_APP_ID,
            'redirect_uri': redirect_uri,
            'client_secret': settings.FACEBOOK_APP_SECRET,
            'code': request.GET['code'],
            }
    if redirect_uri is None:
        redirect_uri = 'http://' + domain + reverse(fblogin)
#    if request.GET.has_key('next'):
#        redirect_uri += '?next=' + request.GET['next']
#        args.update({ 'type': 'client_cred'})
    args.update({ 'redirect_uri': redirect_uri })

    response = cgi.parse_qs(urllib.urlopen(
        'https://graph.facebook.com/oauth/access_token?' +
        urllib.urlencode(args)).read())
    return response['access_token'][-1]


def get_fb_user(token):
    api = facebook.GraphAPI(access_token=token)
    profile = api.get_object('me')
    return profile['id']


def post_msg(token, item):
    if not hasattr(settings, 'FACEBOOK_GROUP_ID'):
        return
    api = facebook.GraphAPI(access_token=token)
    if not _is_group_member(api):
        return
    message = _('I have items up for auction. Bids if it is good!').encode('utf-8')
    caption = _('current price') + ':' + str(item.current_price) + _('yen')
    item_info = {
        'caption': caption.encode('utf-8'),
        'name': item.item_name.encode('utf-8'),
        'description':  item.comment.encode('utf-8'),
        'link': 'http://' + domain + reverse('djanction.item.views.info', args=[item.id]),
        'picture': 'http://' + domain + reverse('top_page') + 'static/img/items/' + str(item.id) + '/1.' + settings.USER_ICON_TYPE,
    }
    api.put_wall_post(message, item_info, profile_id=settings.FACEBOOK_GROUP_ID)


def _is_group_member(api):
    groups = api.get_object('me/groups')['data']
    for g in groups:
        if g['id'] == settings.FACEBOOK_GROUP_ID:
            return True
    return False


def get_like_btn(view, args=None):
    btn = '<script src="http://connect.facebook.net/ja_JP/all.js#xfbml=1"></script>'
    btn += '<fb:like href="'
    btn += 'http://' + domain + reverse(view, args=args)
    btn += '" layout="button_count" font="arial"></fb:like>'
    return btn
