'''
Created on 2010/05/02

@author: katsuhiro Inagaki
'''

import Image

def resize(image, width=None, height=None):
    assert not (width is None and height is None)
    img_aspect = image.size[0] / float(image.size[1])
    if width is None:
        new_width = height * img_aspect
        new_height = height
    elif height is None:
        new_width = width
        new_height = width / img_aspect
    else:
        new_width = width
        new_height = height
    size = (new_width, new_height)
    return image.resize(size, Image.ANTIALIAS)
