# -*- coding: utf-8 -*-
'''
Created on 2010/10/09

@author: inagaki_katsuhiro
'''

from django.conf import settings
from django.core.urlresolvers import reverse

from djanction.mail import create_msg, send_template_msg

def send_end_msg(item):
    if not hasattr(settings, 'MAIL_SENDER'):
        return
    url = reverse('djanction.item.views.info', args=[item.id])
    from django.contrib.sites.models import Site
    domain = Site.objects.get_current().domain
    template = 'mail/salesend.txt'
    args = {
        'item': item,
        'url':'http://' + domain + url,
    }
    subject = settings.AUCTION_NAME + u' - 終了：' + item.item_name + '(' + str(item.id) + ')'
    email = item.user.email
    if email is not None:
        send_template_msg(email, subject, template, args)
    email = item.highest_bidder.email
    if email is not None:
        send_template_msg(email, subject, template, args)

def send_end_nobid_msg(item):
    if not hasattr(settings, 'MAIL_SENDER'):
        return
    from django.contrib.sites.models import Site
    domain = Site.objects.get_current().domain
    template = 'mail/salesend_nobid.txt'
    args = {
        'item': item,
        'url':'http://' + domain + reverse('djanction.item.views.info', args=[item.id]),
        'list_url':'http://' + domain + reverse('djanction.mypage.views.salesends'),
    }
    subject = settings.AUCTION_NAME + u' - 終了：' + item.item_name + '(' + str(item.id) + ')'
    email = item.user.email
    if email is not None:
        send_template_msg(email, subject, template, args)


def send_qa_arrive_msg(qa):
    if not hasattr(settings, 'MAIL_SENDER'):
        return

    from django.contrib.sites.models import Site
    domain = Site.objects.get_current().domain
    template = 'mail/qa_arrived.txt'

    item = qa.item
    if qa.post_user == item.user:
        return
    mailto = item.user

    args = {
        'qa': qa,
        'url':'http://' + domain + reverse('djanction.item.views.info', args=[item.id]),
    }
    subject = settings.AUCTION_NAME + u' - 質問メッセージが届いています'
    email = mailto.email
    if email is not None:
        send_template_msg(email, subject, template, args)


def send_contact_arrive_msg(contact):
    if not hasattr(settings, 'MAIL_SENDER'):
        return

    from django.contrib.sites.models import Site
    domain = Site.objects.get_current().domain
    template = 'mail/contact_arrived.txt'

    sender = contact.post_user
    item = contact.item
    mailto = None
    if sender == item.user:
        mailto = item.highest_bidder
    else:
        mailto = item.user

    args = {
        'contact': contact,
        'url':'http://' + domain + reverse('djanction.item.views.info', args=[item.id]),
    }
    subject = settings.AUCTION_NAME + u' - 取引メッセージが届いています：' + contact.title
    email = mailto.email
    if email is not None:
        send_template_msg(email, subject, template, args)

