'''
Created on 2010/04/25

@author: katsuhiro Inagaki
'''
from django import forms
from django.contrib.auth.forms import UserChangeForm, UserCreationForm
from django.utils.translation import ugettext as _
from djanction.appauth.models import User

class UserCreationForm(UserCreationForm):
    class Meta:
        model = User
        fields = ("username",)

class UserChangeForm(UserChangeForm):
    class Meta:
        model = User

class SignUpForm(forms.Form):
    username = forms.RegexField(label=_("Username"), max_length=30, regex=r'^\w+$',
        help_text = _("Required. 30 characters or fewer. Alphanumeric characters only (letters, digits and underscores)."),
        error_message = _("This value must contain only letters, numbers and underscores."))
    last_name = forms.CharField(label=_("last name"), required=True)
    first_name = forms.CharField(label=_("first name"), required=True)
    password = forms.CharField(label=_("password"), widget=forms.PasswordInput, required=True)
    email = forms.EmailField(required=True)
