# -*- coding: utf-8 -*-
'''
Created on 2010/10/09

@author: inagaki_katsuhiro
'''

from django.conf import settings
from django.core.urlresolvers import reverse

from djanction.mail import create_msg, send_template_msg

def send_end_msg(item):
    if not hasattr(settings, 'MAIL_SENDER'):
        return
    url = reverse('djanction.item.views.info', args=[item.id])
    from django.contrib.sites.models import Site
    domain = Site.objects.get_current().domain
    template = 'mail/salesend.txt'
    args = {
        'item': item,
        'url':'http://' + domain + settings.BASE_URL + url,
    }
    subject = settings.AUCTION_NAME + u' - 終了：' + item.item_name + '(' + str(item.id) + ')'
    email = item.user.email
    if email is not None:
        send_template_msg(email, subject, template, args)
    email = item.highest_bidder.email
    if email is not None:
        send_template_msg(email, subject, template, args)

def send_end_nobid_msg(item):
    if not hasattr(settings, 'MAIL_SENDER'):
        return
    from django.contrib.sites.models import Site
    domain = Site.objects.get_current().domain
    template = 'mail/salesend_nobid.txt'
    args = {
        'item': item,
        'url':'http://' + domain + settings.BASE_URL + reverse('djanction.item.views.info', args=[item.id]),
        'list_url':'http://' + domain + settings.BASE_URL + reverse('djanction.mypage.views.salesends'),
    }
    subject = settings.AUCTION_NAME + u' - 終了：' + item.item_name + '(' + str(item.id) + ')'
    email = item.user.email
    if email is not None:
        send_template_msg(email, subject, template, args)
