'''
Created on 2010/05/02

@author: katsuhiro Inagaki
'''

from django import forms
from django.utils.translation import ugettext_lazy as _
from django.forms.models import InlineForeignKeyHiddenInput

from djanction.item.models import Item, BidLog, ItemModifyLog, QA, ContactMessage
from djanction.item.models import Category

class ItemForm(forms.ModelForm):
    category = forms.ModelChoiceField(label=_('category'),
                    queryset=Category.objects.all().order_by('sort_order','category_name')
                )
    image1 = forms.ImageField(label=_('image1'), required=True)
    image1exist = False
    image2 = forms.ImageField(label=_('image2'), required=False)
    image2exist = False
    image3 = forms.ImageField(label=_('image3'), required=False)
    image3exist = False

    class Meta:
        model = Item
        exclude = ('user', 'comment_type','start_date', 'current_price'
                   , 'contract_price', 'is_complete', 'highest_bidder', 'version')


class ItemSearchForm(forms.Form):
    search_query = forms.CharField(max_length=256, required=False)
    user_id = forms.DecimalField(max_digits=10, required=False)


class ItemModifyForm(forms.ModelForm):
    image1 = forms.ImageField(label=_('image1'), required=False)
    image1exist = False
    image2 = forms.ImageField(label=_('image2'), required=False)
    image2exist = False
    image3 = forms.ImageField(label=_('image3'), required=False)
    image3exist = False

    class Meta:
        model = ItemModifyLog


class BidLogForm(forms.ModelForm):
    class Meta:
        model = BidLog


class QAForm(forms.ModelForm):
    class Meta:
        model = QA


class ContactMessageForm(forms.ModelForm):
    class Meta:
        model = ContactMessage
