'''
Created on 2010/07/13

@author: inagaki_katsuhiro
'''
from django.test import TestCase

class WatchlistTestCase(TestCase):

    fixtures = ['watchlist',]

    def test_watch_list_complete(self):
        c = self.client
        c.login(username='admin', password='admin')
        response = c.get('/my/watchings/', {'is_complete':'True'})

        self.failUnlessEqual(response.status_code, 200)
        self.assertTemplateUsed(response, 'mypage/watchlist.html')
        self.assertTrue(response.context['is_complete'])
        formset = response.context['formset']
        # test selected data
        self.assertEquals(len(formset.forms),3)
        self.assertEquals(formset.forms[0].instance.item.id, 15)
        self.assertEquals(formset.forms[1].instance.item.id, 14)
        self.assertEquals(formset.forms[2].instance.item.id, 35)


    def test_watch_list_not_complete(self):
        c = self.client
        c.login(username='admin', password='admin')
        response = c.get('/my/watchings/', {'is_complete':'False'})

        self.failUnlessEqual(response.status_code, 200)
        self.assertTemplateUsed(response, 'mypage/watchlist.html')
        self.assertFalse(response.context['is_complete'])
        formset = response.context['formset']
        # test selected data
        self.assertEquals(len(formset.forms),3)
        self.assertEquals(formset.forms[0].instance.item.id, 9)
        self.assertEquals(formset.forms[1].instance.item.id, 25)
        self.assertEquals(formset.forms[2].instance.item.id, 34)
