'''
Created on 2010/04/25

@author: katsuhiro Inagaki
'''
from django.contrib import admin, auth
from django.utils.translation import ugettext_lazy as _
from djanction.appauth.forms import UserCreationForm, UserChangeForm
from djanction.appauth.models import User


class UserAdmin(auth.admin.UserAdmin):
    fieldsets = (
        (None, {'fields': ('username', 'password')}),
        (_('Personal info'), {'fields': ('first_name', 'last_name', 'email', 'zip_code', 'prefecture', 'city', 'town', 'building', 'tel_no', 'birthday')}),
        (_('Service'), {'fields': ('rank', 'point', 'total_assessment')}),
        (_('Permissions'), {'fields': ('is_staff', 'is_active', 'is_superuser', 'user_permissions')}),
        (_('Important dates'), {'fields': ('last_login', 'date_joined', 'secession_date')}),
        (_('Groups'), {'fields': ('groups',)}),
    )
    form = UserChangeForm
    add_form = UserCreationForm


#admin.site.unregister(auth.models.User)
admin.site.register(User, UserAdmin)
