from django.conf.urls.defaults import *

# Uncomment the next two lines to enable the admin:
from django.conf import settings
from django.contrib import admin
admin.autodiscover()

urlpatterns = patterns('',
    # Uncomment the admin/doc line below and add 'django.contrib.admindocs'
    # to INSTALLED_APPS to enable admin documentation:
    # (r'^admin/doc/', include('django.contrib.admindocs.urls')),

    # Uncomment the next line to enable the admin:
    (r'^admin/', include(admin.site.urls)),

#    (r'^$', 'django.views.generic.simple.direct_to_template', dict(template='index.html'), 'top_page'),
    (r'^$', 'djanction.item.views.list', None, 'top_page'),
    (r'^(?P<page_no>\d+)/$', 'djanction.item.views.list'),
    (r'^categories/', include("djanction.item.urls")),
    (r'^usage/', 'django.views.generic.simple.direct_to_template', dict(template='usage.html'), 'usage_page'),
    (r'^about/', 'django.views.generic.simple.direct_to_template', dict(template='about.html'), 'about_page'),
    (r'^regist/', 'django.views.generic.simple.direct_to_template', dict(template='regist.html'), 'regist_page'),
    (r'^auth/', include("djanction.appauth.urls")),
    (r'^users/(?P<user_id>\d+)/feedback/', include("djanction.rating.urls")),
    (r'^items/', include("djanction.item.urls")),
#    (r'^users/', include("djanction.mypage.urls")),
    (r'^my/', include("djanction.mypage.urls")),
)

if settings.DEBUG:
    urlpatterns += patterns('',
        (r'^static/(?P<path>.*)$', 'django.views.static.serve',
         {'document_root': settings.MEDIA_ROOT}),
    )
