/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE MP3LAMEWRITER SOURCE CODE.              *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE MP3LAMEWRITER SOURCE CODE IS (C) COPYRIGHT 2008 Cocha        *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#ifndef _MP3LameWriter_h_
#define _MP3LameWriter_h_

#define MODE_ABR 0
#define MODE_CBR 1
#define MODE_VBR 2

// ------------------------------------------------------------------------------------------------------------------------
typedef struct
{
   int nMode;
   int nQuality;

   struct
   {
      DWORD dwBitrate;
   } abr;

   struct
   {
      DWORD dwBitrate;
   } cbr;

   struct
   {
      int nVBRQuality;
      DWORD dwMinBitrate;
      DWORD dwMaxBitrate;
   } vbr;
} LAME_CONFIG, *PLAME_CONFIG;
// ------------------------------------------------------------------------------------------------------------------------
class CMP3LameWriter : public CBaseFilter, public IFileSinkFilter
{
   friend class CInputPin;

public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CMP3LameWriter(LPUNKNOWN,HRESULT *);
   ~CMP3LameWriter();

   // IuWFNg쐬֐
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   // ISpecifyPropertyPages̃I[o[Ch
   STDMETHODIMP GetPages(CAUUID *);

   // CBaseFilteȑz\bh
   virtual CBasePin *GetPin(int n);
   virtual int GetPinCount();

   // CBaseFilter̃I[o[Ch
   STDMETHODIMP NonDelegatingQueryInterface(REFIID, void **);
   STDMETHODIMP Pause();
   STDMETHODIMP Stop();

   // IFileSinkFilter̃I[o[Ch
   STDMETHODIMP SetFileName(LPCOLESTR, const AM_MEDIA_TYPE *);
   STDMETHODIMP GetCurFile(LPOLESTR *, AM_MEDIA_TYPE *);

   // IMP3LameInterface
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP CheckBitrate(void *);
   STDMETHODIMP CheckBitrate(WAVEFORMATEX *, void *);
   STDMETHODIMP GetOutFormat(void *);
   STDMETHODIMP SetOutFormat(void *);

private:

   // [Uϐ
   CCritSec m_Lock;
   CCritSec m_ReceiveLock;
   CInputPin *m_pInputPin;
   CPosPassThru *m_pPosition;
   WCHAR m_awFileName[MAX_PATH];
};
// ------------------------------------------------------------------------------------------------------------------------

#endif _MP3LameWriter_h_
