/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE MP3FRAUNHOFERWRITER SOURCE CODE.        *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE MP3FRAUNHOFERWRITER SOURCE CODE IS (C) COPYRIGHT 2008 Cocha  *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#ifndef _MP3FraunhoferWriter_h_
#define _MP3FraunhoferWriter_h_

#include <windows.h>
#include <shlwapi.h>
#include <streams.h>
#include <mmreg.h>
#include <msacm.h>

#define SAFE_RELEASE(p) { if(p!=NULL) { (p)->Release(); (p)=NULL; } }

#define FILTER_NAME L"MP3 Fraunhofer Writer"

// {F714A0FA-B683-4185-9BEB-D454D3B1CF7D}
static const GUID CLSID_MP3FraunhoferWriter = 
{ 0xf714a0fa, 0xb683, 0x4185, { 0x9b, 0xeb, 0xd4, 0x54, 0xd3, 0xb1, 0xcf, 0x7d } };


struct ENUMDATA
{
   int nBitrate;
   HACMDRIVERID hadid;
   WAVEFORMATEX inFormat;
   MPEGLAYER3WAVEFORMAT outFormat;
};


// ------------------------------------------------------------------------------------------------------------------------
class CAcmFraunhofer
{
public:

   // RXgN^ƃfXgN^
   CAcmFraunhofer();
   ~CAcmFraunhofer();

   // R[obN֐
   static BOOL CALLBACK AcmDriverEnumCallback(HACMDRIVERID, DWORD, DWORD);


   // [U֐
   HRESULT CheckFormat(WAVEFORMATEX *, int);
   HRESULT ConvertInit(WAVEFORMATEX *, int, int);
   HRESULT Convert(HANDLE, BYTE *, int);
   HRESULT ConvertEnd(HANDLE);

private:

   // [Uϐ
   HACMDRIVER m_hDriver;
   HACMSTREAM m_hStream;
   ACMSTREAMHEADER m_acmHeader;

   ENUMDATA m_enumData;

   BYTE *m_pInBuffer;
   BYTE *m_pOutBuffer;
};
// ------------------------------------------------------------------------------------------------------------------------
class CInputPin : public CRenderedInputPin
{
   friend class CMP3FraunhoferWriter;

public:

   // RXgN^ƃfXgN^
   CInputPin(CMP3FraunhoferWriter *, LPUNKNOWN, CCritSec *, CCritSec *, HRESULT *);
   ~CInputPin();

   // CRenderedInputPin(CBasePin)̏z\bh
   virtual HRESULT CheckMediaType(const CMediaType *);

   // CRenderedInputPiñI[o[Ch
   STDMETHODIMP Receive(IMediaSample *);
   STDMETHODIMP EndOfStream(void);
   STDMETHODIMP ReceiveCanBlock() { return S_FALSE;}
   HRESULT BreakConnect();

   STDMETHODIMP NewSegment(REFERENCE_TIME tStart, REFERENCE_TIME tStop, double dRate)
   {
      return S_OK;
   }

   // IMP3FraunhoferInterface
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP CheckBitrate(int);
   STDMETHODIMP CheckBitrate(WAVEFORMATEX *, int);
   STDMETHODIMP GetBitrate(int *);
   STDMETHODIMP SetBitrate(int);


   // [U֐
   HRESULT StartStreaming();
   HRESULT SetFileName(LPCOLESTR);
   HRESULT Stop();

   // [Uϐ
//   WAVEFORMATEX m_InFormat;


private:

   // [Uϐ
   HANDLE m_hFile;
   CMP3FraunhoferWriter * const m_pFilter;
   CCritSec *m_pReceiveLock;
   WCHAR m_awFileName[MAX_PATH];

   WAVEFORMATEX m_inFormat;

   int m_nBitrate;
   CAcmFraunhofer *m_pAcmFraunhofer;

};
// ------------------------------------------------------------------------------------------------------------------------
class CMP3FraunhoferWriter : public CBaseFilter, public IFileSinkFilter
{
   friend class CInputPin;

public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CMP3FraunhoferWriter(LPUNKNOWN,HRESULT *);
   ~CMP3FraunhoferWriter();

   // CBaseFilteȑz\bh
   virtual CBasePin *GetPin(int n);
   virtual int GetPinCount();

   // CBaseFilter̃I[o[Ch
   STDMETHODIMP NonDelegatingQueryInterface(REFIID, void **);
   STDMETHODIMP Pause();
   STDMETHODIMP Stop();

   // IFileSinkFilter̃I[o[Ch
   STDMETHODIMP SetFileName(LPCOLESTR, const AM_MEDIA_TYPE *);
   STDMETHODIMP GetCurFile(LPOLESTR *, AM_MEDIA_TYPE *);

   // IMP3FraunhoferInterface
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP CheckBitrate(int);
   STDMETHODIMP CheckBitrate(WAVEFORMATEX *, int);
   STDMETHODIMP GetBitrate(int *);
   STDMETHODIMP SetBitrate(int);

private:

   // [Uϐ
   CCritSec m_Lock;
   CCritSec m_ReceiveLock;
   CInputPin *m_pInputPin;
   CPosPassThru *m_pPosition;
   WCHAR m_awFileName[MAX_PATH];
};
// ------------------------------------------------------------------------------------------------------------------------

#endif _MP3FraunhoferWriter_h_
