/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE MP3FRAUNHOFERWRITER SOURCE CODE.        *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE MP3FRAUNHOFERWRITER SOURCE CODE IS (C) COPYRIGHT 2008 Cocha  *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#include "MP3FraunhoferWriter.h"


// NXt@Ngpev[g
const AMOVIESETUP_MEDIATYPE sudInPinTypes =
{ &MEDIATYPE_Audio, &MEDIASUBTYPE_PCM};

const AMOVIESETUP_PIN sudPins =
{
    L"Input",               // Pin string name
    FALSE,                  // Is it rendered
    FALSE,                  // Is it an output
    FALSE,                  // Allowed none
    FALSE,                  // Likewise many
    &CLSID_NULL,            // Connects to filter
    NULL,                   // Connects to pin
    1,                      // Number of types
    &sudInPinTypes          // Pin information
};

const AMOVIESETUP_FILTER filterInfo =
{
    &CLSID_MP3FraunhoferWriter, // Filter CLSID
    FILTER_NAME,                // String name
    MERIT_DO_NOT_USE,           // Filter merit
    1,                          // Number pins
    &sudPins                    // Pin details
};


CFactoryTemplate g_Templates [] = {
   { FILTER_NAME,      &CLSID_MP3FraunhoferWriter, CMP3FraunhoferWriter::CreateInstance, NULL, &filterInfo },
   { FILTER_PROP_NAME, &CLSID_MP3FraunhoferWriterProps, CProperties::CreateInstance, NULL, NULL}
};

int g_cTemplates = sizeof(g_Templates) / sizeof(g_Templates[0]);

// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::GetInFormat(WAVEFORMATEX *pwf)
{  // ̓s̃tH[}bg擾

   CheckPointer(m_pInputPin, E_POINTER);

   if(m_pInputPin->IsConnected() == FALSE)
      return VFW_E_NOT_CONNECTED;

   return m_pInputPin->GetInFormat(pwf);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::CheckBitrate(int nOutBitrate)
{  // nOutBitratẽrbg[gŏo͂ł邩`FbN

   CheckPointer(m_pInputPin, E_POINTER);

   if(m_pInputPin->IsConnected() == FALSE)
      return VFW_E_NOT_CONNECTED;

   return m_pInputPin->CheckBitrate(nOutBitrate);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::CheckBitrate(WAVEFORMATEX *pInFormat, int nOutBitrate)
{  // pInFormat̓͂̏ꍇɁAnOutBitratẽrbg[gŏo͂ł邩`FbN

   CheckPointer(m_pInputPin, E_POINTER);

   return m_pInputPin->CheckBitrate(pInFormat, nOutBitrate);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::GetBitrate(int *pnOutBitrate)
{  // o͂̃rbg[g擾

   CheckPointer(m_pInputPin, E_POINTER);
   return m_pInputPin->GetBitrate(pnOutBitrate);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::SetBitrate(int nOutBitrate)
{  // o͂̃rbg[gݒ肷

   CheckPointer(m_pInputPin, E_POINTER);
   return m_pInputPin->SetBitrate(nOutBitrate);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::Pause()
{
   CAutoLock cObjectLock(m_pLock);

   HRESULT hr = S_OK;

   if(m_State == State_Stopped)
      hr = m_pInputPin->StartStreaming();

   if(SUCCEEDED(hr))
      hr = CBaseFilter::Pause();

   return hr;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::Stop()
{  // tB^~ꂽꍇɌĂ΂

   CAutoLock cObjectLock(m_pLock);

   if(m_pInputPin != NULL)
      m_pInputPin->Stop();
    
    return CBaseFilter::Stop();
}
// -----------------------------------------------------------------------------------------------------------------------------------
int CMP3FraunhoferWriter::GetPinCount()
{  // s̐Ԃ(tB^[͓̓s1)

   if(m_pInputPin == NULL)
      return 0;

   return 1;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CBasePin *CMP3FraunhoferWriter::GetPin(int n)
{  // nԖڂ̃s̃|C^Ԃ(tB^[͓̓s1)

   if(n == 0)
      return m_pInputPin;

   return NULL;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::NonDelegatingQueryInterface(REFIID riid, void ** ppv)
{  // C^[tFCX擾AQƃJEgCNg

   CheckPointer(ppv, E_POINTER);
   CAutoLock lock(&m_Lock);

   if (riid == IID_IFileSinkFilter)
   {
      return GetInterface((IFileSinkFilter *)this, ppv);
   }
   else if (riid == IID_IMediaPosition || riid == IID_IMediaSeeking)
   {
      if (m_pPosition == NULL) 
      {
         HRESULT hr = S_OK;
         m_pPosition = new CPosPassThru(NAME("MP3FraunhoferWriter Pass Through"), (IUnknown *) GetOwner(), (HRESULT *) &hr, m_pInputPin);

         if (m_pPosition == NULL) 
            return E_OUTOFMEMORY;

         if (FAILED(hr)) 
         {
            delete m_pPosition;
            m_pPosition = NULL;
            return hr;
         }
      }

      return m_pPosition->NonDelegatingQueryInterface(riid, ppv);
   } 
   else if(riid == IID_ISpecifyPropertyPages)
   {
      return GetInterface((ISpecifyPropertyPages *)this, ppv);
   }
   else if(riid == IID_IMP3FraunhoferInterface)
   {
      return GetInterface((IMP3FraunhoferInterface *)this, ppv);
   }

   return CBaseFilter::NonDelegatingQueryInterface(riid, ppv);
}
// -----------------------------------------------------------------------------------------------------------------------------------
CMP3FraunhoferWriter::CMP3FraunhoferWriter(LPUNKNOWN pUnk, HRESULT *phr)
   : CBaseFilter(NAME("MP3FraunhoferWriter"), pUnk, &m_Lock, CLSID_MP3FraunhoferWriter) , m_pPosition(NULL)
{  // RXgN^
   ASSERT(phr);

   ::ZeroMemory(m_awFileName, sizeof(m_awFileName));


   // ̓s̍쐬
   m_pInputPin = new CInputPin(this, GetOwner(), &m_Lock, &m_ReceiveLock, phr);
   if (m_pInputPin == NULL)
   {
      if(phr)
         *phr = E_OUTOFMEMORY;

      return;
   }

   if(phr)
      *phr = S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CMP3FraunhoferWriter::~CMP3FraunhoferWriter()
{  // fXgN^

   if(m_pPosition != NULL)
   {
      delete m_pPosition;
      m_pPosition = NULL;
   }

   // ̓s̉
   if(m_pInputPin != NULL)
   {
      delete m_pInputPin;
      m_pInputPin = NULL;
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::SetFileName(LPCOLESTR pszFileName,const AM_MEDIA_TYPE *pmt)
{  // o̓t@Cݒ肷

   CheckPointer(pszFileName,E_POINTER);
   if(wcslen(pszFileName) > MAX_PATH)
      return ERROR_FILENAME_EXCED_RANGE;

   // łɃt@C݂ȂAt@C폜
   if(::PathFileExists(pszFileName) != FALSE)
   {
      if(::DeleteFile(pszFileName) == FALSE)
         return E_FAIL; // t@C폜Ɏs
   }

   // t@C쐬ł邩`FbN
   HANDLE hFile = NULL;
   hFile = ::CreateFile(pszFileName, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, (DWORD)0, NULL);
   if(hFile == INVALID_HANDLE_VALUE)
      return E_FAIL; // t@C쐬Ɏs

   ::CloseHandle(hFile);

   // t@Ci[Ă
   lstrcpyW(m_awFileName, pszFileName);
   m_pInputPin->SetFileName(pszFileName);

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::GetCurFile(LPOLESTR * ppszFileName,AM_MEDIA_TYPE *pmt)
{  // o̓t@C擾

   CheckPointer(ppszFileName, E_POINTER);
   *ppszFileName = NULL;

   if (m_awFileName != NULL) 
   {
      *ppszFileName = (LPOLESTR)
      QzTaskMemAlloc(sizeof(WCHAR) * (1+lstrlenW(m_awFileName)));

        if (*ppszFileName != NULL) 
            lstrcpyW(*ppszFileName, m_awFileName);
   }

   if(pmt != NULL)
   {
      ZeroMemory(pmt, sizeof(*pmt));
      pmt->majortype = MEDIATYPE_NULL;
      pmt->subtype = MEDIASUBTYPE_NULL;
   }

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::GetPages(CAUUID *pPages)
{  // vpeBy[W̐ݒ

   CheckPointer(pPages, E_POINTER);

   pPages->cElems = 1;
   pPages->pElems = (GUID*)CoTaskMemAlloc(sizeof(GUID));

   if(pPages->pElems == NULL)
      return E_OUTOFMEMORY;

   pPages->pElems[0] = CLSID_MP3FraunhoferWriterProps;

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CUnknown * WINAPI CMP3FraunhoferWriter::CreateInstance(LPUNKNOWN punk, HRESULT *phr)
{  // IuWFNg쐬

   ASSERT(phr);
    
   CMP3FraunhoferWriter *pNewObject = new CMP3FraunhoferWriter(punk, phr);
   if (pNewObject == NULL)
   {
      if(phr != NULL)
         *phr = E_OUTOFMEMORY;
   }

   return dynamic_cast<CUnknown *>(pNewObject);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDAPI DllRegisterServer()
{
   return AMovieDllRegisterServer2(TRUE);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDAPI DllUnregisterServer()
{
   return AMovieDllRegisterServer2(FALSE);
}
// -----------------------------------------------------------------------------------------------------------------------------------
// DllEntryPoint
extern "C" {
	BOOL WINAPI DllEntryPoint(HINSTANCE, ULONG, LPVOID);
};

BOOL APIENTRY DllMain(HANDLE hModule, DWORD dwReason, LPVOID lpReserved)
{
   return DllEntryPoint((HINSTANCE)(hModule), dwReason, lpReserved);
}
