/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE MP3FRAUNHOFERWRITER SOURCE CODE.        *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE MP3FRAUNHOFERWRITER SOURCE CODE IS (C) COPYRIGHT 2008 Cocha  *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#include "MP3FraunhoferWriter.h"
#include <commctrl.h>

// ------------------------------------------------------------------------------------------------------------------------
HRESULT CProperties::OnConnect(IUnknown *pUnknown)
{  // vpeBy[W쐬ɌĂяo

   CheckPointer(pUnknown, E_POINTER);

   HRESULT hr;

   // IMP3FraunhoferInterface̍쐬
   hr = pUnknown->QueryInterface(IID_IMP3FraunhoferInterface, (void **)&m_pMP3FraunhoferInterface);
   if(FAILED(hr))
      return E_NOINTERFACE;

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CProperties::OnActivate(void)
{  // vpeBy[W쐬ɌĂяo

   HRESULT hr;
   int i, nCount;
   WAVEFORMATEX wf;
   WCHAR wText[16];

   CheckPointer(m_pMP3FraunhoferInterface, E_NOINTERFACE);

   // AdvłProł̃`FbN
   {
      wf.wFormatTag = WAVE_FORMAT_PCM;
      wf.cbSize = 0;
      wf.wBitsPerSample = 16;
      wf.nChannels = 2;
      wf.nBlockAlign = wf.nChannels * 2;

      wf.nSamplesPerSec = 44100;
      wf.nAvgBytesPerSec = wf.nBlockAlign * wf.nSamplesPerSec;

      hr = m_pMP3FraunhoferInterface->CheckBitrate(&wf, 128000);
      if(hr == S_OK)
      {
         ::EnableWindow(::GetDlgItem(m_Dlg, IDC_STATIC_ADV), FALSE);
         ::EnableWindow(::GetDlgItem(m_Dlg, IDC_STATIC_PRO), TRUE);
      }
      else
      {
         ::EnableWindow(::GetDlgItem(m_Dlg, IDC_STATIC_ADV), TRUE);
         ::EnableWindow(::GetDlgItem(m_Dlg, IDC_STATIC_PRO), FALSE);
      }
   }

   // IDC_COMBO_BITRATE̍ڐ擾
   nCount = ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_BITRATE), CB_GETCOUNT, 0, 0);


   hr = m_pMP3FraunhoferInterface->GetInFormat(&wf);
   if(hr != S_OK)
   {  // ̓sڑĂȂꍇ
      ::SetDlgItemText(m_Dlg, IDC_STATIC_SAMPLINGRATE, TEXT("̓sڑ"));
      ::SetDlgItemText(m_Dlg, IDC_STATIC_BITSPERSAMPLE, TEXT(""));
      ::SetDlgItemText(m_Dlg, IDC_STATIC_CHANNELS, TEXT(""));

      for(i=0;i<nCount;i++)
         ::SendMessage(::GetDlgItem(this->m_Dlg, IDC_COMBO_BITRATE), CB_DELETESTRING, 0, 0);

      return S_OK;
   }

   // ̓s̏\
   ::wsprintf(wText, TEXT("%dHz"), wf.nSamplesPerSec);
   ::SetDlgItemText(m_Dlg, IDC_STATIC_SAMPLINGRATE, wText);

   if(wf.wFormatTag == WAVE_FORMAT_PCM)
      ::wsprintf(wText, TEXT("%drbg"), wf.wBitsPerSample);
   else
      ::wsprintf(wText, TEXT("%dHz (FLOAT)"), wf.wBitsPerSample);

   ::SetDlgItemText(m_Dlg, IDC_STATIC_BITSPERSAMPLE, wText);

   ::wsprintf(wText, TEXT("%dch"), wf.nChannels);
   ::SetDlgItemText(m_Dlg, IDC_STATIC_CHANNELS, wText);


   if(nCount <= 0)
   {  // IDC_COMBO_SAMPLINGRATECOMBOBOX̏

      int anBitrate[19] = { 8000, 16000, 18000, 20000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000};

      for(i=0;i<19;i++)
      {
         hr = m_pMP3FraunhoferInterface->CheckBitrate(&wf, anBitrate[i]);
         if(hr == S_OK)
         {
            ::wsprintf(wText, TEXT("%d bps"), anBitrate[i]);
            ::SendMessage(::GetDlgItem(this->m_Dlg, IDC_COMBO_BITRATE), CB_ADDSTRING, 0, (LPARAM)wText);
         }
      }
   }

   // łɏo͐ݒ肪ĂȂAR{{bNẌʒu킹
   int nBitrate;
   hr = m_pMP3FraunhoferInterface->GetBitrate(&nBitrate);
   if(hr == S_OK && nBitrate != 0)
   {
      WCHAR wText[32], wComboText[32];
      ::wsprintf(wText, TEXT("%d bps"), nBitrate);

      nCount = ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_BITRATE), CB_GETCOUNT, 0, 0);

      for(i=0;i<nCount;i++)
      {
         ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_BITRATE), CB_GETLBTEXT, (WPARAM)i, (LPARAM)wComboText);

         if(::lstrcmp(wComboText, wText) == 0)
         {
            ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_BITRATE), CB_SETCURSEL, (WPARAM)i, (LPARAM)0);
            return S_OK;
         }
      }
   }

   ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_BITRATE), CB_SETCURSEL, (WPARAM)0, 0);

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
BOOL CProperties::OnReceiveMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{  // bZ[WvV[W

   switch (uMsg)
   {
   case WM_COMMAND:

      switch(LOWORD(wParam))
      {
      case IDC_COMBO_BITRATE:
         m_bDirty = TRUE;
         break;
      }
   }


   return CBasePropertyPage::OnReceiveMessage(m_Dlg, uMsg, wParam, lParam);
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CProperties::OnApplyChanges(void)
{  // OK{^ꂽƂɌĂ΂

   if(m_pMP3FraunhoferInterface != NULL)
   {  // o͐ݒtB^ɑ

      int anBitrate[19] = { 8000, 16000, 18000, 20000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000};

      WCHAR wComboText[32], wText[32];

      ::GetDlgItemText(m_Dlg, IDC_COMBO_BITRATE, wComboText, 32);

      for(int i=0;i<19;i++)
      {
         ::wsprintf(wText, TEXT("%d bps"), anBitrate[i]);

         if(::lstrcmp(wComboText, wText) == 0)
         {
            m_pMP3FraunhoferInterface->SetBitrate(anBitrate[i]);
            return S_OK;
         }
      }
   }

   return S_FALSE;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CProperties::OnDisconnect(void)
{  // vpeBy[WƂɌĂ΂

   if(m_pMP3FraunhoferInterface != NULL)
   {
      m_pMP3FraunhoferInterface->Release();
      m_pMP3FraunhoferInterface = NULL;
   }

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
CUnknown * WINAPI CProperties::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
   ASSERT(phr);

   CUnknown *punk = new CProperties(lpunk, phr);

   if(punk == NULL)
   {
      if (phr)
         *phr = E_OUTOFMEMORY;
   }

   return punk;
}
// ------------------------------------------------------------------------------------------------------------------------
CProperties::CProperties(LPUNKNOWN pUnk, HRESULT *phr) :
   CBasePropertyPage(NAME("MP3 Fraunhofer Writer Property Page"), pUnk, IDD_MP3FRAUNHOFERENCPROP, IDS_TITLE)
{  // RXgN^

   InitCommonControls();
   m_pMP3FraunhoferInterface = NULL;
}
// ------------------------------------------------------------------------------------------------------------------------
