/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE MP3FRAUNHOFERENC SOURCE CODE.           *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE MP3FRAUNHOFERENC SOURCE CODE IS (C) COPYRIGHT 2008 Cocha     *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#ifndef __MP3FraunhoferEnc_h__
#define __MP3FraunhoferEnc_h__

#include <windows.h>
#include <streams.h>
#include <mmreg.h>
#include <msacm.h>
#include "Resource/Resource.h"

#define SAFE_RELEASE(p) { if(p!=NULL) { (p)->Release(); (p)=NULL; } }

// tB^̖O
#define FILTER_NAME L"MP3 Fraunhofer Enc"
#define FILTER_PROP_NAME L"MP3 Fraunhofer Enc Props"

struct ENUMDATA
{
   int nBitrate;
   HACMDRIVERID hadid;
   WAVEFORMATEX inFormat;
   MPEGLAYER3WAVEFORMAT outFormat;
};



// {1A73C189-AB7C-4b1f-B3BB-FDA96A659684}
static const GUID CLSID_MP3FraunhoferEnc = 
{ 0x1a73c189, 0xab7c, 0x4b1f, { 0xb3, 0xbb, 0xfd, 0xa9, 0x6a, 0x65, 0x96, 0x84 } };

// {85476B98-CD42-4633-B7CF-F6F02F69FD5E}
static const GUID CLSID_MP3FraunhoferEncProps = 
{ 0x85476b98, 0xcd42, 0x4633, { 0xb7, 0xcf, 0xf6, 0xf0, 0x2f, 0x69, 0xfd, 0x5e } };

// {669A392D-DD0E-4c92-8E73-469073964D4B}
static const GUID IID_IMP3FraunhoferInterface = 
{ 0x669a392d, 0xdd0e, 0x4c92, { 0x8e, 0x73, 0x46, 0x90, 0x73, 0x96, 0x4d, 0x4b } };


static const GUID WMMEDIASUBTYPE_MP3 = 
{ 0x00000055, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } }; 

// ------------------------------------------------------------------------------------------------------------------------
// o͐ݒC^[tFCX
__interface
__declspec(uuid("{DBE16C61-1BAD-4373-A382-4BCCAD99EB91}"))
IMP3FraunhoferInterface : public IUnknown
{
public:
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP CheckBitrate(int);
   STDMETHODIMP CheckBitrate(WAVEFORMATEX *, int);
   STDMETHODIMP GetBitrate(int *);
   STDMETHODIMP SetBitrate(int);
};
// ------------------------------------------------------------------------------------------------------------------------
class CAcmFraunhofer
{
public:

   // RXgN^ƃfXgN^
   CAcmFraunhofer();
   ~CAcmFraunhofer();

   // R[obN֐
   static BOOL CALLBACK AcmDriverEnumCallback(HACMDRIVERID, DWORD, DWORD);


   // [U֐
   HRESULT CheckFormat(WAVEFORMATEX *, int);
   HRESULT SetInBufferSize(int);
   int GetOutBufferSize(WAVEFORMATEX *, int, int);
   HRESULT GetOutFormat(WAVEFORMATEX *, int, MPEGLAYER3WAVEFORMAT *);
   HRESULT ConvertInit(WAVEFORMATEX *, int, MPEGLAYER3WAVEFORMAT *, int *, int);
   HRESULT Convert(BYTE *, int, BYTE *, int *);
   HRESULT ConvertEnd(BYTE *, int *);

private:

   // [Uϐ
   HACMDRIVER m_hDriver;
   HACMSTREAM m_hStream;
   ACMSTREAMHEADER m_acmHeader;

   ENUMDATA m_enumData;

   BYTE *m_pInBuffer;
   BYTE *m_pOutBuffer;
};
// -----------------------------------------------------------------------------------------------------------------------------------
class CProperties : public CBasePropertyPage
{
public:
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

private:

   // RXgN^
   CProperties(LPUNKNOWN, HRESULT *);

   // CBasePropertyPagẽI[o[Ch
   HRESULT OnConnect(IUnknown *);
   HRESULT OnActivate(void);
   BOOL OnReceiveMessage(HWND, UINT, WPARAM, LPARAM);
   HRESULT OnApplyChanges(void);
   HRESULT OnDisconnect(void);

   // gpϐ
   IMP3FraunhoferInterface *m_pMP3FraunhoferInterface;
};
// ------------------------------------------------------------------------------------------------------------------------
class CMP3FraunhoferEnc : public CTransformFilter, public ISpecifyPropertyPages, public IMP3FraunhoferInterface
{
   friend class CAcmFraunhofer;
   friend class CProperties;

public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CMP3FraunhoferEnc(LPUNKNOWN pUnk,HRESULT *phr);
   virtual ~CMP3FraunhoferEnc();

   // IuWFNg쐬֐
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   // ISpecifyPropertyPages̃I[o[Ch
   STDMETHODIMP GetPages(CAUUID *);

   // CTransformFilteȑz\bh
   HRESULT CheckInputType(const CMediaType *);
   HRESULT CheckTransform(const CMediaType *,const CMediaType *);
   HRESULT GetMediaType(int iPosition,CMediaType *);
   HRESULT DecideBufferSize(IMemAllocator *, ALLOCATOR_PROPERTIES *);

   // CTransformFilter̃I[o[Ch
   HRESULT StartStreaming(void);
   HRESULT Receive(IMediaSample *);
   HRESULT StopStreaming();
   HRESULT EndOfStream(void);
   STDMETHODIMP NonDelegatingQueryInterface(REFIID, void **);

   // IMP3FraunhoferInterface
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP CheckBitrate(int);
   STDMETHODIMP CheckBitrate(WAVEFORMATEX *, int);
   STDMETHODIMP GetBitrate(int *);
   STDMETHODIMP SetBitrate(int);

private:

   // [Uϐ
   bool m_bProfessional;
   int m_nBitrate;
   CCritSec m_myLock;
   CAcmFraunhofer *m_pAcmFraunhofer;

   WAVEFORMATEX m_inFormat;
   MPEGLAYER3WAVEFORMAT m_outFormat;

   int m_nInBufferSize;
   int m_nOutBufferSize;
};

// -----------------------------------------------------------------------------------------------------------------------------------
#endif __MP3FraunhoferEnc_h__
