/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE WAVCONFILTER SOURCE CODE.               *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE WAVCONFILTER SOURCE CODE IS (C) COPYRIGHT 2008 Cocha         *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#ifndef __WavConFilter_h__
#define __WavConFilter_h__

// {EFBF44B7-BB1F-48c8-BA59-EB9803579B1E}
static const GUID CLSID_WavConFilter = 
{ 0xefbf44b7, 0xbb1f, 0x48c8, { 0xba, 0x59, 0xeb, 0x98, 0x3, 0x57, 0x9b, 0x1e } };

// {1C3704B6-6827-4a4e-9E68-9997CC0767B6}
static const GUID CLSID_WavConProps = 
{ 0x1C3704B6, 0x6827, 0x4a4e, { 0x9E, 0x68, 0x99, 0x97, 0xCC, 0x07, 0x67, 0xB6} };

// {BDA4CAB0-2EB2-42cb-A631-E89E82352DD1}
static const GUID IID_IWavConInterface = 
{ 0xbda4cab0, 0x2eb2, 0x42cb, { 0xa6, 0x31, 0xe8, 0x9e, 0x82, 0x35, 0x2d, 0xd1} };

// ------------------------------------------------------------------------------------------------------------------------
// o͐ݒC^[tFCX
__interface
__declspec(uuid("{DBE16C61-1BAD-4373-A382-4BCCAD99EB91}"))
IWavConInterface : public IUnknown
{
public:
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP GetOutFormat(WAVEFORMATEX *);
   STDMETHODIMP SetOutFormat(WAVEFORMATEX *);
   STDMETHODIMP SetQuality(int);
};
// ------------------------------------------------------------------------------------------------------------------------

#endif __WavConFilter_h__
