/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE WAVCONFILTER SOURCE CODE.               *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE WAVCONFILTER SOURCE CODE IS (C) COPYRIGHT 2008 Cocha         *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#ifndef __WavConFilter_h__
#define __WavConFilter_h__

#include <windows.h>
#include <streams.h>
#include <math.h>
#include "Resource/Resource.h"

#define WAVE_FORMAT_IEEE_FLOAT 0x0003

#define SAFE_RELEASE(p) { if(p!=NULL) { (p)->Release(); (p)=NULL; } }
struct SmplData{double l,r;};


// tB^̖O
#define FILTER_NAME L"WavConFilter"
#define FILTER_PROP_NAME L"WavConFilterProps"


// {EFBF44B7-BB1F-48c8-BA59-EB9803579B1E}
static const GUID CLSID_WavConFilter = 
{ 0xefbf44b7, 0xbb1f, 0x48c8, { 0xba, 0x59, 0xeb, 0x98, 0x3, 0x57, 0x9b, 0x1e } };

// {1C3704B6-6827-4a4e-9E68-9997CC0767B6}
static const GUID CLSID_WavConProps = 
{ 0x1C3704B6, 0x6827, 0x4a4e, { 0x9E, 0x68, 0x99, 0x97, 0xCC, 0x07, 0x67, 0xB6} };

// {BDA4CAB0-2EB2-42cb-A631-E89E82352DD1}
static const GUID IID_IWavConInterface = 
{ 0xbda4cab0, 0x2eb2, 0x42cb, { 0xa6, 0x31, 0xe8, 0x9e, 0x82, 0x35, 0x2d, 0xd1} };


// ------------------------------------------------------------------------------------------------------------------------
// o͐ݒC^[tFCX
__interface
__declspec(uuid("{DBE16C61-1BAD-4373-A382-4BCCAD99EB91}"))
IWavConInterface : public IUnknown
{
public:
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP GetOutFormat(WAVEFORMATEX *);
   STDMETHODIMP SetOutFormat(WAVEFORMATEX *);
   STDMETHODIMP SetQuality(int);
};
// ------------------------------------------------------------------------------------------------------------------------
class CSamplingConv
{
public:

   // [U֐
   HRESULT ConvertInit(WAVEFORMATEX *, WAVEFORMATEX *, int);
   void Convert(struct SmplData *, int, BYTE *, int *);
   void ConvertEnd(struct SmplData *, int, BYTE *, int *);

private:

   // [U֐
   double bessel0(double);

   // [Uϐ
   WAVEFORMATEX m_inFormat;
   WAVEFORMATEX m_outFormat;

   int iptr;
	int ismd, ismr;
   long firodrv;
   int isrm, osrm;
   int sptr, sptrr, eptr, eptrr;
   double m_hfir[65536];
   double m_dMaxData, m_dMinData;
   double m_dRatioPlus, m_dRatioMinus;
};
// -----------------------------------------------------------------------------------------------------------------------------------
class CChannelConv
{
public:

   // [U֐
   HRESULT SetFormat(WAVEFORMATEX *, WAVEFORMATEX *);
   HRESULT Convert(BYTE *, int, BYTE *, int *);
   HRESULT Convert(BYTE *, int, int *);

private:

   // [Uϐ
   WAVEFORMATEX m_inFormat;
   WAVEFORMATEX m_outFormat;

};
// -----------------------------------------------------------------------------------------------------------------------------------
class CBitConv
{
public:

   // [U֐
   HRESULT SetFormat(WAVEFORMATEX *, WAVEFORMATEX *);
   HRESULT Convert(BYTE *, int, BYTE *, int *);

private:

   // [Uϐ
   WAVEFORMATEX m_inFormat;
   WAVEFORMATEX m_outFormat;
   double m_dRatio;

   // [U֐
   HRESULT Convert8(BYTE *, int, BYTE *, int *);
   HRESULT Convert16(BYTE *, int, BYTE *, int *);
   HRESULT Convert24(BYTE *, int, BYTE *, int *);
   HRESULT Convert32i(BYTE *, int, BYTE *, int *);
   HRESULT Convert32f(float *, int, BYTE *, int *);
   HRESULT Convert64(double *, int, BYTE *, int *);
};
// -----------------------------------------------------------------------------------------------------------------------------------
class CWavConProperties : public CBasePropertyPage
{
public:
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

private:

   // RXgN^
   CWavConProperties(LPUNKNOWN, HRESULT *);

   // CBasePropertyPagẽI[o[Ch
   HRESULT OnConnect(IUnknown *);
   HRESULT OnActivate(void);
   BOOL OnReceiveMessage(HWND, UINT, WPARAM, LPARAM);
   HRESULT OnApplyChanges(void);
   HRESULT OnDisconnect(void);

   // gpϐ
   IWavConInterface *m_pWavConInterface;

   int m_nIndexSamplingRate;
   int m_nIndexBitsPerSample;
   int m_nIndexChannels;
};
// ------------------------------------------------------------------------------------------------------------------------
class CWavConFilter : public CTransformFilter, public ISpecifyPropertyPages, public IWavConInterface
{
public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CWavConFilter(LPUNKNOWN pUnk,HRESULT *phr);
   virtual ~CWavConFilter();

   // IuWFNg쐬֐
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   // ISpecifyPropertyPages̃I[o[Ch
   STDMETHODIMP GetPages(CAUUID *);

   // CTransformFilteȑz\bh
   HRESULT CheckInputType(const CMediaType *);
   HRESULT CheckTransform(const CMediaType *,const CMediaType *);
   HRESULT GetMediaType(int iPosition,CMediaType *);
   HRESULT DecideBufferSize(IMemAllocator *, ALLOCATOR_PROPERTIES *);

   // CTransformFilter̃I[o[Ch
   HRESULT StartStreaming(void);
   HRESULT Receive(IMediaSample *);
   HRESULT StopStreaming();
   HRESULT EndOfStream(void);
   STDMETHODIMP NonDelegatingQueryInterface(REFIID, void **);

   // IWavConInterface
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP GetOutFormat(WAVEFORMATEX *);
   STDMETHODIMP SetOutFormat(WAVEFORMATEX *);
   STDMETHODIMP SetQuality(int);

protected:

private:

   // [U֐
   void ConvertToDouble(BYTE *, int);

   // [Uϐ
   bool m_bSetOutFormat;
   int m_nAccurate;
   WAVEFORMATEX m_inFormat;
   WAVEFORMATEX m_outFormat;
   CBitConv *m_pBitConv;
   CCritSec m_myLock;
   CChannelConv *m_pChannelConv;
   CSamplingConv *m_pSamplingConv;
   int m_nSmplSize;
   struct SmplData *m_smpld;
};

#endif __WavConFilter_h__
