/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE WAVCONFILTER SOURCE CODE.               *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE WAVCONFILTER SOURCE CODE IS (C) COPYRIGHT 2008 Cocha         *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#include "WavConFilter.h"

// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CChannelConv::SetFormat(WAVEFORMATEX *pInFormat, WAVEFORMATEX *pOutFormat)
{
   // ͂Əo̓tH[}bgi[Ă
   ::CopyMemory(&m_inFormat, pInFormat, sizeof(m_inFormat));
   ::CopyMemory(&m_outFormat, pOutFormat, sizeof(m_outFormat));

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CChannelConv::Convert(BYTE *pInData, int nInLength, BYTE *pOutData, int *pnOutLength)
{  // pInDatapOutDataɃ`lϊ

   int i, j;

   if(m_inFormat.nChannels == 1 && m_outFormat.nChannels == 2)
   {  // m  XeI

      int nInBytesPerSample = m_inFormat.wBitsPerSample / 8;
      int nOutBytesPerSample = 2 * m_outFormat.wBitsPerSample / 8;

      for(i=0,j=0; i<nInLength; i+=nInBytesPerSample,j+=nOutBytesPerSample)
      {
         ::CopyMemory(&pOutData[j], &pInData[i], nInBytesPerSample);
         ::CopyMemory(&pOutData[j+nInBytesPerSample], &pInData[i], nInBytesPerSample);
      }

      *pnOutLength = j;
      return S_OK;
   }

   if(m_inFormat.nChannels == 2 && m_outFormat.nChannels == 1)
   {  // XeI  m

      if(m_inFormat.wFormatTag == WAVE_FORMAT_PCM)
      {
         if(m_inFormat.wBitsPerSample == 8)
         {  // 8bit̏ꍇ
            for(i=0,j=0; i<nInLength; i+=2,j++)
            {
               pOutData[j] = (pInData[i] + pInData[i+1]) >> 1;
            }

            *pnOutLength = j;
            return S_OK;
         }
         else if(m_inFormat.wBitsPerSample == 16)
         {  // 16bit̏ꍇ
            short sData[2];

            for(i=0,j=0; i<nInLength; i+=4,j+=2)
            {
               ::CopyMemory(&sData[0], &pInData[i], 4);
               sData[0] = (sData[0] + sData[1]) / 2;
               ::CopyMemory(&pOutData[j], &sData[0], 2);
            }

            *pnOutLength = j;
            return S_OK;
         }
         else if(m_inFormat.wBitsPerSample == 24)
         {  // 24bit̏ꍇ

            int nData[2];

            for(i=0,j=0; i<nInLength; i+=6,j+=3)
            {

               nData[0] = (pInData[i+2] << 16) | (pInData[i+1] << 8) | pInData[i];
               if(pInData[i+2] & 0x80)
                  nData[0] |= 0xff000000;

               nData[1] = (pInData[i+5] << 16) | (pInData[i+4] << 8) | pInData[i+3];
               if(pInData[i+5] & 0x80)
                  nData[1] |= 0xff000000;

               nData[0] = (nData[0] + nData[1]) / 2;

               pOutData[j] = (nData[0] & 0x000000ff);
               pOutData[j+1] = (nData[0] & 0x0000ff00) >> 8;
               pOutData[j+2] = (nData[0] & 0x00ff0000) >> 16;
            }

            *pnOutLength = j;
            return S_OK;
         }
         else if(m_inFormat.wBitsPerSample == 32)
         {  // 32bit()̏ꍇ

            int nData[2];

            for(i=0,j=0; i<nInLength; i+=8,j+=4)
            {
               ::CopyMemory(&nData[0], &pInData[i], 8);
               nData[0] = nData[0] / 2 + nData[1] / 2;
               ::CopyMemory(&pOutData[j], &nData[0], 4);
            }

            *pnOutLength = j;
            return S_OK;
         }
      }
      else if(m_inFormat.wFormatTag == WAVE_FORMAT_IEEE_FLOAT)
      {
         if(m_inFormat.wBitsPerSample == 32)
         {  // 32bit()̏ꍇ
            float fData[2];

            for(i=0,j=0; i<nInLength; i+=8,j+=4)
            {
               ::CopyMemory(&fData[0], &pInData[i], 8);
               fData[0] = (fData[0] + fData[1]) / 2;
               ::CopyMemory(&pOutData[j], &fData[0], 4);
            }

            *pnOutLength = j;
            return S_OK;
         }
         else if(m_inFormat.wBitsPerSample == 64)
         {  // 64bit̏ꍇ
            double dData[2];

            for(i=0,j=0; i<nInLength; i+=16,j+=8)
            {
               ::CopyMemory(&dData[0], &pInData[i], 16);
               dData[0] = (dData[0] + dData[1]) / 2;
               ::CopyMemory(&pOutData[j], &dData[0], 8);
            }

            *pnOutLength = j;
            return S_OK;
         }
      }
   }

   return E_FAIL;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CChannelConv::Convert(BYTE *pInData, int nInLength, int *pnOutLength)
{  // `lϊipInData𒼐ڏj

   // ̓rbgƃ`lϊꍇɂ̂ݎg֐

   // mXeIȂArbgϊĂ`lϊ
   // XeImȂA`lϊĂrbgϊ

   int i, j;

   if(m_inFormat.nChannels == 1 && m_outFormat.nChannels == 2)
   {  // m  XeI

      int nInBytesPerSample = m_outFormat.wBitsPerSample / 8;
      int nOutBytesPerSample = 2 * nInBytesPerSample;

      for(i=(nInLength-nInBytesPerSample),j=(nInLength*2-nOutBytesPerSample); i>=0; i-=nInBytesPerSample,j-=nOutBytesPerSample)
      {  // pInDatǎ납f[^Ă

         ::MoveMemory(&pInData[j], &pInData[i], nInBytesPerSample);
         ::MoveMemory(&pInData[j+nInBytesPerSample], &pInData[i], nInBytesPerSample);
      }

      *pnOutLength = nInLength * 2;
      return S_OK;
   }
   else if(m_inFormat.nChannels == 2 && m_outFormat.nChannels == 1)
   {  // XeI  m

      if(m_inFormat.wFormatTag == WAVE_FORMAT_PCM)
      {
         if(m_inFormat.wBitsPerSample == 8)
         {  // 8bit̏ꍇ
            for(i=0,j=0; i<nInLength; i+=2,j++)
            {  // pInData̐擪f[^Ă
               pInData[j] = (pInData[i] + pInData[i+1]) >> 1;
            }

            *pnOutLength = j;
            return S_OK;
         }
         else if(m_inFormat.wBitsPerSample == 16)
         {  // 16bit̏ꍇ
            short sData[2];

            for(i=0,j=0; i<nInLength; i+=4,j+=2)
            {  // pInData̐擪f[^Ă
               ::CopyMemory(&sData[0], &pInData[i], 4);
               sData[0] = (sData[0] + sData[1]) / 2;
               ::CopyMemory(&pInData[j], &sData[0], 2);
            }

            *pnOutLength = j;
            return S_OK;
         }
         else if(m_inFormat.wBitsPerSample == 24)
         {  // 24bit̏ꍇ

            int nData[2];

            for(i=0,j=0; i<nInLength; i+=6,j+=3)
            {  // pInData̐擪f[^Ă

               nData[0] = (pInData[i+2] << 16) | (pInData[i+1] << 8) | pInData[i];
               if(pInData[i+2] & 0x80)
                  nData[0] |= 0xff000000;

               nData[1] = (pInData[i+5] << 16) | (pInData[i+4] << 8) | pInData[i+3];
               if(pInData[i+5] & 0x80)
                  nData[1] |= 0xff000000;

               nData[0] = (nData[0] + nData[1]) / 2;

               pInData[j] = (nData[0] & 0x000000ff);
               pInData[j+1] = (nData[0] & 0x0000ff00) >> 8;
               pInData[j+2] = (nData[0] & 0x00ff0000) >> 16;
            }

            *pnOutLength = j;
            return S_OK;
         }
         else if(m_inFormat.wBitsPerSample == 32)
         {  // 32bit()̏ꍇ
            int nData[2];

            for(i=0,j=0; i<nInLength; i+=8,j+=4)
            {  // pInData̐擪f[^Ă
               ::CopyMemory(&nData[0], &pInData[i], 8);
               nData[0] = nData[0]/2 + nData[1]/2;
               ::CopyMemory(&pInData[j], &nData[0], 4);
            }

            *pnOutLength = j;
            return S_OK;
         }
      }
      else if(m_inFormat.wFormatTag == WAVE_FORMAT_IEEE_FLOAT)
      {
         if(m_inFormat.wBitsPerSample == 32)
         {  // 32bit()̏ꍇ
            float fData[2];

            for(i=0,j=0; i<nInLength; i+=8,j+=4)
            {  // pInData̐擪f[^Ă
               ::CopyMemory(&fData[0], &pInData[i], 8);
               fData[0] = (fData[0] + fData[1]) / 2;
               ::CopyMemory(&pInData[j], &fData[0], 4);
            }

            *pnOutLength = j;
            return S_OK;
         }
         else if(m_inFormat.wBitsPerSample == 64)
         {  // 64bit̏ꍇ
            double dData[2];

            for(i=0,j=0; i<nInLength; i+=16,j+=8)
            {  // pInData̐擪f[^Ă
               ::CopyMemory(&dData[0], &pInData[i], 16);
               dData[0] = (dData[0] + dData[1]) / 2;
               ::CopyMemory(&pInData[j], &dData[0], 8);
            }

            *pnOutLength = j;
            return S_OK;
         }
      }
   }

   return E_FAIL;
}
// -----------------------------------------------------------------------------------------------------------------------------------
