/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE aoTuvWriter SOURCE CODE.                *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE OggVorbis SOURCE CODE IS (C) COPYRIGHT 1994-2007             *
 * by the Xiph.Org Foundation http://www.xiph.org/                  *
 *                                                                  *
 * THE aoTuv SOURCE CODE IS (C) COPYRIGHT 2003-2008 Aoyumi          *
 * http://www.geocities.jp/aoyoume/aotuv/                           *
 *                                                                  *
 * THE aoTuvWriter SOURCE CODE IS (C) COPYRIGHT 2008 Cocha          *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#ifndef _aoTuvWriter_h_
#define _aoTuvWriter_h_

#include <windows.h>
#include <shlwapi.h>
#include <time.h>
#include <streams.h>
#include "include/vorbisenc.h"


#define ENCODE_BUFFER_SIZE 32768
#define FILTER_NAME L"aoTuv Writer"
#define FILTER_PROP_NAME L"aoTuv Property Page"


// {BCA97B10-FF13-4818-ACB7-C279DF3A55FF}
static const GUID CLSID_aoTuvWriter =
{ 0xbca97b10, 0xff13, 0x4818, { 0xac, 0xb7, 0xc2, 0x79, 0xdf, 0x3a, 0x55, 0xff } };

// {CDF9EBCB-701A-4fae-A26C-0BE4D74ABF55}
static const GUID CLSID_aoTuvWriterProp = 
{ 0xcdf9ebcb, 0x701a, 0x4fae, { 0xa2, 0x6c, 0x0b, 0xe4, 0xd7, 0x4a, 0xbf, 0x55 } };

// {BD7DAEC2-193E-4a6a-B9D3-476D8C929B35}
static const GUID IID_IaoTuvInterface = 
{ 0xbd7daec2, 0x193e, 0x4a6a, { 0xb9, 0xd3, 0x47, 0x6d, 0x8c, 0x92, 0x9b, 0x35 } };

typedef struct tagVORBISFORMAT
{
	WORD  nChannels;
	long  nSamplesPerSec;
	long  nMinBitsPerSec;
	long  nAvgBitsPerSec;
	long  nMaxBitsPerSec;
	float fQuality;
} VORBISFORMAT;

typedef struct tagVORBISTAG
{
   char acTitle[256];
   char acArtist[256];
   char acAlbum[256];
   char acTrackNumber[256];
   char acDate[256];
   char acGenre[256];
   char acComment[256];
} VORBISTAG;

// ------------------------------------------------------------------------------------------------------------------------
// GR[hݒC^[tFCX
__interface
__declspec(uuid("{16F5105B-7322-4a62-9284-992DD186F6A1}"))
IaoTuvInterface : public IUnknown
{
public:
   STDMETHODIMP SetVorbisFormat(void *);
   STDMETHODIMP GetVorbisFormat(void *);
   STDMETHODIMP SetVorbisTag(void *);
};
// ------------------------------------------------------------------------------------------------------------------------
class CaoTuvEncode
{
public:

   // RXgN^ƃfXgN^
   CaoTuvEncode();
   ~CaoTuvEncode();

   // [U֐
   HRESULT EncodeInit(WCHAR *, VORBISFORMAT *, VORBISTAG *);
   HRESULT Encode(int);
   HRESULT Receive(short *, int);
   HRESULT EncodeEnd();
   HRESULT SetFileName(WCHAR *);

private:

   // [U֐
   void SJIStoUTF8(char *, int);

   // gpϐ
   ogg_stream_state m_os;
   ogg_page         m_og;
   ogg_packet       m_op;
   vorbis_info      m_vi;
   vorbis_comment   m_vc;
   vorbis_dsp_state m_vd;
   vorbis_block     m_vb;

   HANDLE m_hFile;
   int m_nChannels;
};
// ------------------------------------------------------------------------------------------------------------------------
class CaoTuvProperties : public CBasePropertyPage
{
public:
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

private:

   // RXgN^
   CaoTuvProperties(LPUNKNOWN, HRESULT *);

   // CBasePropertyPagẽI[o[Ch
   HRESULT OnConnect(IUnknown *);
   HRESULT OnActivate(void);
   BOOL OnReceiveMessage(HWND, UINT, WPARAM, LPARAM);
   HRESULT OnApplyChanges(void);
   HRESULT OnDisconnect(void);


   // gpϐ
   IaoTuvInterface *m_paoTuvInterface;

   bool m_bCBR;
   int m_nIndexCBR;
   int m_nIndexVBR;
};
// ------------------------------------------------------------------------------------------------------------------------
class CInputPin : public CRenderedInputPin
{
   friend class CaoTuvEncode;
   friend class CaoTuvWriter;

public:

   // RXgN^ƃfXgN^
   CInputPin(CaoTuvWriter *, LPUNKNOWN, CCritSec *, CCritSec *, HRESULT *);
   ~CInputPin();

   // CRenderedInputPin(CBasePin)̏z\bh
   virtual HRESULT CheckMediaType(const CMediaType *);

   // CRenderedInputPiñI[o[Ch
   STDMETHODIMP Receive(IMediaSample *);
   STDMETHODIMP EndOfStream(void);
   HRESULT Stop();
   STDMETHODIMP ReceiveCanBlock() { return S_FALSE;}
   HRESULT BreakConnect();

   STDMETHODIMP NewSegment(REFERENCE_TIME tStart, REFERENCE_TIME tStop, double dRate)
   {
      m_tLast = 0;
      return S_OK;
   }

   // [U֐
   HRESULT SetVorbisFormat(VORBISFORMAT *);
   HRESULT GetVorbisFormat(VORBISFORMAT *);
   HRESULT SetVorbisTag(VORBISTAG *);
   HRESULT SetFileName(LPCOLESTR);

private:

   // gpϐ
   CaoTuvWriter * const m_pFilter;
   CCritSec *m_pReceiveLock;
   REFERENCE_TIME m_tLast;
   WAVEFORMATEX m_InputWaveFormatEx;
   CaoTuvEncode *paoTuvEncode;
   WCHAR m_awFileName[MAX_PATH];
   VORBISFORMAT m_VorbisFormat;
   VORBISTAG m_VorbisTag;
   bool m_bInitialize;
};
// ------------------------------------------------------------------------------------------------------------------------
class CaoTuvWriter : public CBaseFilter, public IFileSinkFilter, public ISpecifyPropertyPages, public IaoTuvInterface
{
   friend class CInputPin;

public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CaoTuvWriter(LPUNKNOWN,HRESULT *);
   ~CaoTuvWriter();

   // IuWFNg쐬֐
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   // CBaseFilteȑz\bh
   virtual CBasePin *GetPin(int n);
   virtual int GetPinCount();

   // ISpecifyPropertyPages̃I[o[Ch
   STDMETHODIMP GetPages(CAUUID *);

   // IaoTuvInterfacẽI[o[Ch
   STDMETHODIMP SetVorbisFormat(void *);
   STDMETHODIMP GetVorbisFormat(void *);
   STDMETHODIMP SetVorbisTag(void *);

   // CBaseFilter̃I[o[Ch
   STDMETHODIMP NonDelegatingQueryInterface(REFIID, void **);

   // IFileSinkFilter̃I[o[Ch
   STDMETHODIMP SetFileName(LPCOLESTR, const AM_MEDIA_TYPE *);
   STDMETHODIMP GetCurFile(LPOLESTR *, AM_MEDIA_TYPE *);

private:

   // gpϐ
   CCritSec m_Lock;
   CCritSec m_ReceiveLock;
   CInputPin *m_pInputPin;
   CPosPassThru *m_pPosition;
   WCHAR m_awFileName[MAX_PATH];
};
// ------------------------------------------------------------------------------------------------------------------------


#endif _aoTuvWriter_h_
