/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE aoTuvWriter SOURCE CODE.                *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE OggVorbis SOURCE CODE IS (C) COPYRIGHT 1994-2007             *
 * by the Xiph.Org Foundation http://www.xiph.org/                  *
 *                                                                  *
 * THE aoTuv SOURCE CODE IS (C) COPYRIGHT 2003-2008 Aoyumi          *
 * http://www.geocities.jp/aoyoume/aotuv/                           *
 *                                                                  *
 * THE aoTuvWriter SOURCE CODE IS (C) COPYRIGHT 2008 Cocha          *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#include "aoTuvWriter.h"

// ------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::Receive(IMediaSample *pSample)
{
   HRESULT hr;

   CheckPointer(pSample, E_POINTER);
   CAutoLock lock(m_pReceiveLock);

   if(m_bInitialize == false)
   {
     // łɃt@C݂ȂAt@C폜
      if(::PathFileExists(m_awFileName) != FALSE)
      {
         if(::DeleteFile(m_awFileName) == FALSE)
            return E_FAIL; // t@C폜Ɏs
      }

      m_VorbisFormat.nChannels = m_InputWaveFormatEx.nChannels;
      m_VorbisFormat.nSamplesPerSec = m_InputWaveFormatEx.nSamplesPerSec;

      HRESULT hr;
      hr = paoTuvEncode->EncodeInit(m_awFileName, &m_VorbisFormat, &m_VorbisTag);
      if(FAILED(hr))
         return hr;
   }

   REFERENCE_TIME tStart, tStop;
   pSample->GetTime(&tStart, &tStop);

   m_tLast = tStart;

   BYTE *pbData;
   hr = pSample->GetPointer(&pbData);
   if(FAILED(hr))
      return hr;

   hr = paoTuvEncode->Receive((short *)pbData, pSample->GetActualDataLength() / 2);

   return hr;
}
// ------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::EndOfStream(void)
{  // 󂯎f[^ȂꍇɌĂ΂

   CAutoLock lock(m_pReceiveLock);

   if(paoTuvEncode == NULL)
      return E_FAIL;

   paoTuvEncode->EncodeEnd();
   m_bInitialize = false;

   return CRenderedInputPin::EndOfStream();
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::Stop()
{  // ~{^ꂽꍇɌĂ΂

   CAutoLock lock(m_pReceiveLock);

   if(paoTuvEncode == NULL)
      return E_FAIL;

   paoTuvEncode->EncodeEnd();
   m_bInitialize = false;

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::CheckMediaType(const CMediaType *pMediaType)
{  // ̓sق̃sƌqɌĂ΂

   if(*pMediaType->Subtype() == MEDIASUBTYPE_PCM  &&  *pMediaType->FormatType() == FORMAT_WaveFormatEx)
   {
      if( ((WAVEFORMATEX *)pMediaType->Format())->wFormatTag != WAVE_FORMAT_PCM)
      {  // kPCMȊOȂ󂯕tȂ
         return S_FALSE;
      }

      if( ((WAVEFORMATEX *)pMediaType->Format())->wBitsPerSample != 16)
      {  // 16bitȊOȂ󂯕tȂ
         return S_FALSE;
      }

      if( ((WAVEFORMATEX *)pMediaType->Format())->nSamplesPerSec > 48000)
      {   // TvOg48kHz傫Ȃ󂯕tȂ
         return S_FALSE;
      }

      if( ((WAVEFORMATEX *)pMediaType->Format())->nChannels != 1 && ((WAVEFORMATEX *)pMediaType->Format())->nChannels != 2)
      {   // mXeIȊOȂȂ󂯕tȂ
         return S_FALSE;
      }

      // ͂̉i[Ă
      ::CopyMemory(&m_InputWaveFormatEx, pMediaType->Format(), sizeof(WAVEFORMATEX));

      return S_OK;
   }

   return S_FALSE;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::BreakConnect()
{
   if(m_pFilter->m_pPosition != NULL)
      m_pFilter->m_pPosition->ForceRefresh();

   return CRenderedInputPin::BreakConnect();
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::SetVorbisFormat(VORBISFORMAT *pVorbisFormat)
{
   // ݒi[Ă
   ::CopyMemory(&m_VorbisFormat, pVorbisFormat, sizeof(VORBISFORMAT));

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::GetVorbisFormat(VORBISFORMAT *pVorbisFormat)
{  // GR[hݒ擾

   ::CopyMemory(pVorbisFormat, &m_VorbisFormat, sizeof(VORBISFORMAT));
   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::SetVorbisTag(VORBISTAG *pVorbisTag)
{
   // ݒi[Ă
   ::CopyMemory(&m_VorbisTag, pVorbisTag, sizeof(VORBISTAG));

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::SetFileName(LPCOLESTR pszFileName)
{
   // t@Ci[Ă
   lstrcpyW(m_awFileName, pszFileName);

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CInputPin::CInputPin(CaoTuvWriter *pFilter, LPUNKNOWN pUnk, CCritSec *pLock, CCritSec *pReceiveLock, HRESULT *phr)
   : CRenderedInputPin(NAME("Input"), pFilter, pLock, phr, L"Input"), m_pReceiveLock(pReceiveLock), m_pFilter(pFilter), m_tLast(0)
{  // CInputPiñRXgN^

   paoTuvEncode = new CaoTuvEncode();

   // ϐ̏
   m_bInitialize = false;
   ::ZeroMemory(m_awFileName, MAX_PATH);
   ::ZeroMemory(&m_VorbisFormat, sizeof(VORBISFORMAT));
   ::ZeroMemory(&m_VorbisTag, sizeof(VORBISTAG));

   m_VorbisFormat.fQuality = 0.4f;
   m_VorbisFormat.nMinBitsPerSec = -1;
   m_VorbisFormat.nAvgBitsPerSec = -1;
   m_VorbisFormat.nMaxBitsPerSec = -1;
}
// ------------------------------------------------------------------------------------------------------------------------
CInputPin::~CInputPin()
{  // CInputPiñfXgN^

   if(paoTuvEncode != NULL)
      delete paoTuvEncode;
}
// ------------------------------------------------------------------------------------------------------------------------
