/*
 * Decompiled with CFR 0.152.
 */
package dijava;

import dijava.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tokenizer {
    private static final String[] reservedWords = new String[]{"++", "+=", "--", "-=", "**", "*=", "/=", "==", "!=", "&&", "||", "&=", "|=", "abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "default", "do", "else", "extends", "false", "final", "float", "for", "implements", "import", "int", "interface", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throws", "try", "true", "void", "while"};
    private static char[] buf;
    private static int index;
    private static int lastIndex;
    private static Map reservedWord;

    public static String getFileName(List<Token> list) {
        for (int i = 0; i < list.size(); ++i) {
            Token t = list.get(i);
            if (!"class".equals(t.getSentence())) continue;
            if (i + 1 >= list.size()) break;
            t = list.get(i + 1);
            return t.getSentence();
        }
        return null;
    }

    public static int getNestCount(List<Token> list) {
        int nest = 0;
        for (int i = 0; i < list.size(); ++i) {
            Token t = list.get(i);
            if ("{".equals(t.getSentence())) {
                ++nest;
                continue;
            }
            if (!"}".equals(t.getSentence())) continue;
            --nest;
        }
        return nest;
    }

    public static void main(String[] args) {
        String source = "package just.generated;\nimport java.lang.annotation.Retention; //\u30c6\u30b9\u30c8\u30b3\u30e1\u30f3\u30c8\nimport java.lang.annotation.RetentionPolicy;\npublic class Hello {\n@Retention(RetentionPolicy.RUNTIME)\n@interface StringAnnotation {\nString value();\n}\n   @StringAnnotation(\"\u30e1\u30c3\u30bd\u30c9\")\n\tpublic static void main(String... args) {\n\t\tSystem.out.println(new Object() {\n\t\t\tpublic String toString() {\n\t\t\t\treturn \"just hellofasdf\\\"das!\";\n\t\t\t}\n\t\t});\n\t}\n}\n";
        List<Token> l = Tokenizer.split(source);
        for (Token s : l) {
            System.out.println(s.getSentence());
        }
    }

    public static List<Token> split(String source) {
        buf = source.toCharArray();
        index = 0;
        lastIndex = buf.length;
        if (reservedWord.size() == 0) {
            for (int i = 0; i < reservedWords.length; ++i) {
                reservedWord.put(reservedWords[i], reservedWords[i]);
            }
        }
        ArrayList<Token> list = new ArrayList<Token>();
        while (Tokenizer.isGetChar()) {
            char c = Tokenizer.getChar();
            if (Character.isWhitespace(c)) continue;
            if (Character.isDigit(c)) {
                list.add(Tokenizer.readNumber(c));
                continue;
            }
            if (c == '/') {
                list.add(Tokenizer.readComment(c));
                continue;
            }
            if (c == '\"') {
                list.add(Tokenizer.readString());
                continue;
            }
            if (c == '+' || c == '-' || c == '*' || c == '/' || c == '|' || c == '&' || c == '!' || c == '>' || c == '<') {
                list.add(Tokenizer.readSymbol(c));
                continue;
            }
            if (Tokenizer.isSymbol(c)) {
                list.add(new Token("" + c, "" + c, 5));
                continue;
            }
            list.add(Tokenizer.readIdentifier(c));
        }
        return list;
    }

    private static boolean isSymbol(char ch) {
        if (ch < 'A') {
            return true;
        }
        return ch == '{' || ch == '}' || ch == '[' || ch == ']';
    }

    private static char getChar() {
        char c = buf[index];
        ++index;
        return c;
    }

    private static boolean isGetChar() {
        return index < lastIndex;
    }

    private static char nextChar() {
        return buf[index];
    }

    private static boolean isNextChar() {
        return index < lastIndex;
    }

    private static Token readNumber(char head) {
        StringBuffer str = new StringBuffer().append(head);
        while (Tokenizer.isNextChar() && Character.isDigit(Tokenizer.nextChar())) {
            str.append(Tokenizer.getChar());
        }
        return new Token(str.toString(), str.toString(), 1, Long.class);
    }

    private static Token readSymbol(char c) {
        char nc = Tokenizer.nextChar();
        if (c == nc || nc == '=') {
            Tokenizer.getChar();
            return new Token("" + c + nc, "" + c + nc, 2, String.class);
        }
        return new Token(String.valueOf(c), String.valueOf(c), 2, String.class);
    }

    private static Token readIdentifier(char head) {
        StringBuffer str = new StringBuffer().append(head);
        while (Tokenizer.isNextChar() && Character.isLetterOrDigit(Tokenizer.nextChar())) {
            str.append(Tokenizer.getChar());
        }
        String word = str.toString();
        if (reservedWord.containsKey(word)) {
            return new Token(word, word, 6, String.class);
        }
        return new Token(word, word, 7, String.class);
    }

    private static Token readString() {
        StringBuffer str = new StringBuffer();
        while (Tokenizer.isGetChar()) {
            char c = Tokenizer.getChar();
            str.append(c);
            if (!Tokenizer.isNextChar()) break;
            if ('\"' != Tokenizer.nextChar() || '\\' == c) continue;
            Tokenizer.getChar();
            break;
        }
        return new Token(str.toString(), str.toString(), 8, String.class);
    }

    private static Token readComment(char c) {
        char nch = Tokenizer.nextChar();
        if (nch == '/') {
            return Tokenizer.readLF(c);
        }
        if (nch == '*') {
            return Tokenizer.readMultiComment(c);
        }
        return new Token("", String.valueOf(c) + String.valueOf(nch), 9, String.class);
    }

    private static Token readLF(char head) {
        StringBuffer str = new StringBuffer();
        str.append(head);
        char c = Tokenizer.getChar();
        str.append(c);
        while (c != '\n' && c != '\u0000') {
            c = Tokenizer.getChar();
            str.append(c);
        }
        return new Token(str.toString(), str.toString(), 3, String.class);
    }

    private static Token readMultiComment(char head) {
        StringBuffer str = new StringBuffer();
        str.append(head);
        char c = Tokenizer.getChar();
        str.append(c);
        while (Tokenizer.isGetChar()) {
            c = Tokenizer.getChar();
            str.append(c);
            char nch = Tokenizer.nextChar();
            if (c != '*' || nch != '/') continue;
            str.append(Tokenizer.getChar());
            break;
        }
        return new Token(str.toString(), str.toString(), 3, String.class);
    }

    static {
        reservedWord = new HashMap();
    }
}

