/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class TabPanel
extends JPanel {
    private File editingFile;
    private String editingFileEncoding;
    private File prevFile;
    private boolean hasChanged = false;
    private static Icon icon = new CloseTabIcon();
    private static final Dimension buttonSize = new Dimension(icon.getIconWidth(), icon.getIconHeight());
    JButton button = new JButton(icon);
    JLabel label = new JLabel();
    final Dimension ldim;

    public boolean isHasChanged() {
        return this.hasChanged;
    }

    public void setHasChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
    }

    public TabPanel(final JTabbedPane pane, String title, final Component content) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.label.setText(title);
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
        this.ldim = new Dimension(80, this.label.getPreferredSize().height);
        this.label.setPreferredSize(this.ldim);
        this.button.setBorderPainted(false);
        this.button.setFocusPainted(false);
        this.button.setContentAreaFilled(false);
        this.button.setFocusable(false);
        this.button.setVisible(true);
        this.button.setPreferredSize(buttonSize);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = pane.indexOfComponent(content);
                pane.removeTabAt(idx);
                int count = pane.getTabCount();
                if (count > idx) {
                    TabPanel tabPanel = (TabPanel)pane.getTabComponentAt(idx);
                }
            }
        });
        this.add((Component)this.label, "Center");
        this.add((Component)this.button, "East");
    }

    public void setTitle(String title) {
        this.label.setText(title);
    }

    public void setButtonVisible(boolean flag) {
        Dimension dim = this.getPreferredSize();
        this.button.setVisible(flag);
        if (flag) {
            int lwidth = dim.width - this.button.getPreferredSize().width;
            this.label.setPreferredSize(new Dimension(lwidth, this.ldim.height));
        } else {
            this.label.setPreferredSize(this.ldim);
        }
        this.setPreferredSize(dim);
    }

    public File getEditingFile() {
        return this.editingFile;
    }

    public void setEditingFile(File editingFile) {
        this.editingFile = editingFile;
    }

    public String getEditingFileEncoding() {
        return this.editingFileEncoding;
    }

    public void setEditingFileEncoding(String editingFileEncoding) {
        this.editingFileEncoding = editingFileEncoding;
    }

    public File getPrevFile() {
        return this.prevFile;
    }

    public void setPrevFile(File prevFile) {
        this.prevFile = prevFile;
    }

    private static class CloseTabIcon
    implements Icon {
        private int width = 12;
        private int height = 12;

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(Color.GRAY);
            g.drawLine(2, 3, 9, 10);
            g.drawLine(2, 4, 8, 10);
            g.drawLine(3, 3, 9, 9);
            g.drawLine(9, 3, 2, 10);
            g.drawLine(9, 4, 3, 10);
            g.drawLine(8, 3, 2, 9);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }
}

